/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.AlreadyThereException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.InvalidParameterException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.MalformedElementException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.NotThereException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.StoreException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task.ExecutionResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task.TaskResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.TaskStore;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.Execution;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ImportTask;

public class TaskResource {
    private String taskId;

    public TaskResource(String taskId) {
        this.taskId = taskId;
    }

    @GET
    public Response getTask() {
        try {
            ImportTask task = new TaskStore().getTask(this.taskId);
            return Response.ok().entity((Object)task).build();
        }
        catch (MalformedElementException | StoreException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (InvalidParameterException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (NotThereException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="executions")
    public Response getExecutions() {
        try {
            List tasks = new TaskStore().getExecutions(this.taskId);
            1 out = new /* Unavailable Anonymous Inner Class!! */;
            return Response.ok((Object)out).build();
        }
        catch (MalformedElementException | StoreException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (InvalidParameterException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (NotThereException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @Path(value="executions/{executionId}")
    public ExecutionResource getExecution(@PathParam(value="executionId") String executionId) {
        return new ExecutionResource(this.taskId, executionId);
    }

    @POST
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    @Path(value="executions")
    public Response addExecution(Execution execution) {
        try {
            Execution out = new TaskStore().addExecution(this.taskId, execution);
            return Response.ok().entity((Object)out).build();
        }
        catch (MalformedElementException | StoreException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (NotThereException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (AlreadyThereException | InvalidParameterException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }
}

