/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.FileAlreadyExistsException;
import java.text.ParseException;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ImportOptions;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.NotThereException;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.Execution;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ExecutionReport;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ImportTask;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.SubmissionInfo;

/*
 * Exception performing whole class analysis ignored.
 */
public class TaskStoreHelper {
    private String root;
    public static final String IMPORT_PARAMETERS_FILE_NAME = "import-parameters.xml";
    public static final String SUBMISSION_INFO_FILE_NAME = "submission-info.xml";
    public static final String EXECUTIONS_DIR_NAME = "executions";
    public static final String EXECUTION_INFO_FILE_NAME = "execution-info.xml";
    public static final String REPORTS_DIR_NAME = "reports";

    public TaskStoreHelper(String root) {
        this.root = root;
    }

    public File getRoot() {
        return new File(this.root);
    }

    public String[] getAllTasks() {
        return this.getRoot().list();
    }

    public File getTaskRoot(String taskId) {
        return new File(this.getRoot(), taskId);
    }

    private File getTaskParameters(String taskId) {
        return new File(this.getTaskRoot(taskId), "import-parameters.xml");
    }

    private File getTaskContext(String taskId) {
        return new File(this.getTaskRoot(taskId), "submission-info.xml");
    }

    public File getExecutionsRoot(String taskId) {
        return new File(this.getTaskRoot(taskId), "executions");
    }

    public String[] getAllExecutions(String taskId) {
        return this.getExecutionsRoot(taskId).list();
    }

    public String getLastExecution(String taskId) {
        String[] allExecutions = this.getAllExecutions(taskId);
        if (allExecutions == null || allExecutions.length == 0) {
            return null;
        }
        TreeSet<Long> ids = new TreeSet<Long>();
        for (String s : allExecutions) {
            try {
                ids.add(Long.parseLong(s));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (ids.isEmpty()) {
            return null;
        }
        return ((Long)ids.last()).toString();
    }

    public File getExecutionRoot(String taskId, String executionId) {
        return new File(this.getExecutionsRoot(taskId), executionId);
    }

    public File getExecutionInfoFile(String taskId, String executionId) {
        return new File(this.getExecutionRoot(taskId, executionId), "execution-info.xml");
    }

    public File getExecutionReportsRoot(String taskId, String executionId) {
        return new File(this.getExecutionRoot(taskId, executionId), "reports");
    }

    public String[] getAllExecutionReports(String taskId, String executionId) {
        return this.getExecutionReportsRoot(taskId, executionId).list();
    }

    public File getExecutionReport(String taskId, String executionId, String reportName) {
        return new File(this.getExecutionReportsRoot(taskId, executionId), reportName);
    }

    public ImportTask deserializeTask(String taskId) throws JAXBException, NotThereException, IOException, ParseException {
        ImportTask t = new ImportTask();
        t.setId(taskId);
        t.setImportParameters(this.deserializeOptions(taskId));
        t.setSubmissionInfo(this.deserializeContext(taskId));
        return t;
    }

    public ImportOptions deserializeOptions(String taskId) throws JAXBException, NotThereException, IOException, ParseException {
        this.ensureTask(taskId);
        File optionsFile = TaskStoreHelper.ensureExist((File)this.getTaskParameters(taskId));
        String xml = FileUtils.readFileToString((File)optionsFile, (String)"UTF-8");
        return (ImportOptions)TaskStoreHelper.fromXml((String)xml, ImportOptions.class);
    }

    public SubmissionInfo deserializeContext(String taskId) throws NotThereException, IOException, ParseException, JAXBException {
        this.ensureTask(taskId);
        File contextFile = TaskStoreHelper.ensureExist((File)this.getTaskContext(taskId));
        String xml = FileUtils.readFileToString((File)contextFile, (String)"UTF-8");
        return (SubmissionInfo)TaskStoreHelper.fromXml((String)xml, SubmissionInfo.class);
    }

    public Execution deserializeExecution(String taskId, String executionId) throws NotThereException, FileNotFoundException, ParseException, IOException, JAXBException {
        File execFile = this.ensureExecutionInfo(taskId, executionId);
        String xml = FileUtils.readFileToString((File)execFile, (String)"UTF-8");
        return (Execution)TaskStoreHelper.fromXml((String)xml, Execution.class);
    }

    public static void serializeTask(File taskDir, ImportTask task) throws IOException, JAXBException {
        taskDir.mkdirs();
        if (task.getSubmissionInfo() != null) {
            TaskStoreHelper.serializeContext((File)new File(taskDir, "submission-info.xml"), (SubmissionInfo)task.getSubmissionInfo());
        }
        if (task.getImportParameters() != null) {
            TaskStoreHelper.serializeImportParameters((File)new File(taskDir, "import-parameters.xml"), (ImportOptions)task.getImportParameters());
        }
    }

    public static void serializeContext(File file, SubmissionInfo submissionInfo) throws IOException, JAXBException {
        FileUtils.writeStringToFile((File)file, (String)TaskStoreHelper.toXml((Object)submissionInfo), (String)"UTF-8");
    }

    public static void serializeImportParameters(File file, ImportOptions options) throws IOException, JAXBException {
        FileUtils.writeStringToFile((File)file, (String)TaskStoreHelper.toXml((Object)options), (String)"UTF-8");
    }

    public static void serializeExecution(File file, Execution execution) throws IOException, JAXBException {
        FileUtils.writeStringToFile((File)file, (String)TaskStoreHelper.toXml((Object)execution), (String)"UTF-8");
    }

    public static void serializeReport(File file, ExecutionReport report) throws IOException {
        FileUtils.write((File)file, (CharSequence)report.getText(), (String)"UTF-8");
    }

    public static String getContent(File f) throws IOException {
        return FileUtils.readFileToString((File)f, (String)"UTF-8");
    }

    public static void writeContent(File f, String content) throws IOException {
        FileUtils.write((File)f, (CharSequence)content, (String)"UTF-8");
    }

    public File ensureTask(String taskId) throws FileNotFoundException {
        return TaskStoreHelper.ensureExist((File)this.getTaskRoot(taskId));
    }

    public File ensureTaskMiss(String taskId) throws FileAlreadyExistsException {
        return TaskStoreHelper.ensureDontExist((File)this.getTaskRoot(taskId));
    }

    public File ensureExecutionInfo(String taskId, String executionId) throws FileNotFoundException {
        this.ensureTask(taskId);
        return TaskStoreHelper.ensureExist((File)this.getExecutionInfoFile(taskId, executionId));
    }

    public File ensureExecutionInfoMiss(String taskId, String executionId) throws FileNotFoundException, FileAlreadyExistsException {
        this.ensureTask(taskId);
        return TaskStoreHelper.ensureDontExist((File)this.getExecutionInfoFile(taskId, executionId));
    }

    public File ensureReport(String taskId, String executionId, String reportName) throws FileNotFoundException {
        this.ensureExecutionInfo(taskId, executionId);
        return TaskStoreHelper.ensureExist((File)this.getExecutionReport(taskId, executionId, reportName));
    }

    public File ensureReportMiss(String taskId, String executionId, String reportName) throws FileNotFoundException, FileAlreadyExistsException {
        this.ensureExecutionInfo(taskId, executionId);
        return TaskStoreHelper.ensureDontExist((File)this.getExecutionReport(taskId, executionId, reportName));
    }

    public static File ensureExist(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException("no such file: " + f.getAbsolutePath());
        }
        return f;
    }

    public static File ensureDontExist(File f) throws FileAlreadyExistsException {
        if (f.exists()) {
            throw new FileAlreadyExistsException("file " + f.getAbsolutePath() + " already exists");
        }
        return f;
    }

    private static String toXml(Object options) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{options.getClass()});
        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter writer = new StringWriter();
        jaxbMarshaller.marshal(options, (Writer)writer);
        return writer.toString();
    }

    private static Object fromXml(String xml, Class clazz) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        StringReader reader = new StringReader(xml);
        return unmarshaller.unmarshal((Reader)reader);
    }
}

