/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.UriInfo;

import org.gcube.dataanalysis.copernicus.cmems.client.SearchOptions;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.InvalidParameterException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.DatasetBrowser;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.util.ParamUtils;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsKeyword;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsProduct;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsRegion;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsVariable;
import org.gcube.dataanalysis.copernicus.motu.model.MotuServer;
import org.gcube.dataanalysis.datasetimporter.util.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Paolo Fabriani
 *
 */
@Path("/cmems")
public class CmemsResource extends AbstractImporterResource {

    private static Logger logger = LoggerFactory.getLogger(CmemsResource.class); 
    
    @GET
    @Path("products")
    @Produces(MediaType.APPLICATION_XML)
    public Response getProducts(@Context UriInfo uriInfo) {
        
        MultivaluedMap<String, String> queryParams = null;
        if(uriInfo!=null) {
            queryParams = uriInfo.getQueryParameters();
        }
        
        // prepare search options
        SearchOptions options = null;
        try {
            options = ParamUtils.queryParamsToSearchOptions(queryParams);
        } catch (InvalidParameterException e) {
            return Response.status(Status.BAD_REQUEST).build();
        }
        
        // finally search for products
        try {
            Collection<CmemsProduct> products = new DatasetBrowser().searchProducts(options);
            GenericEntity<Collection<CmemsProduct>> entity = new GenericEntity<Collection<CmemsProduct>>(products) {};
            return Response.ok(entity).build();
        } catch (Exception e) {
            logger.error(e.toString());
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path("motu")
    @Produces(MediaType.APPLICATION_XML)
    public Response getMotus() {
        try {
            List<MotuServer> motus = new ArrayList<>(new DatasetBrowser().getMotuServers());
            GenericEntity<List<MotuServer>> entity = new GenericEntity<List<MotuServer>>(motus) {};
            Response response = Response.ok(entity).build();
            return response;
        } catch (Exception e) {
            logger.error(e.getMessage());
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path("regions")
    @Produces(MediaType.APPLICATION_XML)
    public Response getRegions() {
        try {
            List<CmemsRegion> regions = new ArrayList<>(new DatasetBrowser().getRegionalDomains());
            GenericEntity<List<CmemsRegion>> entity = new GenericEntity<List<CmemsRegion>>(regions) {};
            Response response = Response.ok(entity).build();
            return response;
        } catch (Exception e) {
            logger.error(e.getMessage());
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path("keywords")
    @Produces(MediaType.APPLICATION_XML)
    public Response getKeywords() {
        try {
            List<CmemsKeyword> keywords = new ArrayList<>(new DatasetBrowser().getKeywords());
            GenericEntity<List<CmemsKeyword>> entity = new GenericEntity<List<CmemsKeyword>>(keywords) {};
            Response response = Response.ok(entity).build();
            return response;
        } catch (Exception e) {
            logger.error(e.getMessage());
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path("variables")
    @Produces(MediaType.APPLICATION_XML)
    public Response getVariables() {
        try {
            List<CmemsVariable> variables = new ArrayList<>(new DatasetBrowser().getOceanKeys());
            GenericEntity<List<CmemsVariable>> entity = new GenericEntity<List<CmemsVariable>>(variables) {};
            Response response = Response.ok(entity).build();
            return response;
        } catch (Exception e) {
            logger.error(e.toString());
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path("minTime")
    @GET
    public Response getMinTime() {
        try {
            String time = TimeUtil.toString(new DatasetBrowser().getMinTime());
            Response response = Response.ok(time).build();
            return response;
        } catch(Exception e) {
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path("maxTime")
    @GET
    public Response getMaxTime() {
        try {
            String time = TimeUtil.toString(new DatasetBrowser().getMaxTime());
            Response response = Response.ok(time).build();
            return response;
        } catch(Exception e) {
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path("products/{productId}")
    public ProductResource getProduct(@PathParam("productId") String productId) {
        return new ProductResource(productId);
    }

    @GET
    @Path("test")
    public String test() {
        return "Hello world!";
    }

}
