/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task;

import java.util.Collection;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.AlreadyThereException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.InvalidParameterException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.MalformedElementException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.NotThereException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.StoreException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.TaskStore;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.Execution;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ImportTask;

/**
 * @author Paolo Fabriani
 *
 */
public class TaskResource {

    private String taskId;
    
    public TaskResource(String taskId) {
        this.taskId = taskId;
    }
    
    /**
     * Return import parameters for the given task
     * @param taskId
     * @return
     */
    @GET
    public Response getTask() {
        try {
            ImportTask task = new TaskStore().getTask(this.taskId);
            return Response.ok().entity(task).build();
        } catch (MalformedElementException | StoreException e) {
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        } catch (InvalidParameterException e) {
            return Response.status(Status.BAD_REQUEST).build();
        } catch (NotThereException e) {
            return Response.status(Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path("executions")
    public Response getExecutions() {
        try {
            List<Execution> tasks = new TaskStore().getExecutions(this.taskId);
            GenericEntity<Collection<Execution>> out = new GenericEntity<Collection<Execution>>(tasks) {};
            return Response.ok(out).build();
        } catch (MalformedElementException | StoreException e) {
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        } catch (InvalidParameterException e) {
            return Response.status(Status.BAD_REQUEST).build();
        } catch (NotThereException e) {
            return Response.status(Status.NOT_FOUND).build();
        }
    }

    @Path("executions/{executionId}")
    public ExecutionResource getExecution(@PathParam("executionId") String executionId) {
        return new ExecutionResource(this.taskId, executionId);
    }    

    @POST
    @Produces(MediaType.APPLICATION_XML)
    @Consumes(MediaType.APPLICATION_XML)
    @Path("executions")
    public Response addExecution(Execution execution) {
        try {
            Execution out = new TaskStore().addExecution(this.taskId, execution);
            return Response.ok().entity(out).build();
        } catch (MalformedElementException | StoreException e) {
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        } catch (NotThereException e) {
            return Response.status(Status.NOT_FOUND).build();
        } catch (AlreadyThereException | InvalidParameterException e) {
            return Response.status(Status.BAD_REQUEST).build();
        }
    }

    
}
