/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems;

import java.util.Collection;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ImportOptions;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ValidationError;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.InvalidParameterException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.DatasetBrowser;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.validation.RequestValidator;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.util.ParamUtils;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsDataset;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsProduct;
import org.gcube.dataanalysis.copernicus.motu.model.ProductMetadataInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractImporterResource {
    private static Logger logger = LoggerFactory.getLogger(AbstractImporterResource.class);

    protected ImportOptions extractImportParameters(@Context UriInfo uriInfo) throws InvalidParameterException {
        MultivaluedMap queryParams = uriInfo.getQueryParameters();
        ImportOptions options = ParamUtils.queryParamsToImportOptions((MultivaluedMap)queryParams);
        return options;
    }

    protected Collection<ValidationError> checkSchedule(ImportOptions options) throws Exception {
        return RequestValidator.checkScheduleOptions((ImportOptions)options);
    }

    protected Collection<ValidationError> check(ImportOptions options) throws Exception {
        Collection errors = RequestValidator.validateForProductMetadata((ImportOptions)options);
        if (!errors.isEmpty()) {
            return errors;
        }
        logger.debug("Product and datasets are set in the request:");
        logger.debug(options.toString());
        DatasetBrowser datasetBrowser = new DatasetBrowser();
        CmemsProduct product = datasetBrowser.getProduct(options.getProduct());
        if (product == null) {
            errors.add(new ValidationError("product", "No such product: " + options.getProduct()));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        logger.debug("Product retrieved:");
        logger.debug(product.toString());
        RequestValidator.applyDefaults((ImportOptions)options, (CmemsProduct)product);
        logger.debug("Defaults applied. Here is the product:");
        logger.debug(product.toString());
        if (!RequestValidator.isEmpty((Object)options.getMotu()) && !options.getMotu().equals(product.getMotuServer())) {
            errors.add(new ValidationError("motu", "Invalid motu server for product: " + options.getProduct()));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        logger.debug("Motu is OK:");
        logger.debug(options.toString());
        boolean found = false;
        for (CmemsDataset dataset : product.getTdsDatasets()) {
            if (!dataset.getName().equals(options.getDataset())) continue;
            found = true;
            break;
        }
        if (!found) {
            errors.add(new ValidationError("dataset", "No such dataset: " + options.getDataset()));
        }
        if (!errors.isEmpty()) {
            return errors;
        }
        logger.debug("Dataset found in CMEMS Online Catalogue.");
        ProductMetadataInfo dataset = datasetBrowser.getMotuDataset(options.getProduct(), options.getDataset());
        logger.debug("Filling missing values...");
        RequestValidator.applyDefaults((ImportOptions)options, (ProductMetadataInfo)dataset);
        logger.debug("Filling missing values with metadata from motu:");
        logger.debug(options.toString());
        errors = RequestValidator.validate((ImportOptions)options, (ProductMetadataInfo)dataset);
        logger.debug("Request validated. Errors found: " + errors.size());
        return errors;
    }
}

