/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems;

import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems.AbstractImporterResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems.ProductResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.DatasetBrowser;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsDataset;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsProduct;
import org.gcube.dataanalysis.copernicus.motu.model.ProductMetadataInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductResource
extends AbstractImporterResource {
    private static Logger logger = LoggerFactory.getLogger(ProductResource.class);
    private String productId;

    public ProductResource(String id) {
        this.productId = id;
    }

    @GET
    public Response getProductResponse() {
        try {
            CmemsProduct p = new DatasetBrowser().getProduct(this.productId);
            if (p != null) {
                return Response.ok((Object)p).build();
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="datasets/tds")
    public Response getTdsDatasets() {
        try {
            return this.buildDatasetsResponse(new DatasetBrowser().getProduct(this.productId).getTdsDatasets());
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="datasets/tds/{datasetId}")
    public Response getProduct(@PathParam(value="datasetId") String datasetId) {
        try {
            ProductMetadataInfo pmi = new DatasetBrowser().getMotuDataset(this.productId, datasetId);
            return Response.ok((Object)pmi).build();
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="datasets/wms")
    public Response getWmsDatasets() {
        try {
            return this.buildDatasetsResponse(new DatasetBrowser().getProduct(this.productId).getWmsDatasets());
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="datasets/ftp")
    public Response getFtpDatasets() {
        try {
            return this.buildDatasetsResponse(new DatasetBrowser().getProduct(this.productId).getFtpDatasets());
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Path(value="datasets/dgf")
    public Response getDgfDatasets() {
        try {
            return this.buildDatasetsResponse(new DatasetBrowser().getProduct(this.productId).getDgfDatasets());
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Response buildDatasetsResponse(Collection<CmemsDataset> ds) {
        ArrayList<CmemsDataset> datasets = new ArrayList<CmemsDataset>(ds);
        1 entity = new /* Unavailable Anonymous Inner Class!! */;
        Response response = Response.ok((Object)entity).build();
        return response;
    }

    @GET
    @Path(value="documentation")
    public Response getDocumentation() {
        try {
            ArrayList documents = new ArrayList(new DatasetBrowser().getProduct(this.productId).getDocumentation());
            2 entity = new /* Unavailable Anonymous Inner Class!! */;
            Response response = Response.ok((Object)entity).build();
            return response;
        }
        catch (Exception e) {
            logger.error(e.toString());
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

