/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.InvalidParameterException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.MalformedElementException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.NotThereException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.StoreException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems.AbstractImporterResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.TaskStore;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ExecutionReport;

/**
 * @author Paolo Fabriani
 *
 */
public class ReportResource extends AbstractImporterResource {

    private String taskId;
    private String executionId;
    private String reportId;

    public ReportResource(String taskId, String executionId, String reportId) {
        super();
        this.taskId = taskId;
        this.executionId = executionId;
        this.reportId = reportId;
    }
    
    /**
     * Return the given report.
     * @return
     */
    @GET
    public Response getReport() {
        try {
            ExecutionReport report = new TaskStore().getReport(this.taskId, this.executionId, reportId);
            return Response.ok().entity(report).build();
        } catch (MalformedElementException| InvalidParameterException e) {
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        } catch (NotThereException e) {
            return Response.status(Status.NOT_FOUND).build();
        }
    }        

    /**
     * Return the given report.
     * @return
     */
    @GET
    @Path("text")
    @Produces(MediaType.TEXT_PLAIN)
    public Response getReportText() {
        try {
            ExecutionReport report = new TaskStore().getReport(this.taskId, this.executionId, reportId);
            return Response.ok().entity(report.getText()).build();
        } catch (MalformedElementException| InvalidParameterException e) {
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        } catch (NotThereException e) {
            return Response.status(Status.NOT_FOUND).build();
        }
    }        

    /**
     * Update the content of a report.
     * 
     * @param report
     * @return
     */
    @PUT
    @Produces(MediaType.APPLICATION_XML)
    @Consumes(MediaType.APPLICATION_XML)
    public Response update(ExecutionReport report) {
        try {
            report.setName(this.reportId);
            ExecutionReport out = new TaskStore().update(this.taskId, this.executionId, report);
            return Response.ok().entity(out).build();
        } catch (MalformedElementException | StoreException | InvalidParameterException e) {
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        } catch (NotThereException e) {
            return Response.status(Status.NOT_FOUND).build();
        }
    }
    
}
