/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.clients;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Cluster;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Host;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.tmatesoft.svn.core.SVNException;

public class ISClient {
    private CSVReader reader;

    public Host getDataminer(String hostname) {
        Host h = new Host();
        boolean remote2 = true;
        if (!remote2) {
            h.setName("dataminer1-devnext.d4science.org");
            return h;
        }
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/RunTime/HostedOn/text() eq '" + hostname + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        ServiceEndpoint a = (ServiceEndpoint)resources.get(0);
        h.setName(a.profile().runtime().hostedOn());
        return h;
    }

    public String getHProxy() {
        Host h = new Host();
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Platform/Name/text() eq 'DataMinerAlone'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        h.setName(((ServiceEndpoint)resources.get(0)).profile().runtime().hostedOn());
        return h.getName();
    }

    public Cluster getClusterByHProxy() throws IOException {
        String[] nextLine;
        Cluster cl = new Cluster();
        String HProxy = this.getHProxy();
        URL stockURL = new URL("http://data.d4science.org/Yk4zSFF6V3JOSytNd3JkRDlnRFpDUUR5TnRJZEw2QjRHbWJQNStIS0N6Yz0");
        BufferedReader in = new BufferedReader(new InputStreamReader(stockURL.openStream()));
        this.reader = new CSVReader((Reader)in);
        while ((nextLine = this.reader.readNext()) != null) {
            if (!HProxy.contains(nextLine[0])) continue;
            cl.setName(nextLine[0]);
        }
        return cl;
    }

    public List<Host> listDataMinersByCluster() throws IOException {
        String[] nextLine;
        Cluster cluster = this.getClusterByHProxy();
        LinkedList<Host> out = new LinkedList<Host>();
        URL stockURL = new URL("http://data.d4science.org/Yk4zSFF6V3JOSytNd3JkRDlnRFpDUUR5TnRJZEw2QjRHbWJQNStIS0N6Yz0");
        BufferedReader in = new BufferedReader(new InputStreamReader(stockURL.openStream()));
        this.reader = new CSVReader((Reader)in, ',');
        while ((nextLine = this.reader.readNext()) != null) {
            if (!nextLine[0].equals(cluster.getName())) continue;
            Host a = new Host();
            a.setName(nextLine[1]);
            out.add(a);
            System.out.println(a.getFullyQualifiedName());
        }
        return out;
    }

    public Collection<Host> listDataminersInVRE() {
        boolean remote = false;
        if (!remote) {
            Vector<Host> out = new Vector<Host>();
            Host h = new Host();
            h.setName("dataminer1-devnext.d4science.org");
            out.add(h);
            return out;
        }
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Platform/Name/text() eq 'DataMiner'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        Vector<Host> out = new Vector<Host>();
        for (ServiceEndpoint r : resources) {
            Host h = new Host();
            h.setName(r.profile().runtime().hostedOn());
            out.add(h);
        }
        return out;
    }

    public static void main(String[] args) throws IOException, SVNException {
        ISClient a = new ISClient();
        ScopeProvider.instance.set("/gcube/devNext/NextNext");
    }
}

