/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.service;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.dataanalysis.dataminer.poolmanager.ansiblebridge.AnsibleBridge;
import org.gcube.dataanalysis.dataminer.poolmanager.clients.ISClient;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Algorithm;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.AlgorithmSet;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Cluster;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Dependency;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Host;
import org.gcube.dataanalysis.dataminer.poolmanager.process.AlgorithmPackageParser;
import org.gcube.dataanalysis.dataminer.poolmanager.rest.PoolManager;
import org.gcube.informationsystem.publisher.AdvancedScopedPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class DataminerPoolManager
implements PoolManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataminerPoolManager.class);

    public String getScriptFromURL(URL url) throws IOException {
        String line;
        if (url == null) {
            return null;
        }
        URLConnection yc = url.openConnection();
        BufferedReader input = new BufferedReader(new InputStreamReader(yc.getInputStream()));
        StringBuffer buffer = new StringBuffer();
        while ((line = input.readLine()) != null) {
            buffer.append(line + "\n");
        }
        String bufferScript = buffer.substring(0, buffer.length());
        input.close();
        return bufferScript;
    }

    public String addAlgorithmToVRE(Algorithm algorithm, String vre) throws IOException {
        AlgorithmSet algoSet = new AlgorithmSet();
        algoSet.setName("fake");
        algoSet.addAlgorithm(algorithm);
        String uuid = UUID.randomUUID().toString();
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        System.out.println(uuid);
        return uuid;
    }

    public String addAlgorithmToHost(Algorithm algorithm, String hostname) throws IOException {
        AlgorithmSet algoSet = new AlgorithmSet();
        algoSet.setName("fake");
        algoSet.addAlgorithm(algorithm);
        String uuid = UUID.randomUUID().toString();
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        System.out.println(uuid);
        return uuid;
    }

    public URL getURLfromWorkerLog(String a) throws MalformedURLException, UnknownHostException {
        File path = new File(System.getProperty("user.home") + File.separator + "/gcube/dataminer-pool-manager/work/" + a + File.separator + "logs");
        path.mkdirs();
        File n = new File(path + File.separator + a);
        return new File(n.getPath()).toURI().toURL();
    }

    public String addAlgorithmsToVRE(AlgorithmSet algorithms, String vre, String uuid) throws IOException {
        Cluster cluster = new Cluster();
        for (Host h : new ISClient().listDataminersInVRE()) {
            cluster.addHost(h);
        }
        AnsibleBridge a = new AnsibleBridge();
        return a.applyAlgorithmSetToCluster(algorithms, cluster, uuid).getWorkerId();
    }

    public String addAlgorithmsToHost(AlgorithmSet algorithms, String hostname, String uuid) throws IOException {
        Cluster cluster = new Cluster();
        cluster.addHost(new ISClient().getDataminer(hostname));
        AnsibleBridge a = new AnsibleBridge();
        return a.applyAlgorithmSetToCluster(algorithms, cluster, uuid).getWorkerId();
    }

    private SVNRepository getSvnRepository(String url) throws SVNException {
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)url));
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager();
        repository.setAuthenticationManager(authManager);
        System.out.println(repository.getLocation());
        return repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> updateSVN(String file, List<String> ldep) throws SVNException, IOException {
        SVNRepository svnRepository = this.getSvnRepository("https://svn.d4science.research-infrastructures.eu/gcube/trunk/data-analysis/RConfiguration/RPackagesManagement/");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            svnRepository.getFile(file, -1L, null, (OutputStream)byteArrayOutputStream);
            String[] lines = byteArrayOutputStream.toString().split("\\r?\\n");
            List aa = this.checkMatch(lines, ldep);
            Collections.sort(aa);
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            byte[] originalContents = byteArrayOutputStream.toByteArray();
            ISVNEditor commitEditor = svnRepository.getCommitEditor("update dependencies", null);
            commitEditor.openRoot(-1L);
            commitEditor.openFile(file, -1L);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (String line : aa) {
                baos.write(line.getBytes());
                baos.write("\n".getBytes());
            }
            byte[] bytes = baos.toByteArray();
            commitEditor.applyTextDelta(file, DataminerPoolManager.md5((byte[])originalContents));
            String checksum = deltaGenerator.sendDelta(file, (InputStream)new ByteArrayInputStream(originalContents), 0L, (InputStream)new ByteArrayInputStream(bytes), (ISVNDeltaConsumer)commitEditor, true);
            commitEditor.closeFile(file, checksum);
            commitEditor.closeEdit();
            List list = aa;
            return list;
        }
        finally {
            svnRepository.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String md5(byte[] contents) {
        byte[] tmp = new byte[1024];
        SVNChecksumInputStream checksumStream = new SVNChecksumInputStream((InputStream)new ByteArrayInputStream(contents), "md5");
        try {
            while (checksumStream.read(tmp) > 0) {
            }
            String string = checksumStream.getDigest();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            SVNFileUtil.closeFile((InputStream)checksumStream);
        }
    }

    public List<String> checkMatch(String[] lines, List<String> ls) {
        HashSet<String> ss = new HashSet<String>(ls);
        ss.addAll(Arrays.asList(lines));
        return new ArrayList<String>(ss);
    }

    public Algorithm extractAlgorithm(String url) throws IOException {
        return new AlgorithmPackageParser().parsePackage(url);
    }

    public void getLogId(Algorithm algo, String vre) {
    }

    public String getLogById(String logId) throws IOException {
        return null;
    }

    public void unPublishScopedResource(GenericResource resource) throws RegistryNotFoundException, Exception {
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        AdvancedScopedPublisher advancedScopedPublisher = new AdvancedScopedPublisher(scopedPublisher);
        String id = resource.id();
        LOGGER.debug("Trying to remove {} with ID {} from {}", new Object[]{resource.getClass().getSimpleName(), id, ScopeProvider.instance.get()});
        advancedScopedPublisher.forceRemove((Resource)resource);
        LOGGER.debug("{} with ID {} removed successfully", (Object)resource.getClass().getSimpleName(), (Object)id);
    }

    public void publishScopedResource(GenericResource a, List<String> scopes) throws RegistryNotFoundException, Exception {
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)a, (Writer)stringWriter);
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        try {
            System.out.println(scopes);
            System.out.println(stringWriter);
            scopedPublisher.create((Resource)a, scopes);
        }
        catch (RegistryNotFoundException e) {
            System.out.println((Object)e);
            throw e;
        }
    }

    public void addAlgToIs(Algorithm algo) {
        GenericResource a = new GenericResource();
        a.newProfile().name(algo.getName()).type("StatisticalManagerAlgorithm").description(algo.getDescription());
        a.profile().newBody(this.getAlgoBody(algo));
        try {
            this.publishScopedResource(a, Arrays.asList(ScopeProvider.instance.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getAlgoBody(Algorithm algo) {
        return "<category>" + algo.getCategory() + "</category>\n<clazz>" + algo.getClazz() + "</clazz>\n<algorithmType>" + algo.getAlgorithmType() + "</algorithmType>\n<skipJava>" + algo.getSkipJava() + "</skipJava>\n<packageURL>" + algo.getPackageURL() + "</packageURL>\n<dependencies>" + algo.getDependencies() + "</dependencies>";
    }

    public void updateAlg(Algorithm algo) {
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/Name/text() eq '" + algo.getName() + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        if (ds.isEmpty()) {
            return;
        }
        GenericResource a = (GenericResource)ds.get(0);
        a.profile().newBody(this.getAlgoBody(algo));
        try {
            scopedPublisher.update((Resource)a);
        }
        catch (RegistryNotFoundException e) {
            e.printStackTrace();
        }
    }

    private Algorithm convertAlgo(GenericResource a) {
        Algorithm out = new Algorithm();
        out.setAlgorithmType(a.profile().body().getElementsByTagName("algorithmType").item(0).getTextContent());
        out.setCategory(a.profile().body().getElementsByTagName("category").item(0).getTextContent());
        out.setClazz(a.profile().body().getElementsByTagName("clazz").item(0).getTextContent());
        out.setName(a.profile().name());
        out.setPackageURL(a.profile().body().getElementsByTagName("packageURL").item(0).getTextContent());
        out.setSkipJava(a.profile().body().getElementsByTagName("skipJava").item(0).getTextContent());
        out.setDescription(a.profile().description());
        HashSet<Dependency> deps = new HashSet<Dependency>();
        for (int i = 0; i < a.profile().body().getElementsByTagName("dependencies").getLength(); ++i) {
            Dependency d1 = new Dependency();
            d1.setName(a.profile().body().getElementsByTagName("dependencies").item(i).getTextContent());
            deps.add(d1);
        }
        out.setDependencies(deps);
        return out;
    }

    public Set<Algorithm> getAlgoFromIs() {
        HashSet<Algorithm> out = new HashSet<Algorithm>();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'StatisticalManagerAlgorithm'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out.add(this.convertAlgo(a));
        }
        return out;
    }
}

