/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.dataanalysis.dataminer.poolmanager.clients.configuration.DMPMClientConfiguratorManager;
import org.gcube.dataanalysis.dataminer.poolmanager.util.exception.EMailException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMail {
    private Logger logger = LoggerFactory.getLogger(SendMail.class);
    private final String WRITE_MESSAGE_ADDRESS_PATH = "2/messages/write-message?gcube-token=";
    private final String USER_ROLES_ADDRESS_PATH = "2/users/get-usernames-by-role?role-name=DataMiner-Manager&gcube-token=";
    private final String SOCIAL_SERVICE_QUERY_CONDITION = "$resource/Profile/ServiceName/text() eq 'SocialNetworking'";
    private final String SOCIAL_SERVICE_URI = "jersey-servlet";
    private final String JSON_MIME_TYPE = "application/json";
    private String socialServiceAddress;

    public void sendNotification(String subject, String body) throws EMailException {
        this.logger.debug("SendNotification");
        this.logger.debug("Notification Subject: " + subject);
        this.logger.debug("Notification Body: " + body);
        this.retrieveSocialService();
        String postBody = this.createPostBody(subject, body);
        String requestForMessage = this.getRequestMessage("2/messages/write-message?gcube-token=");
        this.sendPostRequest(requestForMessage, postBody);
    }

    private String createPostBody(String subject, String body) throws EMailException {
        try {
            List recipientsList = this.getRecipients();
            if (recipientsList == null || recipientsList.isEmpty()) {
                this.logger.error("Invalid recipient list: " + recipientsList);
                throw new EMailException("Unable to send email notification. Invalid recipient list:" + recipientsList);
            }
            JSONObject data = new JSONObject();
            data.put("subject", (Object)subject);
            data.put("body", (Object)body);
            JSONArray recipients = new JSONArray();
            for (String recipient : recipientsList) {
                JSONObject d = new JSONObject();
                d.put("id", (Object)recipient);
                recipients.put((Object)d);
            }
            data.put("recipients", (Object)recipients);
            this.logger.info("Post Body: " + data);
            return data.toString();
        }
        catch (EMailException e) {
            throw e;
        }
        catch (Throwable e) {
            this.logger.error("Error creating the notification body: " + e.getLocalizedMessage(), e);
            throw new EMailException(e);
        }
    }

    private void retrieveSocialService() throws EMailException {
        try {
            XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
            query.addCondition("$resource/Profile/ServiceName/text() eq 'SocialNetworking'");
            DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
            List resources = client.submit((Query)query);
            this.socialServiceAddress = ((GCoreEndpoint.Profile.Endpoint)((GCoreEndpoint)resources.get(0)).profile().endpointMap().get("jersey-servlet")).uri().toString();
            this.logger.info("Retrieved Social Service Address: " + this.socialServiceAddress);
            if (this.socialServiceAddress == null || this.socialServiceAddress.isEmpty()) {
                throw new EMailException("Unable to send email notification. Invalid address in GCoreEndpoint resource on IS.");
            }
        }
        catch (EMailException e) {
            this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            this.logger.error(e.getLocalizedMessage(), e);
            throw new EMailException(e);
        }
    }

    private String getRequestMessage(String addressPath) {
        StringBuilder requestMessageBuilder = new StringBuilder(this.socialServiceAddress);
        if (!this.socialServiceAddress.endsWith("/")) {
            requestMessageBuilder.append('/');
        }
        requestMessageBuilder.append(addressPath).append(SecurityTokenProvider.instance.get());
        String requestForMessage = requestMessageBuilder.toString();
        this.logger.debug("Request " + requestForMessage);
        return requestForMessage;
    }

    private String username(String token) throws ObjectNotFound, Exception {
        AuthorizationEntry entry = Constants.authorizationService().get(token);
        this.logger.debug(entry.getClientInfo().getId());
        return entry.getClientInfo().getId();
    }

    private void sendPostRequest(String endpoint, String postBody) throws EMailException {
        this.logger.info("Execute Post:" + endpoint);
        this.logger.info("Post Body:" + postBody);
        try {
            String line;
            URL url = new URL(endpoint);
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
            writer.write(postBody);
            writer.flush();
            StringBuffer answer = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = reader.readLine()) != null) {
                answer.append(line);
            }
            writer.close();
            reader.close();
            this.logger.debug("Operation completed");
            String response = answer.toString();
            this.logger.info("Notification Response: " + response);
            this.checkResponse(response);
        }
        catch (EMailException e) {
            throw e;
        }
        catch (MalformedURLException e) {
            this.logger.error("Invalid URL: " + e.getLocalizedMessage(), (Throwable)e);
            throw new EMailException((Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("Error in the IO process: " + e.getLocalizedMessage(), (Throwable)e);
            throw new EMailException((Throwable)e);
        }
        catch (Throwable e) {
            this.logger.error("Error executing post:" + e.getLocalizedMessage(), e);
            throw new EMailException(e);
        }
    }

    private void checkResponse(String response) throws EMailException {
        if (response == null) {
            this.logger.error("Invalid notification response: " + response);
            throw new EMailException();
        }
        try {
            JSONObject res = new JSONObject(response);
            boolean success = res.getBoolean("success");
            if (!success) {
                String message = res.getString("message");
                this.logger.error("Error in send email notification: " + message);
                throw new EMailException("Error in send email notification: " + message);
            }
        }
        catch (JSONException e) {
            this.logger.error("Invalid notification response: " + response);
            throw new EMailException((Throwable)e);
        }
    }

    private List<String> getRecipients() {
        try {
            ArrayList<String> recipients = new ArrayList<String>();
            String dataMinerManagers = this.retrieveDataMinerManagers();
            this.logger.debug("Retrieved DataMiner Managers: " + dataMinerManagers);
            if (dataMinerManagers != null && !dataMinerManagers.isEmpty()) {
                JSONObject obj = new JSONObject(dataMinerManagers);
                JSONArray data = obj.getJSONArray("result");
                if (data != null) {
                    for (int i = 0; i < data.length(); ++i) {
                        recipients.add(data.getString(i));
                    }
                }
            } else {
                this.logger.info("Use the default admins how workaround ");
                List defaultManagers = DMPMClientConfiguratorManager.getInstance().getDefaultAdmins();
                recipients.addAll(defaultManagers);
            }
            recipients.add(this.username(SecurityTokenProvider.instance.get()));
            this.logger.info("Retrieved Recipients: " + recipients);
            return recipients;
        }
        catch (Exception e) {
            this.logger.error("Error retrieving recipients: " + e.getLocalizedMessage(), (Throwable)e);
            this.logger.info("Use the default admins how workaround ");
            return DMPMClientConfiguratorManager.getInstance().getDefaultAdmins();
        }
    }

    private String retrieveDataMinerManagers() throws Exception {
        String requestAdminsUrl = this.getRequestMessage("2/users/get-usernames-by-role?role-name=DataMiner-Manager&gcube-token=");
        this.logger.info("Request Admins Url: " + requestAdminsUrl);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet getReq = new HttpGet(requestAdminsUrl);
        getReq.setHeader("accept", "application/json");
        getReq.setHeader("content-type", "application/json");
        this.logger.info("Response: " + EntityUtils.toString((HttpEntity)client.execute((HttpUriRequest)getReq).getEntity()));
        return EntityUtils.toString((HttpEntity)client.execute((HttpUriRequest)getReq).getEntity());
    }
}

