package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.test;

import java.io.File;

import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.clusterers.DBSCAN;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.clusterers.XMEANS;
import org.junit.Test;
import org.n52.wps.io.data.GenericFileData;

public class TestMappedClusterers {

	
	@Test
	public void testDBSCAN() throws Exception{
		DBSCAN algorithm = new DBSCAN();
		
//		algorithm.setScope("/gcube/devsec");
//		algorithm.setUserName("gianpaolo.coro");
		File f1 = new File("./datasets/locallinkshcaf1.txt");
		algorithm.setepsilon(10);
		algorithm.setmin_points(1);
		algorithm.setFeaturesColumnNames("depthmin|depthmax");
		algorithm.setOccurrencePointsClusterLabel("wps_occ_cluster_test");
		algorithm.setOccurrencePointsTable(new GenericFileData(f1,"text/csv"));
		
		algorithm.run();
	}
	
	@Test
	public void testXMEANS() throws Exception{
		XMEANS algorithm = new XMEANS();
		
//		algorithm.setScope("/gcube/devsec");
		
		File f1 = new File("./datasets/locallinkshcaf1.txt");
		algorithm.setmaxClusters(10);
		algorithm.setmin_points(1);
		algorithm.setmaxIterations(1000);
		algorithm.setminClusters(2);
		algorithm.setFeaturesColumnNames("depthmin|depthmax");
		algorithm.setOccurrencePointsClusterLabel("wps_occ_cluster_test");
		algorithm.setOccurrencePointsTable(new GenericFileData(f1,"text/csv"));
		
		algorithm.run();
	}
	
	
}
