/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.capabilities;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.capabilities.GetCapabilitiesChecker;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure.InfrastructureDialoguer;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.ConfigurationManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.TokenManager;
import org.n52.wps.algorithm.annotation.Algorithm;
import org.n52.wps.commons.WPSConfig;
import org.slf4j.LoggerFactory;

public class GetCapabilitiesBuilder {
    public static String processString = "<wps:Process wps:processVersion=\"1.1.0\">\n\t<ows:Identifier>#CLASS#</ows:Identifier>\n\t<ows:Title>#TITLE#</ows:Title>\n</wps:Process>";

    public String buildGetCapabilities(Map<String, String[]> parameters) throws Exception {
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        root.setLevel(Level.OFF);
        LinkedHashMap<String, Object> basicInputs = new LinkedHashMap<String, Object>();
        ConfigurationManager configManager = new ConfigurationManager();
        TokenManager tokenm = new TokenManager();
        tokenm.getCredentials();
        String scope = tokenm.getScope();
        String username = tokenm.getUserName();
        basicInputs.put(ConfigurationManager.scopeParameter, scope);
        basicInputs.put(ConfigurationManager.usernameParameter, username);
        configManager.configAlgorithmEnvironment(basicInputs);
        AnalysisLogger.getLogger().debug((Object)("Initializing Capabilities Skeleton in scope " + configManager.getScope() + " with user " + configManager.getUsername()));
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("templates/wpsCapabilitiesSkeleton.xml");
        String stringTemplate = IOUtils.toString((InputStream)is, (String)"UTF-8");
        String host = InetAddress.getLocalHost().getCanonicalHostName();
        String port = WPSConfig.getInstance().getWPSConfig().getServer().getHostport();
        stringTemplate = stringTemplate.replace("#HOST#", host).replace("#PORT#", port);
        AnalysisLogger.getLogger().debug((Object)("Host: " + host + " Port: " + port));
        String packageS = "org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses";
        LinkedHashMap<String, String> allalgorithms = new LinkedHashMap<String, String>();
        List<Class<?>> classes = null;
        try {
            AnalysisLogger.getLogger().debug((Object)"Taking classes from /classes");
            classes = GetCapabilitiesChecker.find(packageS);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"Taking classes from the Jar");
            classes = GetCapabilitiesChecker.getClassesInSamePackageFromJar(packageS);
        }
        for (Class<?> classfind : classes) {
            Algorithm algorithmInfo = classfind.getAnnotation(Algorithm.class);
            if (algorithmInfo == null) continue;
            AnalysisLogger.getLogger().debug((Object)("Retrieving local declared Algorithm: " + algorithmInfo.title()));
            allalgorithms.put(algorithmInfo.title(), classfind.getName());
        }
        AnalysisLogger.getLogger().debug((Object)"Getting algorithms from the infrastructure");
        InfrastructureDialoguer dialoguer = new InfrastructureDialoguer(configManager.getScope());
        List<String> algorithmsInScope = dialoguer.getAlgorithmsInScope();
        AnalysisLogger.getLogger().debug((Object)("Found " + algorithmsInScope.size() + " algorithms in scope "));
        StringBuffer capabilities = new StringBuffer();
        for (String algorithmInScope : algorithmsInScope) {
            String classAlgorithm = (String)allalgorithms.get(algorithmInScope);
            if (classAlgorithm == null) continue;
            AnalysisLogger.getLogger().debug((Object)("Approving " + classAlgorithm + " to capabilities "));
            capabilities.append(processString.replace("#TITLE#", algorithmInScope).replace("#CLASS#", classAlgorithm));
        }
        stringTemplate = stringTemplate.replace("#PROCESSES#", capabilities.toString());
        AnalysisLogger.getLogger().debug((Object)"Get capabilities built");
        return stringTemplate;
    }

    public static void main(String[] args) throws Exception {
        GetCapabilitiesBuilder builder = new GetCapabilitiesBuilder();
        builder.buildGetCapabilities(null);
    }
}

