/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure.DatabaseInfo;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure.InfrastructureDialoguer;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure.TableCoherenceChecker;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.IClusterer;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.IEvaluator;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.IGenerator;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.IModeller;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.ITransducer;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.ConfigurationManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.InputsManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.OutputsManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.TokenManager;
import org.hibernate.SessionFactory;
import org.n52.wps.algorithm.annotation.Execute;
import org.n52.wps.server.AbstractAnnotatedAlgorithm;
import org.slf4j.LoggerFactory;

public class AbstractEcologicalEngineMapper
extends AbstractAnnotatedAlgorithm {
    public LinkedHashMap<String, Object> inputs = new LinkedHashMap();
    public LinkedHashMap<String, Object> outputs = new LinkedHashMap();
    public LinkedHashMap<String, Long> times = new LinkedHashMap();
    public static HashMap<String, DatabaseInfo> databaseParametersMemoryCache = new HashMap();
    public static HashMap<String, String> runningcomputations = new HashMap();
    public AlgorithmConfiguration config;
    public InfrastructureDialoguer infrastructureDialoguer;

    public static synchronized void addComputation(String session, String user) {
        runningcomputations.put(session, user);
    }

    public static synchronized void removeComputation(String session) {
        runningcomputations.remove(session);
    }

    public static synchronized int getRuningComputations() {
        return runningcomputations.size();
    }

    public static synchronized String displayRunningComputations() {
        return runningcomputations.toString();
    }

    public void waitForResources() throws Exception {
        while (AbstractEcologicalEngineMapper.getRuningComputations() > ConfigurationManager.getMaxComputations()) {
            Thread.sleep(2000L);
            AnalysisLogger.getLogger().debug((Object)("Waiting for resources to be available: " + AbstractEcologicalEngineMapper.displayRunningComputations()));
        }
    }

    public static synchronized DatabaseInfo getDatabaseInfo(String scope) {
        return databaseParametersMemoryCache.get(scope);
    }

    public static synchronized void addDatabaseInfo(String scope, DatabaseInfo info) {
        databaseParametersMemoryCache.put(scope, info);
    }

    public ComputationalAgent getComputationalAgent(String algorithmName) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Searching for Agents.. " + algorithmName));
        List agents = new ArrayList();
        if (this instanceof ITransducer) {
            agents = TransducerersFactory.getTransducerers((AlgorithmConfiguration)this.config);
        } else if (this instanceof IClusterer) {
            agents = ClusterersFactory.getClusterers((AlgorithmConfiguration)this.config);
        } else if (this instanceof IEvaluator) {
            agents = EvaluatorsFactory.getEvaluators((AlgorithmConfiguration)this.config);
        } else if (this instanceof IGenerator) {
            agents = GeneratorsFactory.getGenerators((AlgorithmConfiguration)this.config);
        } else if (this instanceof IModeller) {
            agents = ModelersFactory.getModelers((AlgorithmConfiguration)this.config);
        }
        if (agents != null && agents.size() > 0 && agents.get(0) != null) {
            AnalysisLogger.getLogger().debug((Object)("Found " + agents.size() + " Agents for " + algorithmName));
            ComputationalAgent agent = (ComputationalAgent)agents.get(0);
            agent.setConfiguration(this.config);
            return agent;
        }
        return null;
    }

    public List<StatisticalType> getInputParameters(String algorithmName) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Searching for Agents Inputs.. " + algorithmName));
        List<StatisticalType> parameters = new ArrayList();
        if (this instanceof ITransducer) {
            parameters = TransducerersFactory.getTransducerParameters((AlgorithmConfiguration)this.config, (String)algorithmName);
        } else if (this instanceof IClusterer) {
            parameters = ClusterersFactory.getClustererParameters((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IEvaluator) {
            parameters = EvaluatorsFactory.getEvaluatorParameters((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IGenerator) {
            parameters = GeneratorsFactory.getAlgorithmParameters((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IModeller) {
            parameters = ModelersFactory.getModelParameters((String)this.config.getConfigPath(), (String)algorithmName);
        }
        if (parameters != null) {
            AnalysisLogger.getLogger().debug((Object)("Found " + parameters.size() + " Parameters for " + algorithmName));
            return parameters;
        }
        return null;
    }

    public StatisticalType getOutput(String algorithmName) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Searching for Agents Inputs.. " + algorithmName));
        StatisticalType output = null;
        if (this instanceof ITransducer) {
            output = TransducerersFactory.getTransducerOutput((AlgorithmConfiguration)this.config, (String)algorithmName);
        } else if (this instanceof IClusterer) {
            output = ClusterersFactory.getClustererOutput((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IEvaluator) {
            output = EvaluatorsFactory.getEvaluatorOutput((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IGenerator) {
            output = GeneratorsFactory.getAlgorithmOutput((String)this.config.getConfigPath(), (String)algorithmName);
        } else if (this instanceof IModeller) {
            output = ModelersFactory.getModelOutput((String)this.config.getConfigPath(), (String)algorithmName);
        }
        if (output != null) {
            AnalysisLogger.getLogger().debug((Object)("Found " + output + " for " + algorithmName));
            return output;
        }
        return output;
    }

    public void deleteTemporaryTables(List<String> generatedInputTables) throws Exception {
        block10: {
            if (generatedInputTables != null && generatedInputTables.size() > 0) {
                SessionFactory dbConnection = null;
                try {
                    try {
                        dbConnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
                        for (String table : generatedInputTables) {
                            if (table != null) {
                                if (TableCoherenceChecker.isSystemTable(table)) continue;
                                AnalysisLogger.getLogger().debug((Object)("Dropping Temporary Table: " + table));
                                try {
                                    DatabaseFactory.executeSQLUpdate((String)("drop table " + table), (SessionFactory)dbConnection);
                                }
                                catch (Exception e) {
                                    AnalysisLogger.getLogger().debug((Object)("Could not drop Temporary Table: " + table));
                                }
                                continue;
                            }
                            AnalysisLogger.getLogger().debug((Object)("Could not drop Temporary Table: " + table + " table is null"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        AnalysisLogger.getLogger().debug((Object)e);
                        DatabaseUtils.closeDBConnection((SessionFactory)dbConnection);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    DatabaseUtils.closeDBConnection(dbConnection);
                    throw throwable;
                }
                DatabaseUtils.closeDBConnection((SessionFactory)dbConnection);
            }
        }
    }

    public void deleteGeneratedFiles(List<File> generatedFiles) throws Exception {
        if (generatedFiles != null) {
            for (File file : generatedFiles) {
                if (file.exists()) {
                    AnalysisLogger.getLogger().debug((Object)("Deleting File " + file.getAbsolutePath()));
                    AnalysisLogger.getLogger().debug((Object)("Deleting File Check " + file.delete()));
                    continue;
                }
                AnalysisLogger.getLogger().debug((Object)("File does not exist " + file.getAbsolutePath()));
            }
        }
    }

    public void manageUserToken() {
        String scope = null;
        String username = null;
        TokenManager tokenm = new TokenManager();
        tokenm.getCredentials();
        scope = tokenm.getScope();
        username = tokenm.getUserName();
        this.inputs.put(ConfigurationManager.scopeParameter, scope);
        this.inputs.put(ConfigurationManager.usernameParameter, username);
    }

    @Execute
    public void run() throws Exception {
        String algorithm = "";
        List<String> generatedInputTables = null;
        List<String> generatedOutputTables = null;
        List<File> generatedFiles = null;
        String computationSession = UUID.randomUUID().toString();
        try {
            try {
                this.time("WPS Algorithm objects Initialization: Session " + computationSession);
                Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
                root.setLevel(Level.OFF);
                ConfigurationManager configManager = new ConfigurationManager();
                this.manageUserToken();
                configManager.configAlgorithmEnvironment(this.inputs);
                this.config = configManager.getConfig();
                AnalysisLogger.getLogger().info((Object)("Configured algorithm with session " + computationSession));
                this.time("Configuration");
                this.waitForResources();
                AnalysisLogger.getLogger().info((Object)("Running algorithm with session " + computationSession));
                this.time("Waiting time for resources to be free");
                AbstractEcologicalEngineMapper.addComputation(computationSession, String.valueOf(configManager.getUsername()) + ":" + configManager.getScope());
                String scope = configManager.getScope();
                String username = configManager.getUsername();
                AnalysisLogger.getLogger().info((Object)("1 - Algorithm environment initialized in scope " + scope + " with user name " + username + " and session " + computationSession));
                AnalysisLogger.getLogger().info((Object)("Max allowed computations " + ConfigurationManager.getMaxComputations() + " using storage " + ConfigurationManager.useStorage()));
                AnalysisLogger.getLogger().info((Object)"2 - Initializing connection to the e-Infrastructure");
                this.infrastructureDialoguer = new InfrastructureDialoguer(scope);
                this.time("Connection to the e-Infrastructure initialized");
                AnalysisLogger.getLogger().info((Object)"3 - Initializing connection to the e-Infrastructure central database for computations");
                DatabaseInfo supportDatabaseInfo = AbstractEcologicalEngineMapper.getDatabaseInfo(scope);
                if (supportDatabaseInfo == null) {
                    supportDatabaseInfo = this.infrastructureDialoguer.getDatabaseInfo("StatisticalManagerDataBase");
                    AbstractEcologicalEngineMapper.addDatabaseInfo(scope, supportDatabaseInfo);
                } else {
                    AnalysisLogger.getLogger().info((Object)("Using cached database information: " + supportDatabaseInfo));
                }
                AnalysisLogger.getLogger().info((Object)("Retrieved Central Database: " + supportDatabaseInfo));
                InputsManager inputsManager = new InputsManager(this.inputs, this.config);
                inputsManager.configSupportDatabaseParameters(supportDatabaseInfo);
                this.time("Central database information retrieval");
                AnalysisLogger.getLogger().info((Object)"4 - Retrieving WPS algorithm name");
                algorithm = this.getAlgorithmClass().getSimpleName();
                AnalysisLogger.getLogger().debug((Object)("Selected Algorithm: " + algorithm));
                this.config.setAgent(algorithm);
                this.config.setModel(algorithm);
                this.time("Ecological Engine Algorithm selection");
                AnalysisLogger.getLogger().info((Object)"5 - Adding Service parameters to the configuration");
                inputsManager.addInputServiceParameters(this.getInputParameters(algorithm), this.infrastructureDialoguer);
                this.time("Service parameters added to the algorithm");
                AnalysisLogger.getLogger().info((Object)"6 - Translating WPS Inputs into Ecological Engine Inputs");
                inputsManager.mergeWpsAndEcologicalInputs(supportDatabaseInfo);
                generatedInputTables = inputsManager.getGeneratedTables();
                generatedFiles = inputsManager.getGeneratedInputFiles();
                this.time("Setup and download of input parameters with tables creation");
                AnalysisLogger.getLogger().info((Object)"7 - Retrieving Ecological Engine algorithm");
                ComputationalAgent agent = this.getComputationalAgent(algorithm);
                AnalysisLogger.getLogger().debug((Object)("Found Ecological Engine Algorithm: " + agent));
                this.time("Algorithm initialization");
                AnalysisLogger.getLogger().info((Object)"8 - Retrieving the a priori output of the algorithm");
                StatisticalType prioroutput = null;
                try {
                    prioroutput = this.getOutput(algorithm);
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().info((Object)("Warning: No a priori output for algorithm " + algorithm));
                }
                this.time("A priori output retrieval");
                AnalysisLogger.getLogger().info((Object)"9 - Running the computation");
                agent.init();
                agent.compute();
                AnalysisLogger.getLogger().info((Object)"The computation has finished. Retrieving output");
                this.time("Execution time");
                AnalysisLogger.getLogger().info((Object)"10 - Retrieving the a posteriori output of the algorithm");
                StatisticalType postoutput = agent.getOutput();
                AnalysisLogger.getLogger().debug((Object)("Computation Output: " + postoutput));
                this.time("Output retrieval");
                AnalysisLogger.getLogger().info((Object)"11 - Merging the a priori and a posteriori output");
                OutputsManager outputmanager = new OutputsManager(this.config, computationSession);
                this.outputs = outputmanager.createOutput(prioroutput, postoutput);
                generatedOutputTables = outputmanager.getGeneratedTables();
                if (ConfigurationManager.useStorage().booleanValue()) {
                    generatedFiles.addAll(outputmanager.getGeneratedFiles());
                    this.time("Output preparation for WPS document (using storage)");
                } else {
                    this.time("Output preparation for WPS document (no storage manager)");
                }
                AnalysisLogger.getLogger().info((Object)"12 - Deleting possible generated temporary tables");
                AnalysisLogger.getLogger().debug((Object)("Final Computation Output: " + this.outputs));
                AnalysisLogger.getLogger().debug((Object)"All done");
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)("Error in Algorithm execution: " + algorithm));
                AnalysisLogger.getLogger().debug((Object)e);
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            AnalysisLogger.getLogger().debug((Object)"Deleting Input Tables");
            this.deleteTemporaryTables(generatedInputTables);
            AnalysisLogger.getLogger().debug((Object)"Deleting Output Tables");
            this.deleteTemporaryTables(generatedOutputTables);
            AnalysisLogger.getLogger().debug((Object)"Deleting Files");
            this.deleteGeneratedFiles(generatedFiles);
            AbstractEcologicalEngineMapper.removeComputation(computationSession);
            this.time("Cleaning of resources");
            this.displayTimes();
        }
    }

    private void time(String label) {
        this.times.put(label, System.currentTimeMillis());
    }

    private void displayTimes() {
        AnalysisLogger.getLogger().debug((Object)"Times Summary:");
        AnalysisLogger.getLogger().debug((Object)"Label;Elapsed(ms);Time");
        long prevtime = 0L;
        long inittime = 0L;
        for (String label : this.times.keySet()) {
            long currentTime = this.times.get(label);
            if (prevtime == 0L) {
                prevtime = currentTime;
                inittime = currentTime;
            }
            AnalysisLogger.getLogger().debug((Object)(String.valueOf(label) + ";" + (currentTime - prevtime) + ";" + new Date(currentTime)));
            prevtime = currentTime;
        }
        AnalysisLogger.getLogger().debug((Object)("Total Elapsed;" + (prevtime - inittime) + ";" + new Date(prevtime)));
    }

    private void cleanResources() {
        this.times = null;
        System.gc();
    }
}

