/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.test;

import java.io.File;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.ABSENCE_CELLS_FROM_AQUAMAPS;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.BIONYM_LOCAL;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.FAO_OCEAN_AREA_COLUMN_CREATOR;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.GENERIC_CHARTS;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.GEO_CHART;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.HCAF_FILTER;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.MAX_ENT_NICHE_MODELLING;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.OBIS_MOST_OBSERVED_SPECIES;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.OBIS_MOST_OBSERVED_TAXA;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.OBIS_SPECIES_OBSERVATIONS_PER_LME_AREA;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.OBIS_SPECIES_OBSERVATIONS_PER_YEAR;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.OBIS_TAXA_OBSERVATIONS_PER_YEAR;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.OCCURRENCE_ENRICHMENT;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.PRESENCE_CELLS_GENERATION;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.TIME_SERIES_ANALYSIS;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.XYEXTRACTOR;
import org.junit.Test;
import org.n52.wps.io.data.GenericFileData;

public class TestMappedTransducerers {
    @Test
    public void testBionymLocal() throws Exception {
        BIONYM_LOCAL algorithm = new BIONYM_LOCAL();
        algorithm.setAccuracy_vs_Speed("MAX_ACCURACY");
        algorithm.setSpeciesAuthorName("Gadus morhua (Linnaeus, 1758)");
        algorithm.setTaxa_Authority_File("ASFIS");
        algorithm.setParser_Name("SIMPLE");
        algorithm.setActivate_Preparsing_Processing(false);
        algorithm.setUse_Stemmed_Genus_and_Species(false);
        algorithm.setMatcher_1("GSAy");
        algorithm.setThreshold_1(0.6);
        algorithm.setMaxResults_1(3);
        algorithm.run();
    }

    @Test
    public void testHCAF_FILTER() throws Exception {
        HCAF_FILTER algorithm = new HCAF_FILTER();
        algorithm.setTable_Label("wps_hcaf_filtered");
        algorithm.setB_Box_Left_Lower_Lat(-17.098);
        algorithm.setB_Box_Left_Lower_Long(89.245);
        algorithm.setB_Box_Right_Upper_Lat(25.086);
        algorithm.setB_Box_Right_Upper_Long(147.642);
        algorithm.run();
    }

    @Test
    public void testABSENCE_CELLS_FROM_AQUAMAPS() throws Exception {
        ABSENCE_CELLS_FROM_AQUAMAPS algorithm = new ABSENCE_CELLS_FROM_AQUAMAPS();
        File f1 = new File("./datasets/locallinkshspec1.txt");
        algorithm.setTable_Label("wps_absence_cells");
        algorithm.setAquamaps_HSPEC(new GenericFileData(f1, "text/csv"));
        algorithm.setNumber_of_Points(20);
        algorithm.setTake_Randomly(true);
        algorithm.setSpecies_Code("Fis-30189");
        algorithm.run();
    }

    @Test
    public void testPRESENCE_CELLS_GENERATION() throws Exception {
        PRESENCE_CELLS_GENERATION algorithm = new PRESENCE_CELLS_GENERATION();
        algorithm.setTable_Label("wps_presence_cells");
        algorithm.setNumber_of_Points(20);
        algorithm.setSpecies_Code("Fis-30189");
        algorithm.run();
    }

    @Test
    public void testOBIS_MOST_OBSERVED_SPECIES() throws Exception {
        OBIS_MOST_OBSERVED_SPECIES algorithm = new OBIS_MOST_OBSERVED_SPECIES();
        algorithm.setSpecies_number("5");
        algorithm.setStart_year("1800");
        algorithm.setEnd_year("2013");
        algorithm.run();
    }

    @Test
    public void testOBIS_MOST_OBSERVED_TAXA() throws Exception {
        OBIS_MOST_OBSERVED_TAXA algorithm = new OBIS_MOST_OBSERVED_TAXA();
        algorithm.setTaxa_number("5");
        algorithm.setStart_year("1800");
        algorithm.setEnd_year("2013");
        algorithm.setLevel("GENUS");
        algorithm.run();
    }

    @Test
    public void testOBIS_TAXA_OBSERVATIONS_PER_YEAR() throws Exception {
        OBIS_TAXA_OBSERVATIONS_PER_YEAR algorithm = new OBIS_TAXA_OBSERVATIONS_PER_YEAR();
        algorithm.setSelected_taxonomy("Gadus");
        algorithm.setStart_year("1800");
        algorithm.setEnd_year("2013");
        algorithm.setLevel("GENUS");
        algorithm.run();
    }

    @Test
    public void testOBIS_SPECIES_OBSERVATIONS_PER_LME_AREA() throws Exception {
        OBIS_SPECIES_OBSERVATIONS_PER_LME_AREA algorithm = new OBIS_SPECIES_OBSERVATIONS_PER_LME_AREA();
        algorithm.setArea_type("NORTH_SEA");
        algorithm.setStart_year("1800");
        algorithm.setEnd_year("2013");
        algorithm.setSelected_species("Gadus morhua");
        algorithm.run();
    }

    @Test
    public void testMOST_OBSERVED_SPECIES() throws Exception {
        OBIS_MOST_OBSERVED_SPECIES algorithm = new OBIS_MOST_OBSERVED_SPECIES();
        algorithm.setSpecies_number("5");
        algorithm.setStart_year("1800");
        algorithm.setEnd_year("2013");
        algorithm.run();
    }

    @Test
    public void testSPECIES_OBSERVATIONS_TREND_PER_YEAR() throws Exception {
        OBIS_SPECIES_OBSERVATIONS_PER_YEAR algorithm = new OBIS_SPECIES_OBSERVATIONS_PER_YEAR();
        algorithm.setSelected_species("Gadus morhua");
        algorithm.setStart_year("1800");
        algorithm.setEnd_year("2013");
        algorithm.run();
    }

    @Test
    public void testTAXONOMY_OBSERVATIONS_TREND_PER_YEAR() throws Exception {
        OBIS_TAXA_OBSERVATIONS_PER_YEAR algorithm = new OBIS_TAXA_OBSERVATIONS_PER_YEAR();
        algorithm.setLevel("GENUS");
        algorithm.setSelected_taxonomy("Gadus|Latimeria");
        algorithm.setStart_year("1800");
        algorithm.setEnd_year("2013");
        algorithm.run();
    }

    @Test
    public void testOCCURRENCE_ENRICHMENT() throws Exception {
        OCCURRENCE_ENRICHMENT algorithm = new OCCURRENCE_ENRICHMENT();
        File f1 = new File("./datasets/locallinksspecies2.txt");
        algorithm.setOccurrenceTable(new GenericFileData(f1, "text/csv"));
        algorithm.setScientificNameColumn("scientificname");
        algorithm.setLongitudeColumn("decimallongitude");
        algorithm.setLatitudeColumn("decimallatitude");
        algorithm.setTimeColumn("eventdate");
        algorithm.setOptionalFilter(" ");
        algorithm.setResolution(0.5);
        algorithm.setOutputTableName("wps_enrichment_test");
        algorithm.setLayers("http://thredds.research-infrastructures.eu/thredds/dodsC/public/netcdf/WOA2005TemperatureAnnual_CLIMATOLOGY_METEOROLOGY_ATMOSPHERE_.nc");
        algorithm.setFeaturesNames("wind");
        algorithm.run();
    }

    @Test
    public void testXYEXTRACTOR() throws Exception {
        XYEXTRACTOR algorithm = new XYEXTRACTOR();
        algorithm.setBBox_LowerLeftLat(-17.098);
        algorithm.setBBox_LowerLeftLong(89.245);
        algorithm.setBBox_UpperRightLat(25.086);
        algorithm.setBBox_UpperRightLong(147.642);
        algorithm.setOutputTableLabel("wps_xy_extraction");
        algorithm.setTimeIndex(0);
        algorithm.setXResolution(0.5);
        algorithm.setYResolution(0.5);
        algorithm.setZ(0.0);
        algorithm.setLayer("http://thredds.research-infrastructures.eu/thredds/dodsC/public/netcdf/WOA2005TemperatureAnnual_CLIMATOLOGY_METEOROLOGY_ATMOSPHERE_.nc");
        algorithm.run();
    }

    @Test
    public void testTIME_SERIES_ANALYSIS() throws Exception {
        TIME_SERIES_ANALYSIS algorithm = new TIME_SERIES_ANALYSIS();
        File f1 = new File("./datasets/locallinkstimeseries.txt");
        algorithm.setTimeSeriesTable(new GenericFileData(f1, "text/csv"));
        algorithm.setFFT_Window_Samples(12);
        algorithm.setAggregationFunction("SUM");
        algorithm.setSensitivity("LOW");
        algorithm.setSSA_Window_in_Samples(20);
        algorithm.setSSA_EigenvaluesThreshold(0.7);
        algorithm.setSSA_Points_to_Forecast(10);
        algorithm.setValueColum("x");
        algorithm.run();
    }

    @Test
    public void testMAX_ENT_NICHE_MODELLING() throws Exception {
        MAX_ENT_NICHE_MODELLING algorithm = new MAX_ENT_NICHE_MODELLING();
        algorithm.setXResolution(0.5);
        algorithm.setYResolution(0.5);
        algorithm.setDefaultPrevalence(0.5);
        algorithm.setLayers("http://thredds.research-infrastructures.eu/thredds/dodsC/public/netcdf/WOA2005TemperatureAnnual_CLIMATOLOGY_METEOROLOGY_ATMOSPHERE_.nc");
        algorithm.setZ(0.0);
        algorithm.setTimeIndex(0);
        algorithm.setMaxIterations(1000);
        algorithm.setSpeciesName("Mola mola");
        File f1 = new File("./datasets/locallinksspecies.txt");
        algorithm.setOccurrencesTable(new GenericFileData(f1, "text/csv"));
        algorithm.setOutputTableLabel("Mola mola maxent table");
        algorithm.setLongitudeColumn("decimallongitude");
        algorithm.setLatitudeColumn("decimallatitude");
        algorithm.run();
    }

    @Test
    public void testFAO_OCEAN_AREA_COLUMN_CREATOR() throws Exception {
        FAO_OCEAN_AREA_COLUMN_CREATOR algorithm = new FAO_OCEAN_AREA_COLUMN_CREATOR();
        File f1 = new File("./datasets/locallinkshcaf1.txt");
        algorithm.setInputTable(new GenericFileData(f1, "text/csv"));
        algorithm.setLatitude_Column("centerlat");
        algorithm.setLongitude_Column("centerlong");
        algorithm.setOutputTableName("wps_faoareacolumn");
        algorithm.setResolution(5);
        algorithm.run();
    }

    @Test
    public void testGEO_CHART() throws Exception {
        GEO_CHART algorithm = new GEO_CHART();
        File f1 = new File("./datasets/locallinkshcaf1.txt");
        algorithm.setInputTable(new GenericFileData(f1, "text/csv"));
        algorithm.setLatitude("centerlat");
        algorithm.setLongitude("centerlong");
        algorithm.setQuantities("depthsd");
        algorithm.run();
    }

    @Test
    public void testvGENERIC_CHARTS() throws Exception {
        GENERIC_CHARTS algorithm = new GENERIC_CHARTS();
        File f1 = new File("./datasets/locallinkshcaf1.txt");
        algorithm.setInputTable(new GenericFileData(f1, "text/csv"));
        algorithm.setTopElementsNumber(10);
        algorithm.setAttributes("csquarecode|lme");
        algorithm.setQuantities("depthsd");
        algorithm.run();
    }
}

