package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers;
import java.io.File;
import java.net.URL;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.io.StringWriter;
import org.apache.commons.io.IOUtils;
import org.apache.xmlbeans.XmlObject;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.bindings.*;
import org.n52.wps.algorithm.annotation.*;
import org.n52.wps.io.data.*;
import org.n52.wps.io.data.binding.complex.*;
import org.n52.wps.io.data.binding.literal.*;
import org.n52.wps.server.*;import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.AbstractEcologicalEngineMapper;import org.n52.wps.server.*;import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.*;
@Algorithm(statusSupported=false, title="XYEXTRACTOR", abstrakt="An algorithm to extract values associated to an environmental feature repository (e.g. NETCDF, ASC, GeoTiff files etc. ).  A grid of points at a certain resolution is specified by the user and values are associated to the points from the environmental repository. It accepts as one  geospatial repository ID (via their UUIDs in the infrastructure spatial data repository - recoverable through the Geoexplorer portlet) or a direct link to a file and the specification about time and space. The algorithm produces one table containing the values associated to the selected bounding box.", identifier="org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.XYEXTRACTOR", version = "1.1.0")
public class XYEXTRACTOR extends AbstractEcologicalEngineMapper implements ITransducer{
@LiteralDataInput(abstrakt="Name of the parameter: Layer. Layer Title or UUID or HTTP link. E.g. the title or the UUID (preferred) of a layer indexed in the e-Infrastructure on GeoNetwork - You can retrieve it from GeoExplorer. Otherwise you can supply the direct HTTP link of the layer. The format will be guessed from the link. The default is GeoTiff. Supports several standards (NETCDF, WFS, WCS ASC, GeoTiff )", defaultValue="", title="Layer Title or UUID or HTTP link. E.g. the title or the UUID (preferred) of a layer indexed in the e-Infrastructure on GeoNetwork - You can retrieve it from GeoExplorer. Otherwise you can supply the direct HTTP link of the layer. The format will be guessed from the link. The default is GeoTiff. Supports several standards (NETCDF, WFS, WCS ASC, GeoTiff )", identifier = "Layer", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setLayer(String data) {inputs.put("Layer",data);}
@LiteralDataInput(abstrakt="Name of the parameter: BBox_LowerLeftLat. Lower Left Latitute of the Bounding Box", defaultValue="-60", title="Lower Left Latitute of the Bounding Box", identifier = "BBox_LowerLeftLat", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setBBox_LowerLeftLat(Double data) {inputs.put("BBox_LowerLeftLat",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: BBox_LowerLeftLong. Lower Left Longitude of the Bounding Box", defaultValue="-50", title="Lower Left Longitude of the Bounding Box", identifier = "BBox_LowerLeftLong", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setBBox_LowerLeftLong(Double data) {inputs.put("BBox_LowerLeftLong",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: BBox_UpperRightLat. Upper Right Latitute of the Bounding Box", defaultValue="60", title="Upper Right Latitute of the Bounding Box", identifier = "BBox_UpperRightLat", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setBBox_UpperRightLat(Double data) {inputs.put("BBox_UpperRightLat",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: BBox_UpperRightLong. Upper Right Longitude of the Bounding Box", defaultValue="50", title="Upper Right Longitude of the Bounding Box", identifier = "BBox_UpperRightLong", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setBBox_UpperRightLong(Double data) {inputs.put("BBox_UpperRightLong",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: OutputTableLabel. The name of the table to produce", defaultValue="extr_", title="The name of the table to produce", identifier = "OutputTableLabel", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setOutputTableLabel(String data) {inputs.put("OutputTableLabel",data);}
@LiteralDataInput(abstrakt="Name of the parameter: Z. Value of Z. Default is 0, that means processing will be at surface level or at the first avaliable Z value in the layer", defaultValue="0", title="Value of Z. Default is 0, that means processing will be at surface level or at the first avaliable Z value in the layer", identifier = "Z", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setZ(Double data) {inputs.put("Z",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: TimeIndex. Time Index. The default is the first time indexed dataset", defaultValue="0", title="Time Index. The default is the first time indexed dataset", identifier = "TimeIndex", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setTimeIndex(Integer data) {inputs.put("TimeIndex",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: XResolution. Projection resolution on the X axis", defaultValue="0.5", title="Projection resolution on the X axis", identifier = "XResolution", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setXResolution(Double data) {inputs.put("XResolution",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: YResolution. Projection resolution on the Y axis", defaultValue="0.5", title="Projection resolution on the Y axis", identifier = "YResolution", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setYResolution(Double data) {inputs.put("YResolution",""+data);}
@ComplexDataOutput(abstrakt="Name of the parameter: OutputTable1. Output table [a http link to a table in UTF-8 ecoding following this template: (TIMESERIES) http://goo.gl/DoW6fg]", title="Output table [a http link to a table in UTF-8 ecoding following this template: (TIMESERIES) http://goo.gl/DoW6fg]", identifier = "OutputTable1", binding = CsvFileDataBinding.class)	public GenericFileData getOutputTable1() {URL url=null;try {url = new URL((String) outputs.get("OutputTable1")); return new GenericFileData(url.openStream(),"text/csv");} catch (Exception e) {e.printStackTrace();return null;}}
@ComplexDataOutput(abstrakt="Output that is not predetermined", title="NonDeterministicOutput", identifier = "non_deterministic_output", binding = GenericXMLDataBinding.class)
 public XmlObject getNon_deterministic_output() {return (XmlObject) outputs.get("non_deterministic_output");}
@Execute	public void run() throws Exception {		super.run();	} }