/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.common.homelibrary.home.Home;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.HomeManager;
import org.gcube.common.homelibrary.home.HomeManagerFactory;
import org.gcube.common.homelibrary.home.User;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.AbstractEcologicalEngineMapper;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.ComputationData;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.ProvOGenerator;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.StoredData;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.StoredType;

public class DataspaceManager
implements Runnable {
    public static String dataminerFolder = "DataMiner";
    public static String importedDataFolder = "Input Data Sets";
    public static String computedDataFolder = "Output Data Sets";
    public static String computationsFolder = "Computations";
    AlgorithmConfiguration config;
    ComputationData computation;
    List<StoredData> inputData;
    List<StoredData> outputData;
    List<File> generatedFiles;
    public static String computation_id = "computation_id";
    public static String data_id = "data_id";
    public static String data_type = "data_type";
    public static String operator_name = "operator_name";
    public static String operator_description = "operator_description";
    public static String data_description = "data_description";
    public static String creation_date = "creation_date";
    public static String start_date = "start_date";
    public static String end_date = "end_date";
    public static String status = "status";
    public static String execution_platform = "execution_type";
    public static String error = "error";
    public static String IO = "IO";
    public static String operator = "operator";
    public static String payload = "payload";

    public DataspaceManager(AlgorithmConfiguration config, ComputationData computation, List<StoredData> inputData, List<StoredData> outputData, List<File> generatedFiles) {
        this.config = config;
        this.computation = computation;
        this.inputData = inputData;
        this.outputData = outputData;
        this.generatedFiles = generatedFiles;
    }

    @Override
    public void run() {
        try {
            AnalysisLogger.getLogger().debug((Object)"Dataspace->Deleting running computation");
            try {
                this.deleteRunningComputationData();
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)"Dataspace->No running computation available");
            }
            AnalysisLogger.getLogger().debug((Object)"Dataspace->Writing provenance information");
            this.writeProvenance(this.computation, this.inputData, this.outputData);
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("Dataspace-> error writing provenance information " + e.getLocalizedMessage()));
            AnalysisLogger.getLogger().debug((Object)e);
        }
    }

    public void createFoldersNetwork(Workspace ws, WorkspaceFolder root) throws Exception {
        WorkspaceFolder dataminerFolderWS;
        AnalysisLogger.getLogger().debug((Object)"Dataspace->Creating folders for DataMiner");
        if (!ws.exists(dataminerFolder, root.getId())) {
            AnalysisLogger.getLogger().debug((Object)"Dataspace->Creating DataMiner main folder");
            root.createFolder(dataminerFolder, "A folder collecting DataMiner experiments data and computation information");
        }
        if (!ws.exists(importedDataFolder, (dataminerFolderWS = (WorkspaceFolder)root.find(dataminerFolder)).getId())) {
            AnalysisLogger.getLogger().debug((Object)"Dataspace->Creating DataMiner imported data folder");
            dataminerFolderWS.createFolder(importedDataFolder, "A folder collecting DataMiner imported data");
        }
        if (!ws.exists(computedDataFolder, dataminerFolderWS.getId())) {
            AnalysisLogger.getLogger().debug((Object)"Dataspace->Creating DataMiner computed data folder");
            dataminerFolderWS.createFolder(computedDataFolder, "A folder collecting DataMiner computed data");
        }
        if (!ws.exists(computationsFolder, dataminerFolderWS.getId())) {
            AnalysisLogger.getLogger().debug((Object)"Dataspace->Creating DataMiner computations folder");
            dataminerFolderWS.createFolder(computationsFolder, "A folder collecting DataMiner computations information");
        }
    }

    public String uploadData(StoredData data, WorkspaceFolder wsFolder) throws Exception {
        String filenameonwsString = data.name + "_[" + data.computationId + "]";
        InputStream in = null;
        String url = "";
        if (data.type == StoredType.DATA) {
            if (new File(data.payload).exists()) {
                AnalysisLogger.getLogger().debug((Object)("Dataspace->Uploading file " + data.payload));
                in = new FileInputStream(new File(data.payload));
            } else {
                AnalysisLogger.getLogger().debug((Object)("Dataspace->Uploading via URL " + data.payload));
                URL urlc = new URL(data.payload);
                HttpURLConnection urlConnection = (HttpURLConnection)urlc.openConnection();
                in = new BufferedInputStream(urlConnection.getInputStream());
            }
            AnalysisLogger.getLogger().debug((Object)("Dataspace->saving the following file on the WS " + filenameonwsString + " [" + data.computationId + "]"));
            FolderItem fileItem = WorkspaceUtil.createExternalFile((WorkspaceFolder)wsFolder, (String)filenameonwsString, (String)data.description, null, (InputStream)in);
            fileItem.getProperties().addProperty(computation_id, data.computationId);
            fileItem.getProperties().addProperty(creation_date, data.creationDate);
            fileItem.getProperties().addProperty(operator, data.operator);
            fileItem.getProperties().addProperty(data_id, data.id);
            fileItem.getProperties().addProperty(data_description, data.description);
            fileItem.getProperties().addProperty(IO, data.provenance.name());
            fileItem.getProperties().addProperty(data_type, data.type.name());
            url = fileItem.getPublicLink(true);
            fileItem.getProperties().addProperty(payload, url);
            data.payload = url;
            try {
                in.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            AnalysisLogger.getLogger().debug((Object)("Dataspace->File created " + data.name));
        } else {
            AnalysisLogger.getLogger().debug((Object)("Dataspace->Uploading string " + data.payload));
            url = data.payload;
        }
        return url;
    }

    public List<String> uploadInputData(List<StoredData> inputData, WorkspaceFolder dataminerFolder) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Dataspace->uploading input data " + inputData.size()));
        WorkspaceItem folderItem = dataminerFolder.find(importedDataFolder);
        ArrayList<String> urls = new ArrayList<String>();
        if (folderItem != null && folderItem.isFolder()) {
            WorkspaceFolder destinationFolder = (WorkspaceFolder)folderItem;
            for (StoredData input : inputData) {
                String url = this.uploadData(input, destinationFolder);
                urls.add(url);
            }
        } else {
            AnalysisLogger.getLogger().debug((Object)"Dataspace->folder is not valid");
        }
        AnalysisLogger.getLogger().debug((Object)"Dataspace->finished uploading input data");
        return urls;
    }

    public List<String> uploadOutputData(List<StoredData> outputData, WorkspaceFolder dataminerFolder) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Dataspace->uploading output data" + outputData.size()));
        WorkspaceItem folderItem = dataminerFolder.find(computedDataFolder);
        ArrayList<String> urls = new ArrayList<String>();
        if (folderItem != null && folderItem.isFolder()) {
            WorkspaceFolder destinationFolder = (WorkspaceFolder)folderItem;
            for (StoredData output : outputData) {
                String url = this.uploadData(output, destinationFolder);
                urls.add(url);
            }
        } else {
            AnalysisLogger.getLogger().debug((Object)"Dataspace->folder is not valid");
        }
        AnalysisLogger.getLogger().debug((Object)"Dataspace->finished uploading output data");
        return urls;
    }

    public void uploadComputationData(ComputationData computation, List<StoredData> inputData, List<StoredData> outputData, WorkspaceFolder dataminerFolder, Workspace ws) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Dataspace->uploading computation data");
        WorkspaceItem folderItem = dataminerFolder.find(computationsFolder);
        if (folderItem != null && folderItem.isFolder()) {
            int i;
            AnalysisLogger.getLogger().debug((Object)("Dataspace->Creating computation folder " + computation.id));
            WorkspaceFolder cfolder = (WorkspaceFolder)folderItem;
            String cfoldername = computation.id;
            WorkspaceFolder newcomputationFolder = cfolder.createFolder(cfoldername, computation.operatorDescription);
            String itemType = "COMPUTATION";
            AnalysisLogger.getLogger().debug((Object)("Dataspace->creating IO folders under " + cfoldername));
            newcomputationFolder.createFolder(importedDataFolder, importedDataFolder);
            newcomputationFolder.createFolder(computedDataFolder, computedDataFolder);
            List<String> inputurls = this.uploadInputData(inputData, newcomputationFolder);
            List<String> outputurls = this.uploadOutputData(outputData, newcomputationFolder);
            AnalysisLogger.getLogger().debug((Object)"Dataspace->creating gCube Item");
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            properties.put(computation_id, computation.id);
            newcomputationFolder.getProperties().addProperty(computation_id, computation.id);
            properties.put(operator_name, this.config.getAgent());
            newcomputationFolder.getProperties().addProperty(operator_name, this.config.getAgent());
            properties.put(operator_description, computation.operatorDescription);
            newcomputationFolder.getProperties().addProperty(operator_description, computation.operatorDescription);
            properties.put(start_date, computation.startDate);
            newcomputationFolder.getProperties().addProperty(start_date, computation.startDate);
            properties.put(end_date, computation.endDate);
            newcomputationFolder.getProperties().addProperty(end_date, computation.endDate);
            properties.put(status, computation.status);
            newcomputationFolder.getProperties().addProperty(status, computation.status);
            properties.put(execution_platform, computation.infrastructure);
            newcomputationFolder.getProperties().addProperty(execution_platform, computation.infrastructure);
            int ninput = inputurls.size();
            int noutput = outputurls.size();
            AnalysisLogger.getLogger().debug((Object)("Dataspace->Adding input properties for " + ninput + " inputs"));
            for (i = 1; i <= ninput; ++i) {
                properties.put("input" + i + "_" + inputData.get((int)(i - 1)).name, inputurls.get(i - 1));
                newcomputationFolder.getProperties().addProperty("input" + i + "_" + inputData.get((int)(i - 1)).name, inputurls.get(i - 1));
            }
            AnalysisLogger.getLogger().debug((Object)("Dataspace->Adding output properties for " + noutput + " outputs"));
            for (i = 1; i <= noutput; ++i) {
                properties.put("output" + i + "_" + outputData.get((int)(i - 1)).name, outputurls.get(i - 1));
                newcomputationFolder.getProperties().addProperty("output" + i + "_" + outputData.get((int)(i - 1)).name, outputurls.get(i - 1));
            }
            AnalysisLogger.getLogger().debug((Object)("Dataspace->Saving properties to ProvO XML file " + noutput + " outputs"));
            try {
                String xmlproperties = ProvOGenerator.toProvO(computation, inputData, outputData);
                File xmltosave = new File(this.config.getPersistencePath(), "properties_" + UUID.randomUUID());
                FileTools.saveString((String)xmltosave.getAbsolutePath(), (String)xmlproperties, (boolean)true, (String)"UTF-8");
                FileInputStream sis = new FileInputStream(xmltosave);
                WorkspaceUtil.createExternalFile((WorkspaceFolder)newcomputationFolder, (String)(computation.id + ".xml"), (String)computation.operatorDescription, null, (InputStream)sis);
                ((InputStream)sis).close();
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)("Dataspace->Failed creating ProvO XML file " + e.getLocalizedMessage()));
                AnalysisLogger.getLogger().debug((Object)e);
                e.printStackTrace();
            }
            ArrayList<String> scopes = new ArrayList<String>();
            scopes.add(this.config.getGcubeScope());
            ws.createGcubeItem(computation.id, computation.operatorDescription, scopes, computation.user, itemType, properties, newcomputationFolder.getId());
        }
        AnalysisLogger.getLogger().debug((Object)"Dataspace->finished uploading computation data");
    }

    public void writeProvenance(ComputationData computation, List<StoredData> inputData, List<StoredData> outputData) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Dataspace->connecting to Workspace");
        HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
        HomeManager manager = factory.getHomeManager();
        AnalysisLogger.getLogger().debug((Object)"Dataspace->getting user");
        User user = manager.createUser(computation.user);
        Home home = manager.getHome(user);
        AnalysisLogger.getLogger().debug((Object)"Dataspace->getting root folder");
        Workspace ws = home.getWorkspace();
        WorkspaceFolder root = ws.getRoot();
        AnalysisLogger.getLogger().debug((Object)"Dataspace->create folders network");
        this.createFoldersNetwork(ws, root);
        WorkspaceFolder dataminerItem = (WorkspaceFolder)root.find(dataminerFolder);
        AnalysisLogger.getLogger().debug((Object)"Dataspace->uploading input files");
        AnalysisLogger.getLogger().debug((Object)"Dataspace->uploading output files");
        this.uploadOutputData(outputData, dataminerItem);
        AnalysisLogger.getLogger().debug((Object)"Dataspace->uploading computation files");
        this.uploadComputationData(computation, inputData, outputData, dataminerItem, ws);
        AnalysisLogger.getLogger().debug((Object)"Dataspace->provenance management finished");
        AnalysisLogger.getLogger().debug((Object)"Dataspace->deleting generated files");
        AbstractEcologicalEngineMapper.deleteGeneratedFiles(this.generatedFiles);
        AnalysisLogger.getLogger().debug((Object)"Dataspace->generated files deleted");
    }

    public void writeRunningComputationData() throws Exception {
        try {
            this.deleteRunningComputationData();
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"Dataspace->impossible to delete running computation");
        }
        HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
        HomeManager manager = factory.getHomeManager();
        User user = manager.createUser(this.computation.user);
        Home home = manager.getHome(user);
        Workspace ws = home.getWorkspace();
        WorkspaceFolder root = ws.getRoot();
        this.createFoldersNetwork(ws, root);
        WorkspaceFolder dataminerFolderWS = (WorkspaceFolder)root.find(dataminerFolder);
        WorkspaceItem computationsFolderItem = dataminerFolderWS.find(computationsFolder);
        String itemType = "COMPUTATION";
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        properties.put(computation_id, this.computation.id);
        properties.put(operator_name, this.config.getAgent());
        properties.put(operator_description, this.computation.operatorDescription);
        properties.put(start_date, this.computation.startDate);
        properties.put(end_date, this.computation.endDate);
        properties.put(status, this.computation.status);
        properties.put(execution_platform, this.computation.infrastructure);
        if (this.computation.exception != null && this.computation.exception.length() > 0) {
            properties.put(error, this.computation.exception);
        }
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add(this.config.getGcubeScope());
        ws.createGcubeItem(this.computation.id, this.computation.operatorDescription, scopes, this.computation.user, itemType, properties, computationsFolderItem.getId());
        AnalysisLogger.getLogger().debug((Object)"Dataspace->finished uploading computation data");
    }

    public void deleteRunningComputationData() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Dataspace->deleting computation item");
        AnalysisLogger.getLogger().debug((Object)"Dataspace->connecting to Workspace");
        HomeManagerFactory factory = HomeLibrary.getHomeManagerFactory();
        HomeManager manager = factory.getHomeManager();
        AnalysisLogger.getLogger().debug((Object)"Dataspace->getting user");
        User user = manager.createUser(this.computation.user);
        Home home = manager.getHome(user);
        AnalysisLogger.getLogger().debug((Object)"Dataspace->getting root folder");
        Workspace ws = home.getWorkspace();
        WorkspaceFolder root = ws.getRoot();
        WorkspaceFolder dataminerFolderWS = (WorkspaceFolder)root.find(dataminerFolder);
        WorkspaceItem computationsFolderItem = dataminerFolderWS.find(computationsFolder);
        AnalysisLogger.getLogger().debug((Object)"Dataspace->removing computation data");
        ((WorkspaceFolder)computationsFolderItem).find(this.computation.id).remove();
        AnalysisLogger.getLogger().debug((Object)"Dataspace->finished removing computation data");
    }
}

