/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.codegeneration;

import java.util.HashMap;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.StatisticalTypeToWPSType;

public class ClassGenerator {
    public static String configPath = "./cfg/";
    public static String generationPath = "./src/main/java/org/gcube/dataanalysis/wps/statisticalmanager/synchserver/mappedclasses/";
    public StatisticalTypeToWPSType converter = new StatisticalTypeToWPSType();

    public void generateEcologicalEngineClasses() throws Exception {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath(configPath);
        HashMap algorithms = ProcessorsFactory.getAllFeatures((AlgorithmConfiguration)config);
        for (String algorithmSet : algorithms.keySet()) {
            List parametersList = (List)algorithms.get(algorithmSet);
            System.out.println(String.valueOf(algorithmSet) + ":" + parametersList.toString());
            for (String algorithm : parametersList) {
                System.out.println("Algorithm: " + algorithm);
                String description = "";
                String name = "";
                StringBuffer classWriter = new StringBuffer();
                List inputs = null;
                StatisticalType outputs = null;
                name = algorithm;
                config.setAgent(algorithm);
                config.setModel(algorithm);
                String packageString = "";
                String interfaceString = "";
                try {
                    if (algorithmSet.equals("DISTRIBUTIONS")) {
                        packageString = "generators";
                        interfaceString = "IGenerator";
                        inputs = GeneratorsFactory.getAlgorithmParameters((String)configPath, (String)algorithm);
                        description = GeneratorsFactory.getDescription((String)configPath, (String)algorithm);
                        outputs = GeneratorsFactory.getAlgorithmOutput((String)configPath, (String)algorithm);
                    } else if (algorithmSet.equals("TRANSDUCERS")) {
                        packageString = "transducerers";
                        interfaceString = "ITransducer";
                        inputs = TransducerersFactory.getTransducerParameters((AlgorithmConfiguration)config, (String)algorithm);
                        description = TransducerersFactory.getDescription((AlgorithmConfiguration)config, (String)algorithm);
                        outputs = TransducerersFactory.getTransducerOutput((AlgorithmConfiguration)config, (String)algorithm);
                    } else if (algorithmSet.equals("MODELS")) {
                        packageString = "modellers";
                        interfaceString = "IModeller";
                        inputs = ModelersFactory.getModelParameters((String)configPath, (String)algorithm);
                        description = ModelersFactory.getDescription((String)configPath, (String)algorithm);
                        outputs = ModelersFactory.getModelOutput((String)configPath, (String)algorithm);
                    } else if (algorithmSet.equals("CLUSTERERS")) {
                        packageString = "clusterers";
                        interfaceString = "IClusterer";
                        inputs = ClusterersFactory.getClustererParameters((String)configPath, (String)algorithm);
                        description = ClusterersFactory.getDescription((String)configPath, (String)algorithm);
                        outputs = ClusterersFactory.getClustererOutput((String)configPath, (String)algorithm);
                    } else if (!algorithmSet.equals("TEMPORAL_ANALYSIS") && algorithmSet.equals("EVALUATORS")) {
                        packageString = "evaluators";
                        interfaceString = "IEvaluator";
                        inputs = EvaluatorsFactory.getEvaluatorParameters((String)configPath, (String)algorithm);
                        description = EvaluatorsFactory.getDescription((String)configPath, (String)algorithm);
                        outputs = EvaluatorsFactory.getEvaluatorOutput((String)configPath, (String)algorithm);
                    }
                }
                catch (Exception e) {
                    System.out.println("Error in retrieving output: " + e.getLocalizedMessage());
                }
                classWriter.append(String.valueOf(((String)StatisticalTypeToWPSType.templates.get("package")).replace("#PACKAGE#", packageString)) + "\n" + (String)StatisticalTypeToWPSType.templates.get("import") + "\n");
                System.out.println("Class preamble: \n" + classWriter.toString());
                String classdescription = (String)StatisticalTypeToWPSType.templates.get("description");
                classdescription = classdescription.replace("#TITLE#", name).replace("#ABSTRACT#", description).replace("#CLASSNAME#", name).replace("#PACKAGE#", packageString);
                System.out.println("Class description : \n" + classdescription);
                String classdefinition = (String)StatisticalTypeToWPSType.templates.get("class_definition");
                classdefinition = classdefinition.replace("#CLASSNAME#", name).replace("#INTERFACE#", interfaceString);
                System.out.println("Class definition: \n" + classdefinition);
                classWriter.append(String.valueOf(classdescription) + "\n");
                classWriter.append(String.valueOf(classdefinition) + "\n");
                for (StatisticalType input : inputs) {
                    System.out.println(input);
                    String wpsInput = this.converter.convert2WPSType(input, true, config);
                    if (wpsInput == null) continue;
                    classWriter.append(String.valueOf(wpsInput) + "\n");
                    System.out.println("Input:\n" + wpsInput);
                }
                if (outputs != null) {
                    System.out.println("Alg. Output:\n" + outputs);
                    String wpsOutput = this.converter.convert2WPSType(outputs, false, config);
                    classWriter.append(String.valueOf(wpsOutput) + "\n");
                    System.out.println("Output:\n" + wpsOutput);
                } else {
                    System.out.println("Output is empty!");
                }
                classWriter.append(String.valueOf(StatisticalTypeToWPSType.templates.getProperty("optionalOutput")) + "\n");
                classWriter.append((String)StatisticalTypeToWPSType.templates.get("class_closure"));
                System.out.println("Class:\n" + classWriter.toString());
                System.out.println("Saving...");
                FileTools.saveString((String)(String.valueOf(generationPath) + packageString + "/" + algorithm + ".java"), (String)classWriter.toString(), (boolean)true, (String)"UTF-8");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ClassGenerator generator = new ClassGenerator();
        generator.generateEcologicalEngineClasses();
        System.out.println("Finished!");
    }
}

