/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure;

import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure.DatabaseInfo;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class InfrastructureDialoguer {
    public String scope;

    public InfrastructureDialoguer(String scope) {
        this.scope = scope;
    }

    public DatabaseInfo getDatabaseInfo(String resourceName) throws Exception {
        DatabaseInfo dbi = new DatabaseInfo();
        AnalysisLogger.getLogger().debug((Object)("Searching for Database " + resourceName + " in scope " + this.scope));
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name eq '" + resourceName + "' ");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        if (resources == null || resources.size() == 0) {
            throw new Exception("No resource named " + resourceName + " available in scope " + this.scope);
        }
        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)((ServiceEndpoint)resources.get(0)).profile().accessPoints().iterator().next();
        dbi.url = ap.address();
        dbi.username = ap.username();
        dbi.password = StringEncrypter.getEncrypter().decrypt(ap.password().trim(), new Key[0]);
        for (ServiceEndpoint.Property property : ap.properties()) {
            if (!property.name().equalsIgnoreCase("driver")) continue;
            dbi.driver = property.value();
        }
        AnalysisLogger.getLogger().debug((Object)("Found Database : " + dbi));
        if (dbi.url == null) {
            throw new Exception("No database URL for resource " + resourceName + " available in scope " + this.scope);
        }
        return dbi;
    }

    public List<String> getAlgorithmsInScope() throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Searching for Algorithms in scope " + this.scope));
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType eq 'StatisticalManagerAlgorithm' ");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List resources = client.submit((Query)query);
        if (resources == null || resources.size() == 0) {
            throw new Exception("No resource named StatisticalManagerAlgorithm available in scope " + this.scope);
        }
        ArrayList<String> resourcesNames = new ArrayList<String>();
        AnalysisLogger.getLogger().debug((Object)("Found " + resources.size() + " resources"));
        for (GenericResource resource : resources) {
            resourcesNames.add(resource.profile().name());
        }
        return resourcesNames;
    }

    public static void main(String[] args) throws Exception {
        AnalysisLogger.setLogger((String)("cfg/" + AlgorithmConfiguration.defaultLoggerFile));
        InfrastructureDialoguer dialoguer = new InfrastructureDialoguer("/gcube/devsec/devVRE");
        dialoguer.getDatabaseInfo("FishBase");
    }
}

