/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.TablesList;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.DatabaseParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure.DatabaseInfo;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure.InfrastructureDialoguer;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.ConfigurationManager;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.TableTemplatesMapper;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.DataProvenance;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.dataspace.StoredData;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.utils.GML2CSV;
import org.hibernate.SessionFactory;
import org.n52.wps.io.data.GenericFileData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputsManager.class);
    LinkedHashMap<String, Object> inputs;
    List<String> generatedTables;
    List<File> generatedFiles;
    HashMap<String, String> inputTableTemplates = new HashMap();
    AlgorithmConfiguration config;
    String computationId;
    List<StoredData> provenanceData = new ArrayList<StoredData>();
    public static String inputsSeparator = "\\|";

    public List<StoredData> getProvenanceData() {
        return this.provenanceData;
    }

    public AlgorithmConfiguration getConfig() {
        return this.config;
    }

    public InputsManager(LinkedHashMap<String, Object> inputs, AlgorithmConfiguration config, String computationId) {
        this.inputs = inputs;
        this.config = config;
        this.computationId = computationId;
        this.generatedTables = new ArrayList<String>();
        this.generatedFiles = new ArrayList<File>();
    }

    public List<String> getGeneratedTables() {
        return this.generatedTables;
    }

    public List<File> getGeneratedInputFiles() {
        return this.generatedFiles;
    }

    public void configSupportDatabaseParameters(DatabaseInfo supportDatabaseInfo) throws Exception {
        this.config.setDatabaseDialect(supportDatabaseInfo.dialect);
        this.config.setDatabaseDriver(supportDatabaseInfo.driver);
        this.config.setDatabasePassword(supportDatabaseInfo.password);
        this.config.setDatabaseURL(supportDatabaseInfo.url);
        this.config.setDatabaseUserName(supportDatabaseInfo.username);
        this.config.setParam("DatabaseDriver", supportDatabaseInfo.driver);
        this.config.setParam("DatabaseUserName", supportDatabaseInfo.username);
        this.config.setParam("DatabasePassword", supportDatabaseInfo.password);
        this.config.setParam("DatabaseURL", supportDatabaseInfo.url);
    }

    public void mergeWpsAndEcologicalInputs(DatabaseInfo supportDatabaseInfo) throws Exception {
        for (String inputName : this.inputs.keySet()) {
            Object input = this.inputs.get(inputName);
            LOGGER.debug("Managing Input Parameter with Name " + inputName);
            if (input instanceof String) {
                LOGGER.debug("Simple Input: " + input);
                String inputAlgoOrig = ((String)input).trim();
                String inputAlgo = ((String)input).trim().replaceAll(inputsSeparator, AlgorithmConfiguration.listSeparator);
                LOGGER.debug("Simple Input Transformed: " + inputAlgo);
                this.config.setParam(inputName, inputAlgo);
                this.saveInputData(inputName, inputName, inputAlgoOrig);
                continue;
            }
            if (!(input instanceof GenericFileData)) continue;
            LOGGER.debug("Complex Input: " + input);
            GenericFileData files = (GenericFileData)input;
            List<File> localfiles = this.getLocalFiles(files, inputName);
            String inputtables = "";
            int nfiles = localfiles.size();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < nfiles; ++i) {
                File tableFile = localfiles.get(i);
                this.generatedFiles.add(tableFile);
                String tableName = ("wps_" + ("" + UUID.randomUUID()).replace("_", "")).replace("-", "");
                if (this.inputTableTemplates.get(inputName) != null) {
                    LOGGER.debug("Creating table: " + tableName);
                    this.createTable(tableName, tableFile, this.config, supportDatabaseInfo, this.inputTableTemplates.get(inputName));
                    this.generatedTables.add(tableName);
                } else {
                    tableName = tableFile.getAbsolutePath();
                }
                if (i > 0) {
                    inputtables = inputtables + AlgorithmConfiguration.getListSeparator();
                }
                inputtables = inputtables + tableName;
                this.saveInputData(tableFile.getName(), inputName, tableFile.getAbsolutePath());
                if (i > 0) {
                    sb.append("|");
                }
                sb.append(tableFile.getName());
            }
            sb.append("|");
            if (nfiles > 0) {
                this.saveInputData(inputName, inputName, sb.toString());
            }
            this.config.setParam(inputName, inputtables);
        }
    }

    public boolean isXML(String fileContent) {
        return fileContent.startsWith("&lt;");
    }

    public String readOneLine(String filename) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(new File(filename)));
            String line = null;
            String vud = "";
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                vud = line.trim();
                break;
            }
            in.close();
            return vud;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String inputNameFromHttpHeader(String url) throws Exception {
        URL obj = new URL(url);
        URLConnection conn = obj.openConnection();
        String filename = null;
        Map<String, List<String>> map = conn.getHeaderFields();
        LOGGER.debug("Getting file name from http header");
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String value = entry.getValue().toString();
            if (!value.toLowerCase().contains("filename=")) continue;
            LOGGER.debug("Searching in http header: found file name in header value " + value);
            filename = value.substring(value.indexOf("=") + 1);
            filename = filename.replace("\"", "").replace("]", "");
            LOGGER.debug("Searching in http header: retrieved file name " + filename);
            break;
        }
        return filename;
    }

    public List<File> getLocalFiles(GenericFileData files, String inputName) throws Exception {
        ArrayList<File> filesList = new ArrayList<File>();
        File f = files.getBaseFile(false);
        LOGGER.debug("Retrieving file content as a URL link: " + f.getAbsolutePath());
        String fileLink = this.readOneLine(f.getAbsolutePath());
        LOGGER.debug("File link: " + fileLink.substring(0, Math.min(fileLink.length(), 10)) + "...");
        String fileName = "";
        if (fileLink != null && fileLink.toLowerCase().startsWith("http:") || fileLink.toLowerCase().startsWith("https:")) {
            String[] remotefiles;
            for (String subfilelink : remotefiles = fileLink.split(inputsSeparator)) {
                subfilelink = subfilelink.trim();
                LOGGER.debug("Managing link: " + subfilelink);
                if (subfilelink.length() == 0) continue;
                BufferedInputStream is = null;
                HttpURLConnection urlConnection = null;
                URL url = new URL(subfilelink);
                urlConnection = (HttpURLConnection)url.openConnection();
                is = new BufferedInputStream(urlConnection.getInputStream());
                String fileNameTemp = this.inputNameFromHttpHeader(subfilelink);
                fileName = fileNameTemp == null ? inputName + "_[" + this.computationId + "]" : fileNameTemp + "_[" + this.computationId + "]." + FilenameUtils.getExtension((String)fileNameTemp);
                LOGGER.debug("Retrieving remote input in file: " + fileName);
                LOGGER.debug("Creating local temp file: " + fileName);
                File of = new File(this.config.getPersistencePath(), fileName);
                FileOutputStream fos = new FileOutputStream(of);
                IOUtils.copy((InputStream)is, (OutputStream)fos);
                ((InputStream)is).close();
                fos.flush();
                fos.close();
                urlConnection.disconnect();
                filesList.add(of);
                LOGGER.debug("Created local file: " + of.getAbsolutePath());
            }
        } else {
            LOGGER.debug("Complex Input payload is the filelink");
            fileName = f.getName();
            LOGGER.debug("Retriving local input from file: " + fileName);
            if (this.isXML(fileLink)) {
                String xmlFile = f.getAbsolutePath();
                String csvFile = xmlFile + ".csv";
                LOGGER.debug("Transforming XML file into a csv: " + csvFile);
                GML2CSV.parseGML(xmlFile, csvFile);
                LOGGER.debug("GML Parsed: " + this.readOneLine(csvFile) + "[..]");
                f = new File(csvFile);
            } else {
                LOGGER.debug("The file is a csv: " + f.getAbsolutePath());
            }
            String absFile = new File(f.getParent(), inputName + "_[" + this.computationId + "].csv").getAbsolutePath();
            LOGGER.debug("Renaming to: " + absFile);
            System.gc();
            boolean renamed = f.renameTo(new File(absFile));
            if (renamed) {
                f = new File(absFile);
            }
            LOGGER.debug("The file has been renamed as : " + f.getAbsolutePath() + " - " + renamed);
            filesList.add(f);
        }
        return filesList;
    }

    public void createTable(String tableName, File tableFile, AlgorithmConfiguration config, DatabaseInfo supportDatabaseInfo, String inputTableTemplate) throws Exception {
        LOGGER.debug("Complex Input size after download: " + tableFile.length());
        if (tableFile.length() == 0L) {
            throw new Exception("Error: the Input file is empty");
        }
        LOGGER.debug("Creating table from file: " + tableFile.getAbsolutePath());
        SessionFactory dbConnection = null;
        try {
            dbConnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)config);
            BufferedReader br = new BufferedReader(new FileReader(tableFile));
            String header = br.readLine();
            br.close();
            LOGGER.debug("File header: " + header);
            String templatename = inputTableTemplate;
            LOGGER.debug("Suggested Template: " + templatename);
            String tableStructure = this.suggestTableStructure(header, templatename);
            LOGGER.debug("Extracted table structure: " + tableStructure);
            if (tableStructure == null) {
                throw new Exception("Input table is not compliant to the required structure");
            }
            TableTemplatesMapper mapper = new TableTemplatesMapper();
            String createstatement = mapper.generateCreateStatement(tableName, templatename, tableStructure);
            LOGGER.debug("Creating table: " + tableName);
            DatabaseUtils.createBigTable((boolean)true, (String)tableName, (String)supportDatabaseInfo.driver, (String)supportDatabaseInfo.username, (String)supportDatabaseInfo.password, (String)supportDatabaseInfo.url, (String)createstatement, (SessionFactory)dbConnection);
            DatabaseUtils.createRemoteTableFromFile((String)tableFile.getAbsolutePath(), (String)tableName, (String)",", (boolean)true, (String)supportDatabaseInfo.username, (String)supportDatabaseInfo.password, (String)supportDatabaseInfo.url);
        }
        catch (Exception e) {
            LOGGER.error("Error in database transaction ", (Throwable)e);
            throw new Exception("Error in creating the table for " + tableName + ": " + e.getLocalizedMessage());
        }
        finally {
            DatabaseUtils.closeDBConnection((SessionFactory)dbConnection);
        }
    }

    public String suggestTableStructure(String header, String templatename) {
        TableTemplatesMapper mapper = new TableTemplatesMapper();
        String variablesString = mapper.varsMap.get(templatename);
        String[] headersVector = header.split(",");
        String[] variables = variablesString.split(",");
        boolean check = true;
        HashMap<String, String> definitionsMap = new HashMap<String, String>();
        for (String var : variables) {
            if ((var = var.trim()).contains("<")) {
                check = false;
            }
            if (check) {
                String varname = var.substring(0, var.indexOf(" "));
                boolean found = false;
                for (String headvar : headersVector) {
                    if (!headvar.trim().equalsIgnoreCase(varname)) continue;
                    definitionsMap.put(headvar.trim(), var);
                    found = true;
                    break;
                }
                if (!found) {
                    return null;
                }
            }
            if (!var.contains(">")) continue;
            check = true;
        }
        StringBuffer structure = new StringBuffer();
        int counter = 0;
        for (String headvar : headersVector) {
            String def = (String)definitionsMap.get(headvar);
            if (def == null) {
                structure.append(headvar + " character varying");
            } else {
                structure.append(def);
            }
            if (counter < headersVector.length - 1) {
                structure.append(", ");
            }
            ++counter;
        }
        return structure.toString();
    }

    public void addInputServiceParameters(List<StatisticalType> agentInputs, InfrastructureDialoguer infrastructureDialoguer) throws Exception {
        DatabaseInfo dbinfo = null;
        this.inputTableTemplates = new HashMap();
        for (StatisticalType type : agentInputs) {
            String name;
            String name2;
            if (type instanceof PrimitiveType && ((PrimitiveType)type).getType() == PrimitiveTypes.CONSTANT) {
                String constant = "" + ((PrimitiveType)type).getDefaultValue();
                this.config.setParam(type.getName(), constant);
                LOGGER.debug("Constant parameter: " + constant);
            }
            if (type instanceof ServiceType) {
                ServiceType stype = (ServiceType)type;
                LOGGER.debug("Found ServiceType Input: " + stype);
                name2 = stype.getName();
                LOGGER.debug("ServiceType Input Name: " + name2);
                ServiceParameters sp = stype.getServiceParameter();
                LOGGER.debug("ServiceType Parameter: " + sp);
                String value = "";
                if (sp == ServiceParameters.RANDOMSTRING) {
                    value = "stat" + UUID.randomUUID().toString().replace("-", "");
                } else if (sp == ServiceParameters.USERNAME) {
                    value = (String)this.inputs.get(ConfigurationManager.usernameParameter);
                    LOGGER.debug("User name used by the client: " + value);
                }
                LOGGER.debug("ServiceType Adding: (" + name2 + "," + value + ")");
                this.config.setParam(name2, value);
                continue;
            }
            if (type instanceof DatabaseType) {
                DatabaseType dtype = (DatabaseType)type;
                name2 = dtype.getName();
                LOGGER.debug("Found DatabaseType Input: " + dtype + " with name " + name2);
                DatabaseParameters parameter = dtype.getDatabaseParameter();
                LOGGER.debug("DatabaseType Input Parameter: " + parameter);
                if (parameter == DatabaseParameters.REMOTEDATABASERRNAME) {
                    dbinfo = infrastructureDialoguer.getDatabaseInfo(name2);
                    LOGGER.debug("Requesting remote database name: " + name2);
                } else if (parameter == DatabaseParameters.REMOTEDATABASEDIALECT) {
                    this.config.setParam(name2, dbinfo.dialect);
                    LOGGER.debug("Extracted db dialect: " + dbinfo.dialect);
                } else if (parameter == DatabaseParameters.REMOTEDATABASEDRIVER) {
                    this.config.setParam(name2, dbinfo.driver);
                    LOGGER.debug("Extracted db driver: " + dbinfo.driver);
                } else if (parameter == DatabaseParameters.REMOTEDATABASEPASSWORD) {
                    this.config.setParam(name2, dbinfo.password);
                    LOGGER.debug("Extracted db password: " + dbinfo.password);
                } else if (parameter == DatabaseParameters.REMOTEDATABASEUSERNAME) {
                    this.config.setParam(name2, dbinfo.username);
                    LOGGER.debug("Extracted db username: " + dbinfo.username);
                } else if (parameter == DatabaseParameters.REMOTEDATABASEURL) {
                    this.config.setParam(name2, dbinfo.url);
                    LOGGER.debug("Extracted db url: " + dbinfo.url);
                }
                LOGGER.debug("DatabaseType Input Parameter Managed");
                continue;
            }
            if (type instanceof InputTable) {
                name = type.getName();
                this.inputTableTemplates.put(name, ((TableTemplates)((InputTable)type).getTemplateNames().get(0)).name());
                continue;
            }
            if (!(type instanceof TablesList)) continue;
            name = type.getName();
            this.inputTableTemplates.put(name, ((TableTemplates)((TablesList)type).getTemplates().get(0)).name());
        }
    }

    private void saveInputData(String name, String description, String payload) {
        String id = name;
        DataProvenance provenance = DataProvenance.IMPORTED;
        String creationDate = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(System.currentTimeMillis());
        String operator = this.config.getAgent();
        String type = "text/plain";
        if (payload != null && new File(payload).exists()) {
            type = payload.toLowerCase().endsWith(".csv") || payload.toLowerCase().endsWith(".txt") ? "text/csv" : "application/d4science";
        }
        StoredData data = new StoredData(name, description, id, provenance, creationDate, operator, this.computationId, type, payload, this.config.getGcubeScope());
        this.provenanceData.add(data);
    }
}

