/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.UUID;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.n52.wps.commons.XMLUtil;
import org.n52.wps.server.database.DatabaseFactory;
import org.n52.wps.server.database.IDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelComputation
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(CancelComputation.class);
    private static final long serialVersionUID = -268198171054599696L;
    public static final String SERVLET_PATH = "RetrieveResultServlet";
    private final int uuid_length = 36;
    public static String empty = "<wps:ExecuteResponse service=\"WPS\" serviceInstance=\"\" statusLocation=\"\" version=\"1.0.0\" xml:lang=\"en-US\" xsi:schemaLocation=\"http://www.opengis.net/wps/1.0.0 http://schemas.opengis.net/wps/1.0.0/wpsExecute_response.xsd\" xmlns:ows=\"http://www.opengis.net/ows/1.1\" xmlns:wps=\"http://www.opengis.net/wps/1.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"> <wps:Process wps:processVersion=\"1.1.0\"/> </wps:ExecuteResponse>";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String id = request.getParameter("id");
        LOGGER.debug("CANCEL COMPUTATION -> RETRIEVING ID " + id);
        if (StringUtils.isEmpty((String)id)) {
            this.errorResponse("id parameter missing", response);
        } else {
            LOGGER.debug("CANCEL COMPUTATION -> ID RETRIEVED " + id);
            if (!this.isIDValid(id)) {
                this.errorResponse("id parameter not valid", response);
            }
            LOGGER.debug("CANCEL COMPUTATION -> ID IS VALID " + id);
            IDatabase db = DatabaseFactory.getDatabase();
            long len = db.getContentLengthForStoreResponse(id);
            LOGGER.debug("CANCEL COMPUTATION -> INITIAL ID RESPONSE LENGTH " + len);
            try {
                LOGGER.debug("CANCEL COMPUTATION -> DELETING ID " + id);
                try {
                    ByteArrayInputStream stream = new ByteArrayInputStream(empty.getBytes("UTF-8"));
                    db.updateResponse(id, (InputStream)stream);
                    ((InputStream)stream).close();
                }
                catch (Exception e) {
                    LOGGER.error("error reading th einput stream", (Throwable)e);
                }
                LOGGER.debug("CANCEL COMPUTATION -> ID DELETED " + id);
                len = db.getContentLengthForStoreResponse(id);
                LOGGER.debug("CANCEL COMPUTATION -> ID RESPONSE LENGTH " + len);
            }
            catch (Exception e) {
                LOGGER.error("error in do get", (Throwable)e);
            }
        }
    }

    protected void errorResponse(String error, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setStatus(400);
        PrintWriter writer = response.getWriter();
        writer.write("<html><title>Error</title><body>" + error + "</body></html>");
        writer.flush();
        LOGGER.warn("Error processing response: " + error);
    }

    protected void copyResponseStream(InputStream inputStream, OutputStream outputStream, String id, long contentLength) throws IOException {
        long contentWritten = 0L;
        try {
            int bufferRead;
            byte[] buffer = new byte[8192];
            while ((bufferRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bufferRead);
                contentWritten += (long)bufferRead;
            }
        }
        catch (IOException e) {
            String exceptionMessage = contentLength > -1L ? String.format("Error writing response to output stream for id %s, %d of %d bytes written", id, contentWritten, contentLength) : String.format("Error writing response to output stream for id %s, %d bytes written", id, contentWritten);
            throw new IOException(exceptionMessage, e);
        }
        LOGGER.info("{} bytes written in response to id {}", (Object)contentWritten, (Object)id);
    }

    protected void copyResponseAsXML(InputStream inputStream, OutputStream outputStream, boolean indent, String id) throws IOException {
        try {
            XMLUtil.copyXML((InputStream)inputStream, (OutputStream)outputStream, (boolean)indent);
        }
        catch (IOException e) {
            throw new IOException("Error writing XML response for id " + id, e);
        }
    }

    public static Throwable getRootCause(Throwable t) {
        return t.getCause() == null ? t : CancelComputation.getRootCause(t.getCause());
    }

    public boolean isIDValid(String id) {
        if (id.length() <= 36) {
            try {
                UUID checkUUID = UUID.fromString(id);
                return checkUUID.toString().equals(id);
            }
            catch (Exception e) {
                return false;
            }
        }
        String uuidPartOne = id.substring(0, 36);
        String uuidPartTwo = id.substring(id.length() - 36, id.length());
        return this.isUUIDValid(uuidPartOne) && this.isUUIDValid(uuidPartTwo);
    }

    public boolean isUUIDValid(String uuid) {
        try {
            UUID checkUUID = UUID.fromString(uuid);
            return checkUUID.toString().equals(uuid);
        }
        catch (Exception e) {
            return false;
        }
    }
}

