/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure;

import java.security.Key;
import java.util.List;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.infrastructure.DatabaseInfo;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfrastructureDialoguer {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfrastructureDialoguer.class);
    public String scope;

    public InfrastructureDialoguer(String scope) {
        this.scope = scope;
    }

    public DatabaseInfo getDatabaseInfo(String resourceName) throws Exception {
        DatabaseInfo dbi = new DatabaseInfo();
        LOGGER.debug("Searching for Database " + resourceName + " in scope " + this.scope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Name eq '" + resourceName + "' ");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        if (resources == null || resources.size() == 0) {
            throw new Exception("No resource named " + resourceName + " available in scope " + this.scope);
        }
        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)((ServiceEndpoint)resources.get(0)).profile().accessPoints().iterator().next();
        dbi.url = ap.address();
        dbi.username = ap.username();
        dbi.password = StringEncrypter.getEncrypter().decrypt(ap.password().trim(), new Key[0]);
        for (ServiceEndpoint.Property property : ap.properties()) {
            if (!property.name().equalsIgnoreCase("driver")) continue;
            dbi.driver = property.value();
        }
        LOGGER.debug("Found Database : " + dbi);
        if (dbi.url == null) {
            throw new Exception("No database URL for resource " + resourceName + " available in scope " + this.scope);
        }
        return dbi;
    }

    public List<String> getAlgorithmsInScope() throws Exception {
        LOGGER.debug("Searching for Algorithms in scope {} with classloader type {}", (Object)this.scope, (Object)Thread.currentThread().getContextClassLoader().getClass().getSimpleName());
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/string() eq 'StatisticalManagerAlgorithm' ");
        query.setResult("$resource/Profile/Name/text()");
        DiscoveryClient client = ICFactory.client();
        List resources = client.submit((Query)query);
        if (resources == null || resources.size() == 0) {
            throw new Exception("No resource named StatisticalManagerAlgorithm available in scope " + this.scope);
        }
        LOGGER.debug("Found {} algorithms", (Object)resources.size());
        return resources;
    }
}

