/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.datasetimporter.util;

import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.gcube.dataanalysis.datasetimporter.util.PropertiesUtils;

public class ConfigurationUtil {
    private String localConfigurationFile;

    public String getProperty(String key) throws NoSuchElementException {
        String out = this.getPropertyInEnvironment(key);
        if (out == null) {
            out = this.getProperyInLocalConfigurationFile(key);
        }
        if (out != null) {
            return out.trim();
        }
        throw new NoSuchElementException("Unable to find property " + key + " either in environment and configuration files.");
    }

    private String getPropertyInEnvironment(String key) {
        return System.getenv(key);
    }

    private String getProperyInLocalConfigurationFile(String key) {
        File f = new File(this.getLocalConfigurationFile());
        if (f.exists()) {
            try {
                return PropertiesUtils.getProperties(f).get(key);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public String getLocalConfigurationFile() {
        return this.localConfigurationFile;
    }

    public void setLocalConfigurationFile(String localConfigurationFile) {
        this.localConfigurationFile = localConfigurationFile;
    }
}

