/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.JobSMspd;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.model.PluginDescription;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.dataanalysis.JobSMspd.ThreadExtractionOccFromSPD;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.DynamicEnum;
import org.hibernate.SessionFactory;

public class OccurencesProcedure
extends StandardLocalExternalAlgorithm {
    LinkedHashMap<String, StatisticalType> map = new LinkedHashMap();
    static String databaseParameterName = "FishBase";
    static String userParameterName = "user";
    static String passwordParameterName = "password";
    static String urlParameterName = "FishBase";
    SessionFactory dbconnection = null;
    public static boolean call = false;
    String tablename;
    String columnnames;
    List<Object> speciesList;
    protected String fileName;
    BufferedWriter out;
    String outputtablename;
    String outputErrortablename;
    String outputtable;
    HashMap<String, String> dpHash = new HashMap();
    HashMap<String, String> dpUHash = new HashMap();
    HashMap<String, String> dpEHash = new HashMap();
    String tableError;
    private DataPenum dp = new DataPenum();
    private ExtentionDPEnum dpE = new ExtentionDPEnum();
    private UnfoldDPEnum dpU = new UnfoldDPEnum();
    private String dataProvider = "Data Provider :";
    private String chosendataProvider = new String();
    private String dataProviderExtention = "Data Provider (Expand Option):";
    private String chosendataProviderExtention = new String();
    private String dataProviderUnfold = "Data Provider (Unfold Option):";
    private String chosendataProviderUnfold = new String();

    public String getDescription() {
        return "An Algorithm that retrieves the occurrences from a data provided based on the given search options";
    }

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"SMFaoAlg");
    }

    public void fulfilParameters() throws IOException {
        this.config.setParam("DatabaseDriver", "org.postgresql.Driver");
        this.dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
        this.tablename = this.getInputParameter("SpeciesTable");
        this.columnnames = this.getInputParameter("SpeciesColumns");
        this.outputtablename = this.getInputParameter("OutputTableName");
        this.outputtable = this.getInputParameter("OutputTable");
        this.tableError = this.getInputParameter("ErrorTable");
        this.chosendataProviderUnfold = this.getInputParameter(this.dataProviderUnfold);
        this.chosendataProviderExtention = this.getInputParameter(this.dataProviderExtention);
        this.chosendataProvider = this.getInputParameter(this.dataProvider);
        this.outputErrortablename = this.getInputParameter("ErrorTableName");
        String[] columnlist = this.columnnames.split(AlgorithmConfiguration.getListSeparator());
        this.speciesList = DatabaseFactory.executeSQLQuery((String)("select " + columnlist[0] + " from " + this.tablename), (SessionFactory)this.dbconnection);
        this.fileName = this.config.getPersistencePath() + "results.csv";
        this.out = new BufferedWriter(new FileWriter(this.fileName));
    }

    protected void process() throws Exception {
        try {
            this.fulfilParameters();
            this.createTables();
            int lenght = this.speciesList.size() / 3;
            ArrayList<String> chunk1 = new ArrayList<String>();
            ArrayList<String> chunk2 = new ArrayList<String>();
            ArrayList<String> chunk3 = new ArrayList<String>();
            for (int i = 0; i < this.speciesList.size(); ++i) {
                if (i < lenght) {
                    chunk1.add((String)this.speciesList.get(i));
                }
                if (i >= lenght && i <= 2 * lenght) {
                    chunk2.add((String)this.speciesList.get(i));
                }
                if (i <= 2 * lenght) continue;
                chunk3.add((String)this.speciesList.get(i));
            }
            String scope = ScopeProvider.instance.get();
            ThreadExtractionOccFromSPD t1 = new ThreadExtractionOccFromSPD(chunk1, this.chosendataProvider, this.chosendataProviderExtention, this.chosendataProviderUnfold, scope);
            ThreadExtractionOccFromSPD t2 = new ThreadExtractionOccFromSPD(chunk2, this.chosendataProvider, this.chosendataProviderExtention, this.chosendataProviderUnfold, scope);
            ThreadExtractionOccFromSPD t3 = new ThreadExtractionOccFromSPD(chunk3, this.chosendataProvider, this.chosendataProviderExtention, this.chosendataProviderUnfold, scope);
            Thread th1 = new Thread(t1);
            th1.start();
            Thread th2 = new Thread(t2);
            th2.start();
            Thread th3 = new Thread(t3);
            th3.start();
            th1.join();
            th2.join();
            th3.join();
            this.write("scientific_name; author; catalogue_number; citation; collection_gode; cordinate_uncertaninty_in_meters; country;credits; family; id; institution_code; kingdom; locality; providere; latitude; longitude; max_depth; min_depth");
            this.out.newLine();
            this.insertInTheTable(t1.getInfo());
            this.insertInTheTable(t2.getInfo());
            this.insertInTheTable(t3.getInfo());
            this.insertInTheTableErrors(t1.getErrors());
            this.insertInTheTableErrors(t2.getErrors());
            this.insertInTheTableErrors(t3.getErrors());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            DatabaseUtils.closeDBConnection((SessionFactory)this.dbconnection);
            this.out.close();
        }
    }

    private void createTables() throws Exception {
        DatabaseFactory.executeSQLUpdate((String)("create table " + this.tableError + " (error character varying)"), (SessionFactory)this.dbconnection);
    }

    private void insertInTheTable(ArrayList<ArrayList<String>> arrays) throws Exception {
        for (ArrayList<String> array : arrays) {
            String writeString = new String();
            int i = 0;
            for (String s : array) {
                if (i != 0) {
                    writeString = writeString + "; ";
                }
                writeString = writeString + " '";
                if (s != null) {
                    s = s.replace("'", "");
                }
                writeString = writeString + s;
                writeString = writeString + "'";
                ++i;
            }
            this.write(writeString);
            this.out.newLine();
        }
    }

    private void insertInTheTableErrors(ArrayList<String> arrays) throws Exception {
        if (arrays != null) {
            String st = " (error)";
            for (String er : arrays) {
                String query = "insert into " + this.tableError + st + " values ('" + er + "')";
                AnalysisLogger.getLogger().debug((Object)("query error : " + query));
                DatabaseFactory.executeSQLUpdate((String)query, (SessionFactory)this.dbconnection);
            }
        }
    }

    public void print(ArrayList<ArrayList<String>> arrays) {
        for (ArrayList<String> array : arrays) {
            for (String s : array) {
                AnalysisLogger.getLogger().debug((Object)s);
            }
        }
    }

    public void shutdown() {
    }

    public void setDynamicParameter() {
        AnalysisLogger.getLogger().debug((Object)"Inside setDynamicParameter");
        ScopeProvider.instance.set("/gcube/devsec");
        Manager manager = null;
        manager = (Manager)AbstractPlugin.manager().build();
        AnalysisLogger.getLogger().debug((Object)"costruito manager");
        AnalysisLogger.getLogger().debug((Object)"prima dei plugin");
        List plugin = manager.getPluginsDescription();
        AnalysisLogger.getLogger().debug((Object)"preso i plugin");
        this.dp.addEnum(DataProvidersType.class, "ALL");
        this.dpE.addEnum(ExtentionDPType.class, "ALL");
        this.dpU.addEnum(UnfoldDPEnumType.class, "NO OPTION");
        this.dpE.addEnum(ExtentionDPType.class, "NO OPTION");
        if (plugin != null) {
            AnalysisLogger.getLogger().debug((Object)("*****PluginDescription is NOT null - length: " + plugin.size()));
            for (int i = 0; i < plugin.size(); ++i) {
                PluginDescription pluginDescription = (PluginDescription)plugin.get(i);
                AnalysisLogger.getLogger().debug((Object)("For   plugin ***" + pluginDescription.getName()));
                Map pluginCapabilities = pluginDescription.getSupportedCapabilities();
                AnalysisLogger.getLogger().debug((Object)"created maps");
                AnalysisLogger.getLogger().debug((Object)(" map size" + pluginCapabilities.size()));
                for (Map.Entry pluginCapability : pluginCapabilities.entrySet()) {
                    Capabilities capability = (Capabilities)pluginCapability.getKey();
                    AnalysisLogger.getLogger().debug((Object)capability.name().toString());
                    if (capability.name().toString().equals("Unfold")) {
                        this.dpU.addEnum(UnfoldDPEnumType.class, pluginDescription.getName().toString());
                    }
                    if (capability.name().toString().equals("Expansion")) {
                        this.dpE.addEnum(ExtentionDPType.class, pluginDescription.getName().toString());
                    }
                    if (!capability.name().toString().equals("Occurrence")) continue;
                    this.dp.addEnum(DataProvidersType.class, pluginDescription.getName().toString());
                }
            }
        } else {
            AnalysisLogger.getLogger().debug((Object)"*****PluginDescription is null");
        }
    }

    protected void setInputParameters() {
        try {
            AnalysisLogger.getLogger().debug((Object)"inside setInputParameters ");
            this.addRemoteDatabaseInput(databaseParameterName, urlParameterName, userParameterName, passwordParameterName, "driver", "dialect");
            ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
            templates.add(TableTemplates.GENERIC);
            InputTable tinput = new InputTable(templates, "SpeciesTable", "The table containing the species information");
            ColumnTypesList columns = new ColumnTypesList("SpeciesTable", "SpeciesColumns", "Select the columns for  species name", false);
            this.addStringInput("OutputTableName", "The name of the output table", "occ_");
            this.addStringInput("ErrorTableName", "The name of the output table", "err_");
            ServiceType randomstring = new ServiceType(ServiceParameters.RANDOMSTRING, "OutputTable", "", "occ");
            ServiceType randomstringErr = new ServiceType(ServiceParameters.RANDOMSTRING, "ErrorTable", "", "err");
            AnalysisLogger.getLogger().debug((Object)"before setDynamicParameter() ");
            if (!call) {
                this.setDynamicParameter();
            }
            this.addEnumerateInput(DataProvidersType.values(), this.dataProvider, "Choose Data Providere", "ALL");
            AnalysisLogger.getLogger().debug((Object)"Dopo DataProvidersType");
            this.addEnumerateInput(ExtentionDPType.values(), this.dataProviderExtention, "Choose Expand Option Data Providere", "ALL");
            AnalysisLogger.getLogger().debug((Object)"Dopo ExtentionDPType");
            this.addEnumerateInput(UnfoldDPEnumType.values(), this.dataProviderUnfold, "Choose UnfoldRR Option Data Providere", "ALL");
            AnalysisLogger.getLogger().debug((Object)"Dopo UnfoldDPEnumType");
            this.inputs.add(tinput);
            this.inputs.add(columns);
            this.inputs.add(randomstring);
            this.inputs.add(randomstringErr);
            DatabaseType.addDefaultDBPars((List)this.inputs);
        }
        catch (Throwable e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)e.toString());
        }
        call = true;
    }

    public StatisticalType getOutput() {
        ArrayList<TableTemplates> outtemplate = new ArrayList<TableTemplates>();
        outtemplate.add(TableTemplates.GENERIC);
        ArrayList<TableTemplates> outtemplateErr = new ArrayList<TableTemplates>();
        outtemplateErr.add(TableTemplates.GENERIC);
        OutputTable outErr = new OutputTable(outtemplate, this.outputErrortablename, this.tableError, "The output table containing all the matches");
        PrimitiveType f = new PrimitiveType(File.class.getName(), (Object)new File(this.fileName), PrimitiveTypes.FILE, "OccFile", "OccFile");
        this.map.put("Output", (StatisticalType)f);
        this.map.put("Errors", (StatisticalType)outErr);
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), this.map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return output;
    }

    public void write(String writeSt) {
        try {
            this.out.write(writeSt);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class UnfoldDPEnum
    extends DynamicEnum {
        UnfoldDPEnum() {
        }

        public Field[] getFields() {
            Field[] fields = UnfoldDPEnumType.class.getDeclaredFields();
            return fields;
        }
    }

    static enum UnfoldDPEnumType {

    }

    class ExtentionDPEnum
    extends DynamicEnum {
        ExtentionDPEnum() {
        }

        public Field[] getFields() {
            Field[] fields = ExtentionDPType.class.getDeclaredFields();
            return fields;
        }
    }

    static enum ExtentionDPType {

    }

    class DataPenum
    extends DynamicEnum {
        DataPenum() {
        }

        public Field[] getFields() {
            Field[] fields = DataProvidersType.class.getDeclaredFields();
            return fields;
        }
    }

    static enum DataProvidersType {

    }
}

