/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.trendylyzeralgorithms;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanagement.graphtools.plotting.graphs.TimeSeriesGraph;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.trendylyzeralgorithms.TaxaEnum;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Year;
import org.postgresql.Driver;

public class TaxaObservationsPerYearLineChart
extends StandardLocalExternalAlgorithm {
    static String databaseName = "DatabaseName";
    static String userParameterName = "DatabaseUserName";
    static String passwordParameterName = "DatabasePassword";
    static String urlParameterName = "DatabaseURL";
    private String yearStart = "Start_year";
    private String yearEnd = "End_year";
    private String taxa = "Level";
    private String tax;
    private String[] taxaNames;
    private TimeSeriesCollection dataset;
    protected String fileName;
    BufferedWriter out;

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Initialization TaxaObservationsPerYearLineChart");
    }

    public String getDescription() {
        return "Algorithm returning most observations taxonomy trend in a specific years range (with respect to the OBIS database)";
    }

    protected void process() throws Exception {
        String driverName = "org.postgresql.Driver";
        this.dataset = new TimeSeriesCollection();
        Class<?> driverClass = Class.forName(driverName);
        Driver driver = (Driver)driverClass.newInstance();
        String databaseJdbc = this.getInputParameter(urlParameterName);
        String year_start = this.getInputParameter(this.yearStart);
        String year_end = this.getInputParameter(this.yearEnd);
        this.fileName = String.valueOf(this.config.getPersistencePath()) + "results.csv";
        this.out = new BufferedWriter(new FileWriter(this.fileName));
        this.tax = this.getInputParameter(this.taxa);
        String table = "genus_table_per_year";
        String column_name = "genus";
        if (this.tax.equals("GENUS")) {
            table = "genus_table_per_year";
            column_name = "genus";
        } else if (this.tax.equals("CLASS")) {
            table = "class_table_per_year";
            column_name = "class";
        } else if (this.tax.equals("FAMILY")) {
            table = "family_table_per_year";
            column_name = "family";
        } else if (this.tax.equals("ORDER")) {
            table = "order_table_per_year";
            column_name = "order";
        }
        String databaseUser = this.getInputParameter(userParameterName);
        String databasePwd = this.getInputParameter(passwordParameterName);
        Connection connection = null;
        connection = DriverManager.getConnection(databaseJdbc, databaseUser, databasePwd);
        Statement stmt = connection.createStatement();
        String[] stringArray = this.taxaNames = this.config.getParam("Selected taxonomy").split(AlgorithmConfiguration.getListSeparator());
        int n = this.taxaNames.length;
        int n2 = 0;
        while (n2 < n) {
            String tx = stringArray[n2];
            AnalysisLogger.getLogger().debug((Object)("Species: " + tx));
            String query = "select \"" + column_name + "\",year,count from " + table + " where upper(" + column_name + ") like upper('" + tx + "') and year::integer >=" + year_start + "AND year::integer <=" + year_end + " order by year;";
            AnalysisLogger.getLogger().debug((Object)query);
            ResultSet rs = stmt.executeQuery(query);
            TimeSeries series = new TimeSeries((Comparable)((Object)tx));
            while (rs.next()) {
                if (rs.getString("year") == null) continue;
                int year = Integer.parseInt(rs.getString("year"));
                int count = Integer.parseInt(rs.getString("count"));
                AnalysisLogger.getLogger().debug((Object)("year: " + year + "  count : " + count));
                this.out.write(String.valueOf(tx) + "," + year + "," + count);
                this.out.newLine();
                series.add((RegularTimePeriod)new Year(year), (double)count);
            }
            this.dataset.addSeries(series);
            ++n2;
        }
        AnalysisLogger.getLogger().debug((Object)this.dataset.toString());
        this.out.close();
        connection.close();
    }

    protected void setInputParameters() {
        this.addEnumerateInput(TaxaEnum.values(), this.taxa, "Choose the taxonomy level", TaxaEnum.GENUS.name());
        this.addStringInput(this.yearStart, "Starting year of the analysis", "1800");
        this.addStringInput(this.yearEnd, "Ending year of the analysis", "2020");
        PrimitiveTypesList taxaSelected = new PrimitiveTypesList(String.class.getName(), PrimitiveTypes.STRING, "Selected taxonomy", "List of taxa to analyze", false);
        this.inputs.add(taxaSelected);
        this.addRemoteDatabaseInput("TrendyLyzerObis", urlParameterName, userParameterName, passwordParameterName, "driver", "dialect");
    }

    public void shutdown() {
    }

    public StatisticalType getOutput() {
        PrimitiveType p = new PrimitiveType(Map.class.getName(), (Object)PrimitiveType.stringMap2StatisticalMap((HashMap)this.outputParameters), PrimitiveTypes.MAP, "Discrepancy Analysis", "");
        AnalysisLogger.getLogger().debug((Object)"MapsComparator: Producing Line Chart for the errors");
        HashMap<String, Image> producedImages = new HashMap<String, Image>();
        JFreeChart chart = TimeSeriesGraph.createStaticChart((Dataset)this.dataset, (String)"yyyy");
        Image image = ImageTools.toImage((BufferedImage)chart.createBufferedImage(680, 420));
        producedImages.put("Taxa observations tends per year (" + this.tax + ")", image);
        PrimitiveType images = new PrimitiveType(HashMap.class.getName(), producedImages, PrimitiveTypes.IMAGES, "ErrorRepresentation", "Taxa observations per year (" + this.tax + ")");
        AnalysisLogger.getLogger().debug((Object)"Line Taxonomy Occurrences Produced");
        LinkedHashMap<String, PrimitiveType> map = new LinkedHashMap<String, PrimitiveType>();
        PrimitiveType f = new PrimitiveType(File.class.getName(), (Object)new File(this.fileName), PrimitiveTypes.FILE, "Species observations per area", "ObsFile");
        map.put("Output", f);
        map.put("Result", p);
        map.put("Images", images);
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return output;
    }
}

