/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.JobSMspd;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.streams.Stream;

public class ThreadExtractionOccFromSPD
implements Runnable {
    private ArrayList<String> chunk;
    private ArrayList<ArrayList<String>> informations;
    private ArrayList<String> errors;
    BufferedWriter out;
    private String dataProvider;
    private String dataProviderUnfold;
    private String dataProviderExpand;
    String scope;
    private File tempFile;

    public ThreadExtractionOccFromSPD(ArrayList<String> chunk, String dataProvider, String dataProviderExpand, String dataProviderUnfold, String scope) {
        this.chunk = chunk;
        this.dataProvider = dataProvider;
        this.dataProviderExpand = dataProviderExpand;
        this.dataProviderUnfold = dataProviderUnfold;
        this.errors = new ArrayList();
        this.scope = scope;
    }

    @Override
    public void run() {
        AnalysisLogger.getLogger().debug((Object)("SCOPE  " + this.scope));
        try {
            this.tempFile = File.createTempFile("chunk" + Thread.currentThread().getId(), ".csv");
            this.out = new BufferedWriter(new FileWriter(this.tempFile, false));
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().error((Object)("Error in the chunk file creation: " + e));
        }
        ScopeProvider.instance.set(this.scope);
        Manager manager = null;
        try {
            manager = (Manager)AbstractPlugin.manager().build();
            for (String species : this.chunk) {
                if (species == null) continue;
                String query = new String();
                query = this.createQueryParameter(species);
                AnalysisLogger.getLogger().debug((Object)("QUERY *******: " + query));
                try {
                    Stream stream = manager.search(query);
                    int i = 0;
                    while (stream.hasNext()) {
                        ++i;
                        OccurrencePoint ti = (OccurrencePoint)stream.next();
                        ArrayList<String> array = this.crateRowTable(ti);
                        this.insertInTheFile(array);
                        array = null;
                        System.gc();
                    }
                    if (i != 0) continue;
                    this.errors.add(String.valueOf(species) + " not found.");
                }
                catch (Exception e) {
                    this.errors.add("Exception on " + species + " :" + e.getMessage());
                    e.printStackTrace();
                }
            }
            this.out.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("An error occurred: " + e.getMessage()));
        }
    }

    private String createQueryParameter(String species) {
        String query = "SEARCH BY SN '" + species + "'";
        String where = new String();
        String expand = new String();
        String unfold = new String();
        where = this.dataProvider.equals("ALL") ? "" : " IN " + this.dataProvider;
        unfold = this.dataProviderUnfold.equals("NO OPTION") ? "" : " UNFOLD WITH " + this.dataProviderUnfold;
        query = String.valueOf(query) + unfold;
        AnalysisLogger.getLogger().debug((Object)("expand is : " + this.dataProviderExpand));
        if (this.dataProviderExpand.equals("ALL")) {
            expand = " EXPAND";
        } else {
            AnalysisLogger.getLogger().debug((Object)"inside else ");
            expand = this.dataProviderExpand.equals("NO OPTION") ? "" : " EXPAND WITH " + this.dataProviderExpand;
        }
        query = String.valueOf(query) + expand;
        query = String.valueOf(query) + where;
        query = String.valueOf(query) + " RETURN occurrence";
        return query;
    }

    private ArrayList<String> crateRowTable(OccurrencePoint occurrence) {
        ArrayList<String> infoOcc = new ArrayList<String>();
        try {
            infoOcc.add(occurrence.getInstitutionCode().replace(",", " "));
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getCollectionCode().replace(",", " "));
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getCatalogueNumber().replace(",", " "));
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getDataSet().getName());
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getDataSet().getDataProvider().getName());
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getProvider());
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getScientificNameAuthorship());
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getIdentifiedBy());
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getCredits());
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getRecordedBy());
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        if (occurrence.getEventDate() == null || sdf.format(occurrence.getEventDate().getTime()).length() == 0) {
            infoOcc.add("");
        } else {
            try {
                infoOcc.add(sdf.format(occurrence.getEventDate().getTime()));
            }
            catch (Exception e) {
                infoOcc.add("");
            }
        }
        if (occurrence.getModified() == null || sdf.format(occurrence.getModified().getTime()).length() == 0) {
            infoOcc.add("");
        } else {
            try {
                infoOcc.add(sdf.format(occurrence.getModified().getTime()));
            }
            catch (Exception e) {
                infoOcc.add("");
            }
        }
        try {
            infoOcc.add(occurrence.getScientificName());
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getKingdom());
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getFamily());
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getLocality());
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getCountry());
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getCitation());
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(Double.toString(occurrence.getDecimalLatitude()));
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(Double.toString(occurrence.getDecimalLongitude()));
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getCoordinateUncertaintyInMeters());
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(Double.toString(occurrence.getMaxDepth()));
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(Double.toString(occurrence.getMinDepth()));
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        try {
            infoOcc.add(occurrence.getBasisOfRecord().toString());
        }
        catch (Exception e) {
            infoOcc.add("");
        }
        return infoOcc;
    }

    private void insertInTheFile(ArrayList<String> array) throws Exception {
        String writeString = new String();
        int i = 0;
        for (String s : array) {
            if (i == array.size() - 1) {
                writeString = s == null ? String.valueOf(writeString) + " " : String.valueOf(writeString) + s.replace(",", " ");
            } else if (s == null) {
                writeString = String.valueOf(writeString) + " ,";
                if (i == 10 || i == 11) {
                    writeString = String.valueOf(writeString) + ",";
                }
            } else {
                writeString = String.valueOf(writeString) + s.replace(",", " ") + ",";
            }
            ++i;
        }
        this.write(writeString);
        this.out.newLine();
    }

    private void write(String writeSt) {
        try {
            this.out.write(writeSt);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File getInfo() {
        return this.tempFile;
    }

    public ArrayList<String> getErrors() {
        return this.errors;
    }
}

