/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.fin.taxamatch;

import java.util.ArrayList;
import java.util.List;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.hibernate.SessionFactory;

public class TaxaMatchListTransducer
extends StandardLocalExternalAlgorithm {
    static String GenusOperator = "ComparisonOperatorforGenus";
    static String SpeciesOperator = "ComparisonOperatorforSpecies";
    static String Genus = "Genus";
    static String Species = "Species";
    static String databaseParameterName = "FishBase";
    static String userParameterName = "user";
    static String passwordParameterName = "password";
    static String urlParameterName = "FishBase";
    String outputtablename;
    String outputtable;

    public String getDescription() {
        return "An algorithm for Taxa Matching with respect to the Fishbase database";
    }

    public void init() throws Exception {
    }

    protected void process() throws Exception {
        int separator;
        String databaseJdbc;
        String columnnames;
        String tablename;
        SessionFactory dbconnection;
        block5: {
            dbconnection = null;
            System.out.println("taxa->USING THE FOLLOWING PARAMETERS FOR DB:");
            System.out.println("taxa->driver:" + this.config.getParam("DatabaseDriver"));
            System.out.println("taxa->url:" + this.config.getParam("DatabaseURL"));
            System.out.println("taxa->user:" + this.config.getParam("DatabaseUserName"));
            System.out.println("taxa->password:" + this.config.getParam("DatabasePassword"));
            this.config.setParam("DatabaseDriver", "org.postgresql.Driver");
            dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
            tablename = this.getInputParameter("TaxaTable");
            columnnames = this.getInputParameter("TaxaColumns");
            this.outputtablename = this.getInputParameter("OutputTableName");
            this.outputtable = this.getInputParameter("OutputTable");
            String genusOperator = this.getInputParameter(GenusOperator);
            String speciesOperator = this.getInputParameter(SpeciesOperator);
            System.out.println("taxa->got input parameters");
            databaseJdbc = this.getInputParameter(urlParameterName).replace("//", "");
            separator = databaseJdbc.lastIndexOf("/");
            if (separator >= 0) break block5;
            this.log("Bad database URL: " + databaseJdbc);
            DatabaseUtils.closeDBConnection((SessionFactory)dbconnection);
            return;
        }
        try {
            try {
                System.out.println("taxa->got DB parameters " + databaseJdbc);
                String databaseIP = databaseJdbc.substring(0, separator);
                String databaseName = databaseJdbc.substring(separator + 1);
                String databaseUser = this.getInputParameter(userParameterName);
                String databasePwd = this.getInputParameter(passwordParameterName);
                System.out.println("taxa->Fishbase Database Parameters to use: " + databaseIP + " " + databaseName + " " + databaseUser + " " + databasePwd);
                String[] columnlist = columnnames.split(AlgorithmConfiguration.getListSeparator());
                System.out.println("taxa->got columns: " + columnlist[0] + " and " + columnlist[1]);
                System.out.println("taxa->Selecting genus ");
                List genusList = DatabaseFactory.executeSQLQuery((String)("select " + columnlist[0] + " from " + tablename), (SessionFactory)dbconnection);
                System.out.println("taxa->Selecting species");
                List speciesList = DatabaseFactory.executeSQLQuery((String)("select " + columnlist[1] + " from " + tablename), (SessionFactory)dbconnection);
                System.out.println("taxa->creating table create table " + this.outputtable + " (scientific_name character varying, value real)");
                DatabaseFactory.executeSQLUpdate((String)("create table " + this.outputtable + " (scientific_name character varying, value real)"), (SessionFactory)dbconnection);
                System.out.println("taxa->inserting into table insert into " + this.outputtable + " (scientific_name,value) values ('Gadus morhua', 3)");
                DatabaseFactory.executeSQLUpdate((String)("insert into " + this.outputtable + " (scientific_name,value) values ('Gadus morhua', 3)"), (SessionFactory)dbconnection);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        catch (Throwable throwable) {
            DatabaseUtils.closeDBConnection(dbconnection);
            throw throwable;
        }
        DatabaseUtils.closeDBConnection((SessionFactory)dbconnection);
    }

    private String doTaxaMatch() {
        return null;
    }

    public void shutdown() {
    }

    protected void setInputParameters() {
        this.addEnumerateInput(operators.values(), GenusOperator, "Comparison Operator for Genus", "" + (Object)((Object)operators.EQUAL));
        this.addEnumerateInput(operators.values(), SpeciesOperator, "Comparison Operator for Species", "" + (Object)((Object)operators.EQUAL));
        this.addRemoteDatabaseInput(databaseParameterName, urlParameterName, userParameterName, passwordParameterName, "driver", "dialect");
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.GENERIC);
        InputTable tinput = new InputTable(templates, "TaxaTable", "The table containing the taxa information");
        ColumnTypesList columns = new ColumnTypesList("TaxaTable", "TaxaColumns", "Select the columns for genus and species", false);
        this.addStringInput("OutputTableName", "The name of the output table", "taxa_");
        ServiceType randomstring = new ServiceType(ServiceParameters.RANDOMSTRING, "OutputTable", "", "taxa");
        this.inputs.add(tinput);
        this.inputs.add(columns);
        this.inputs.add(randomstring);
        DatabaseType.addDefaultDBPars((List)this.inputs);
    }

    public StatisticalType getOutput() {
        ArrayList<TableTemplates> outtemplate = new ArrayList<TableTemplates>();
        outtemplate.add(TableTemplates.GENERIC);
        OutputTable out = new OutputTable(outtemplate, this.outputtablename, this.outputtable, "The output table containing all the matches");
        return out;
    }

    public static enum operators {
        EQUAL,
        NOT_EQUAL,
        CONTAINS,
        BEGINS_WITH,
        ENDS_WITH;

    }
}

