/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geothermal;

import org.gcube.contentmanagement.graphtools.plotting.graphs.TimeSeriesGraph;
import org.gcube.dataanalysis.geothermal.AbstractProcess;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Year;

public class EnergyTrends
extends AbstractProcess {
    TimeSeriesCollection datasetMWE = new TimeSeriesCollection();
    TimeSeriesCollection datasetMWT = new TimeSeriesCollection();
    TimeSeriesCollection datasetTJY = new TimeSeriesCollection();

    @Override
    public String getDescription() {
        return "An algorithm reporting the energy trends for the countries contributing to EGIP";
    }

    @Override
    void initDatasets() {
    }

    @Override
    void fulfillDataset(String f_name, String f_area, double f_f1990_mwe, double f_f1995_mwt, double f_f1995_h_tjy, double f_f1995_mwe, double f_f2000_mwt, double f_f2000_h_tjy, double f_f2000_mwe, double f_f2005_mwt, double f_f2005_h_tjy, double f_f2005_mwe, double f_f2010_mwt, double f_f2010_h_tjy, double f_f2010_mwe, double f_f2013_mwe, int startYear, int endYear) {
        TimeSeries seriesMWE = new TimeSeries((Comparable)((Object)f_name));
        TimeSeries seriesMWT = new TimeSeries((Comparable)((Object)f_name));
        TimeSeries seriesTJY = new TimeSeries((Comparable)((Object)f_name));
        if (startYear <= 1990 && endYear >= 1990) {
            seriesMWE.add((RegularTimePeriod)new Year(1990), f_f1990_mwe);
        }
        if (startYear <= 1995 && endYear >= 1995) {
            seriesMWE.add((RegularTimePeriod)new Year(1995), f_f1995_mwe);
            seriesMWT.add((RegularTimePeriod)new Year(1995), f_f1995_mwt);
            seriesTJY.add((RegularTimePeriod)new Year(1995), f_f2000_h_tjy);
        }
        if (startYear <= 2000 && endYear >= 2000) {
            seriesMWE.add((RegularTimePeriod)new Year(2000), f_f2000_mwe);
            seriesMWT.add((RegularTimePeriod)new Year(2000), f_f2000_mwt);
            seriesTJY.add((RegularTimePeriod)new Year(2000), f_f2000_h_tjy);
        }
        if (startYear <= 2005 && endYear >= 2005) {
            seriesMWE.add((RegularTimePeriod)new Year(2005), f_f2005_mwe);
            seriesMWT.add((RegularTimePeriod)new Year(2005), f_f2005_mwt);
            seriesTJY.add((RegularTimePeriod)new Year(2005), f_f2005_h_tjy);
        }
        if (startYear <= 2010 && endYear >= 2010) {
            seriesMWE.add((RegularTimePeriod)new Year(2010), f_f2010_mwe);
            seriesMWT.add((RegularTimePeriod)new Year(2010), f_f2010_mwt);
            seriesTJY.add((RegularTimePeriod)new Year(2010), f_f2010_h_tjy);
        }
        if (startYear <= 2013 && endYear >= 2013) {
            seriesMWE.add((RegularTimePeriod)new Year(2013), f_f2013_mwe);
        }
        this.datasetMWE.addSeries(seriesMWE);
        this.datasetMWT.addSeries(seriesMWT);
        this.datasetTJY.addSeries(seriesTJY);
    }

    @Override
    JFreeChart createChartForMWE() {
        return TimeSeriesGraph.createStaticChart((Dataset)this.datasetMWE, (String)"yyyy");
    }

    @Override
    JFreeChart createChartForMWT() {
        return TimeSeriesGraph.createStaticChart((Dataset)this.datasetMWT, (String)"yyyy");
    }

    @Override
    JFreeChart createChartForTJY() {
        return TimeSeriesGraph.createStaticChart((Dataset)this.datasetTJY, (String)"yyyy");
    }

    @Override
    void renderChartForMWE() {
        TimeSeriesGraph tsg = new TimeSeriesGraph("MWE");
        tsg.timeseriesformat = "yyyy";
        tsg.render((Dataset)this.datasetMWE);
    }

    @Override
    void renderChartForMWT() {
        TimeSeriesGraph tsg2 = new TimeSeriesGraph("MWT");
        tsg2.timeseriesformat = "yyyy";
        tsg2.render((Dataset)this.datasetMWT);
    }

    @Override
    void renderChartForTJY() {
        TimeSeriesGraph tsg3 = new TimeSeriesGraph("TJY");
        tsg3.timeseriesformat = "yyyy";
        tsg3.render((Dataset)this.datasetTJY);
    }
}

