/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.trendylyzeralgorithms;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanagement.graphtools.plotting.graphs.TimeSeriesGraph;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Year;
import org.postgresql.Driver;

public class SpeciesObservationsPerYear
extends StandardLocalInfraAlgorithm {
    static String databaseName = "DatabaseName";
    static String userParameterName = "DatabaseUserName";
    static String passwordParameterName = "DatabasePassword";
    static String urlParameterName = "DatabaseURL";
    private String yearStart = "Start_year";
    private String yearEnd = "End_year";
    private String[] speciesNames;
    private TimeSeriesCollection dataset;
    protected String fileName;
    BufferedWriter out;

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Initialization SpeciesObservationsPerYear");
    }

    public String getDescription() {
        return "An algorithm producing the trend of the observations for a certain species in a certain years range.";
    }

    protected void process() throws Exception {
        this.dataset = new TimeSeriesCollection();
        String driverName = "org.postgresql.Driver";
        AnalysisLogger.getLogger().debug((Object)"Inside process ");
        this.fileName = this.config.getPersistencePath() + "results.csv";
        this.out = new BufferedWriter(new FileWriter(this.fileName));
        Class<?> driverClass = Class.forName(driverName);
        Driver driver = (Driver)driverClass.newInstance();
        String databaseJdbc = this.getInputParameter(urlParameterName);
        String year_start = this.getInputParameter(this.yearStart);
        String year_end = this.getInputParameter(this.yearEnd);
        String databaseUser = this.getInputParameter(userParameterName);
        String databasePwd = this.getInputParameter(passwordParameterName);
        Connection connection = null;
        connection = DriverManager.getConnection(databaseJdbc, databaseUser, databasePwd);
        Statement stmt = connection.createStatement();
        for (String sp : this.speciesNames = this.config.getParam("Selected species").split(AlgorithmConfiguration.getListSeparator())) {
            AnalysisLogger.getLogger().debug((Object)("Species: " + sp));
            String query = "select tname,year,count from public.count_species_per_year where upper(tname) like upper('" + sp + "') and year::integer >" + year_start + "AND year::integer <" + year_end + " order by year;";
            ResultSet rs = stmt.executeQuery(query);
            TimeSeries series = new TimeSeries((Comparable)((Object)sp));
            while (rs.next()) {
                if (rs.getString("year") == null) continue;
                int year = Integer.parseInt(rs.getString("year"));
                int count = Integer.parseInt(rs.getString("count"));
                this.out.write(sp + "," + year + "," + count);
                this.out.newLine();
                series.add((RegularTimePeriod)new Year(year), (double)count);
            }
            this.dataset.addSeries(series);
        }
        AnalysisLogger.getLogger().debug((Object)this.dataset.toString());
        this.out.close();
        connection.close();
    }

    public StatisticalType getOutput() {
        PrimitiveType p = new PrimitiveType(Map.class.getName(), (Object)PrimitiveType.stringMap2StatisticalMap((HashMap)this.outputParameters), PrimitiveTypes.MAP, " ", "");
        AnalysisLogger.getLogger().debug((Object)"MapsComparator: Producing Line Chart for the errors");
        HashMap<String, Image> producedImages = new HashMap<String, Image>();
        JFreeChart chart = TimeSeriesGraph.createStaticChart((Dataset)this.dataset, (String)"yyyy");
        Image image = ImageTools.toImage((BufferedImage)chart.createBufferedImage(680, 420));
        producedImages.put("Species observations per year", image);
        PrimitiveType images = new PrimitiveType(HashMap.class.getName(), producedImages, PrimitiveTypes.IMAGES, "ErrorRepresentation", "Species observations per year");
        AnalysisLogger.getLogger().debug((Object)"Line Species Occurrences Produced");
        LinkedHashMap<String, PrimitiveType> map = new LinkedHashMap<String, PrimitiveType>();
        PrimitiveType f = new PrimitiveType(File.class.getName(), (Object)new File(this.fileName), PrimitiveTypes.FILE, "Species observations per area", "ObsFile");
        map.put("Output", f);
        map.put("Result", p);
        map.put("Images", images);
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return output;
    }

    protected void setInputParameters() {
        this.addStringInput(this.yearStart, "Starting year of the analysis", "1800");
        this.addStringInput(this.yearEnd, "Ending year of the analysis", "2020");
        PrimitiveTypesList speciesSelected = new PrimitiveTypesList(String.class.getName(), PrimitiveTypes.STRING, "Selected species", "List of the species to analyze", false);
        this.inputs.add(speciesSelected);
        this.addRemoteDatabaseInput("TrendyLyzerObis", urlParameterName, userParameterName, passwordParameterName, "driver", "dialect");
    }

    public void shutdown() {
    }
}

