/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.matrixmodel;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.utils.CSquareCodesConverter;
import org.gcube.dataanalysis.geo.utils.VectorOperations;
import org.hibernate.SessionFactory;

public class RasterTable {
    private double[][] valuesMatrix;
    double x1;
    double x2;
    double y1;
    double y2;
    double z;
    double time;
    double xResolution;
    double yResolution;
    List<Tuple<Double>> coordinates;
    private AlgorithmConfiguration configuration;
    private String tablename = "rstr" + ("" + UUID.randomUUID()).replace("-", "");
    static String createTableStatement = "CREATE TABLE %1$s (id serial, csquarecode character varying, x real, y real, z real, t real, fvalue real)";
    static String columnsnames = "csquarecode, x , y , z , t, fvalue";
    public static String csquareColumn = "csquarecode";
    public static String valuesColumn = "fvalue";
    public static String idColumn = "id";

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public List<Tuple<Double>> getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(List<Tuple<Double>> coordinates) {
        this.coordinates = coordinates;
    }

    public RasterTable(double x1, double x2, double y1, double y2, double z, double xResolution, double yResolution, double[][] values, AlgorithmConfiguration configuration) {
        this.init(x1, x2, y1, y2, z, 0.0, xResolution, yResolution, values, configuration);
    }

    public RasterTable(double x1, double x2, double y1, double y2, double z, double time, double xResolution, double yResolution, double[][] values, AlgorithmConfiguration configuration) {
        this.init(x1, x2, y1, y2, z, time, xResolution, yResolution, values, configuration);
    }

    public void init(double x1, double x2, double y1, double y2, double z, double time, double xResolution, double yResolution, double[][] values, AlgorithmConfiguration configuration) {
        this.valuesMatrix = values;
        this.configuration = configuration;
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.z = z;
        this.time = time;
        this.xResolution = xResolution;
        this.yResolution = yResolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpGeoTable() {
        SessionFactory dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.configuration);
        try {
            AnalysisLogger.getLogger().debug((Object)"Database Initialized");
            DatabaseFactory.executeSQLUpdate((String)String.format(createTableStatement, this.tablename), (SessionFactory)dbconnection);
            AnalysisLogger.getLogger().debug((Object)("Table " + this.tablename + " created"));
            if (this.coordinates == null) {
                this.coordinates = VectorOperations.generateCoordinateTripletsInBoundingBox(this.x1, this.x2, this.y1, this.y2, this.z, this.xResolution, this.yResolution);
            }
            int triplets = this.coordinates.size();
            AnalysisLogger.getLogger().debug((Object)("Generated " + triplets + " coordinates triples"));
            List<Double> values = RasterTable.associateValueToCoordinates(this.coordinates, this.valuesMatrix);
            AnalysisLogger.getLogger().debug((Object)"Association to values completed - fulfilling buffer");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < triplets; ++i) {
                Tuple<Double> cset = this.coordinates.get(i);
                double x = (Double)cset.getElements().get(0);
                double y = (Double)cset.getElements().get(1);
                String csquare = CSquareCodesConverter.convertAtResolution(y, x, this.xResolution);
                Double value = values.get(i);
                if (value.isNaN()) {
                    value = 0.0;
                }
                double zVal = this.z;
                if (cset.getElements().size() > 2) {
                    zVal = (Double)cset.getElements().get(2);
                }
                String tVal = "" + this.time;
                if (cset.getElements().size() > 3) {
                    tVal = "" + cset.getElements().get(3);
                    if (Double.isNaN((Double)cset.getElements().get(3)) || Double.isInfinite((Double)cset.getElements().get(3))) {
                        tVal = "NULL";
                    }
                }
                sb.append("('" + csquare + "'," + x + "," + y + "," + zVal + "," + tVal + ",'" + value + "')");
                if (i % 5000 == 0) {
                    String insertStatement = DatabaseUtils.insertFromBuffer((String)this.tablename, (String)columnsnames, (StringBuffer)sb);
                    DatabaseFactory.executeSQLUpdate((String)insertStatement, (SessionFactory)dbconnection);
                    sb = new StringBuffer();
                    continue;
                }
                if (i >= triplets - 1) continue;
                sb.append(",");
            }
            AnalysisLogger.getLogger().debug((Object)("Inserting Final Buffer of " + sb.length() + " Values"));
            if (sb.length() > 0) {
                String insertStatement = DatabaseUtils.insertFromBuffer((String)this.tablename, (String)columnsnames, (StringBuffer)sb);
                DatabaseFactory.executeSQLUpdate((String)insertStatement, (SessionFactory)dbconnection);
                AnalysisLogger.getLogger().debug((Object)"Insertion completed with Success!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("Error in dumping table: " + e.getLocalizedMessage()));
        }
        finally {
            DatabaseUtils.closeDBConnection((SessionFactory)dbconnection);
            AnalysisLogger.getLogger().debug((Object)"Raster Geo Table DB closed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTable() {
        SessionFactory dbconnection = null;
        try {
            dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.configuration);
            DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.tablename), (SessionFactory)dbconnection);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("Impossible to delete table " + this.tablename + " : " + e.getLocalizedMessage()));
        }
        finally {
            DatabaseUtils.closeDBConnection((SessionFactory)dbconnection);
        }
    }

    public static List<Double> associateValueToCoordinates(List<Tuple<Double>> coordinates, double[][] data) {
        ArrayList<Double> values = new ArrayList<Double>();
        int k = 0;
        int g = 0;
        int ntriplets = coordinates.size();
        int xsteps = data[0].length - 1;
        for (int t = 0; t < ntriplets; ++t) {
            values.add(data[k][g]);
            if (g == xsteps) {
                g = 0;
                ++k;
                continue;
            }
            ++g;
        }
        return values;
    }
}

