/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.connectors.table;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.connectors.table.TableMatrixRepresentation;
import org.gcube.dataanalysis.geo.interfaces.GISDataConnector;
import org.gcube.dataanalysis.geo.utils.VectorOperations;

public class Table
implements GISDataConnector {
    AlgorithmConfiguration config;
    TableMatrixRepresentation tmr;
    double defaultresolution;

    public Table(AlgorithmConfiguration config, double resolution) throws Exception {
        this.config = config;
        this.tmr = new TableMatrixRepresentation();
        this.tmr.build5DTuples(config, true);
        this.defaultresolution = resolution;
    }

    @Override
    public List<Double> getFeaturesInTimeInstantAndArea(String layerURL, String layerName, int time, List<Tuple<Double>> coordinates3d, double BBxL, double BBxR, double BByL, double BByR) throws Exception {
        ArrayList<Double> values = new ArrayList<Double>();
        values.add(Math.random());
        List<Tuple<Double>> tuples = this.tmr.currentcoordinates5d.get(time);
        double resolution = this.defaultresolution;
        if (coordinates3d.size() > 1) {
            resolution = Math.abs((Double)coordinates3d.get(0).getElements().get(0) - (Double)coordinates3d.get(1).getElements().get(0));
        }
        double tolerance = Math.sqrt(2.0) * resolution / 2.0;
        if (tuples.size() == 0) {
            AnalysisLogger.getLogger().debug((Object)("Error in getting elements for time " + time));
            throw new Exception("Error in getting elements for time " + time);
        }
        AnalysisLogger.getLogger().debug((Object)("Getting elements for time " + time));
        boolean outsideZ = true;
        for (Tuple<Double> coordinates : coordinates3d) {
            double Zcoord = 0.0;
            if (coordinates.getElements().size() > 2) {
                Zcoord = (Double)coordinates.getElements().get(2);
            }
            if (!(Zcoord <= this.tmr.maxZ) || !(Zcoord >= this.tmr.minZ)) continue;
            outsideZ = false;
            break;
        }
        if (outsideZ) {
            AnalysisLogger.getLogger().debug((Object)"Error in getting elements for Z ");
            throw new Exception("Outside the z boundaries [" + this.tmr.minZ + ";" + this.tmr.maxZ + "]");
        }
        List<Double> v = VectorOperations.assignPointsValuesToGrid(coordinates3d, time, tuples, tolerance);
        return v;
    }

    @Override
    public double getMinZ(String layerURL, String layerName) {
        return this.tmr.minZ;
    }

    @Override
    public double getMaxZ(String layerURL, String layerName) {
        return this.tmr.maxZ;
    }
}

