/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.connectors.geotiff;

import java.io.File;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.data.transfer.common.TransferUtil;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.connectors.asc.ASC;
import org.gcube.dataanalysis.geo.interfaces.GISDataConnector;
import org.gcube.dataanalysis.geo.utils.GdalConverter;

public class GeoTiff
implements GISDataConnector {
    public double zScale = 0.0;
    public String persistenceDir;
    public String geoTiffUrl;

    public GeoTiff(AlgorithmConfiguration config, String geoTiffURL) throws Exception {
        this.persistenceDir = config.getPersistencePath();
    }

    @Override
    public List<Double> getFeaturesInTimeInstantAndArea(String layerURL, String layerName, int time, List<Tuple<Double>> coordinates3d, double BBxL, double BBxR, double BByL, double BByR) throws Exception {
        List<Double> list;
        String ascFile;
        block8: {
            if (time > 0) {
                throw new Exception("Time is currently not supported in WCS");
            }
            String uuid = null;
            ascFile = null;
            try {
                int urlCheck = HttpRequest.checkUrl((String)layerURL, null, null);
                AnalysisLogger.getLogger().debug((Object)("Checking url: " + urlCheck));
                String randomFile = new File(this.persistenceDir, "geotiff" + UUID.randomUUID().toString().replace("-", "")).getAbsolutePath();
                uuid = String.valueOf(randomFile) + ".tiff";
                TransferUtil downloadutil = new TransferUtil();
                downloadutil.setConnectiontimeout(120000);
                downloadutil.setTransferTimeout(120000);
                downloadutil.performTransfer(new URI(layerURL), uuid);
                AnalysisLogger.getLogger().debug((Object)("Converting to ASCII file: " + uuid));
                ascFile = GdalConverter.convertToASC(uuid);
                AnalysisLogger.getLogger().debug((Object)("Conversion to ASCII complete: " + ascFile));
                ASC asc = new ASC();
                List<Double> points = asc.getFeaturesInTimeInstantAndArea(ascFile, layerName, time, coordinates3d, BBxL, BBxR, BByL, BByR);
                AnalysisLogger.getLogger().debug((Object)("Retrieved: " + points.size() + " points"));
                list = points;
                if (uuid == null) break block8;
            }
            catch (Exception e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    if (uuid != null) {
                        AnalysisLogger.getLogger().debug((Object)("Deleting tiff:" + new File(uuid).delete()));
                        AnalysisLogger.getLogger().debug((Object)("Deleting tiff aux file:" + new File(uuid.replace(".tiff", ".prj")).delete()));
                    }
                    if (ascFile != null) {
                        AnalysisLogger.getLogger().debug((Object)("Deleting asc:" + new File(ascFile).delete()));
                        AnalysisLogger.getLogger().debug((Object)("Deleting asc aux file:" + new File(String.valueOf(ascFile) + ".aux.xml").delete()));
                    }
                    throw throwable;
                }
            }
            AnalysisLogger.getLogger().debug((Object)("Deleting tiff:" + new File(uuid).delete()));
            AnalysisLogger.getLogger().debug((Object)("Deleting tiff aux file:" + new File(uuid.replace(".tiff", ".prj")).delete()));
        }
        if (ascFile != null) {
            AnalysisLogger.getLogger().debug((Object)("Deleting asc:" + new File(ascFile).delete()));
            AnalysisLogger.getLogger().debug((Object)("Deleting asc aux file:" + new File(String.valueOf(ascFile) + ".aux.xml").delete()));
        }
        return list;
    }

    @Override
    public double getMinZ(String layerURL, String layerName) {
        return 0.0;
    }

    @Override
    public double getMaxZ(String layerURL, String layerName) {
        return 0.0;
    }
}

