/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.connectors.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.utils.VectorOperations;
import org.hibernate.SessionFactory;

public class TableMatrixRepresentation {
    public static String xDimensionColumnParameter = "xColumn";
    public static String yDimensionColumnParameter = "yColumn";
    public static String zDimensionColumnParameter = "zColumn";
    public static String timeDimensionColumnParameter = "timeColumn";
    public static String valueDimensionColumnParameter = "valueColumn";
    public static String tableNameParameter = "geoReferencedTableName";
    public static String filterParameter = "filter";
    public HashMap<String, Integer> currentTimes = null;
    public HashMap<Double, List<Tuple<Double>>> currentcoordinates5d = null;
    public double maxZ = 0.0;
    public double minZ = 0.0;

    public void build5DTuples(AlgorithmConfiguration configuration, boolean cacheElements) throws Exception {
        this.currentTimes = new HashMap();
        SessionFactory dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)configuration);
        try {
            try {
                String xField = configuration.getParam(xDimensionColumnParameter);
                String yField = configuration.getParam(yDimensionColumnParameter);
                String zField = configuration.getParam(zDimensionColumnParameter);
                String tField = configuration.getParam(timeDimensionColumnParameter);
                String valueField = configuration.getParam(valueDimensionColumnParameter);
                String tableName = configuration.getParam(tableNameParameter);
                if (tableName == null) {
                    throw new Exception("TableMatrixRepresentation: Error in retrieving elements from table, table name is null");
                }
                String dbtuple = "";
                dbtuple = xField != null && xField.trim().length() > 0 ? String.valueOf(dbtuple) + "\"" + xField + "\" as x," : String.valueOf(dbtuple) + "0 as x,";
                dbtuple = yField != null && yField.trim().length() > 0 ? String.valueOf(dbtuple) + "\"" + yField + "\" as y," : String.valueOf(dbtuple) + "0 as y,";
                dbtuple = zField != null && zField.trim().length() > 0 ? String.valueOf(dbtuple) + "\"" + zField + "\" as z," : String.valueOf(dbtuple) + "0 as z,";
                dbtuple = tField != null && tField.trim().length() > 0 ? String.valueOf(dbtuple) + "\"" + tField + "\" as time," : String.valueOf(dbtuple) + "0 as time,";
                dbtuple = valueField != null && valueField.trim().length() > 0 ? String.valueOf(dbtuple) + "\"" + valueField + "\" as v" : String.valueOf(dbtuple) + "0 as v";
                List rows = null;
                if (this.currentcoordinates5d == null || !cacheElements) {
                    this.currentcoordinates5d = new HashMap();
                    if (zField != null && zField.trim().length() > 0) {
                        String maxzq = "select max(" + zField + ") as max,min(" + zField + ") as min from " + tableName;
                        Object[] maxzr = (Object[])DatabaseFactory.executeSQLQuery((String)maxzq, (SessionFactory)dbconnection).get(0);
                        this.maxZ = Double.parseDouble("" + maxzr[0]);
                        this.minZ = Double.parseDouble("" + maxzr[1]);
                    }
                    String query = "select " + dbtuple + " from " + tableName;
                    String filter = configuration.getParam(filterParameter);
                    if (filter != null && filter.trim().length() > 0) {
                        query = String.valueOf(query) + " where " + filter;
                    }
                    query = String.valueOf(query) + " order by time";
                    AnalysisLogger.getLogger().debug((Object)("TableMatrixRepresentation-> Query to execute: " + query));
                    rows = DatabaseFactory.executeSQLQuery((String)query, (SessionFactory)dbconnection);
                    AnalysisLogger.getLogger().debug((Object)("TableMatrixRepresentation-> Returned " + rows.size() + " rows"));
                    for (Object row : rows) {
                        Object[] orow = (Object[])row;
                        Tuple<Double> t = this.build5DTuple(orow);
                        double time = (Double)t.getElements().get(3);
                        List<Tuple<Double>> coordinates5d = this.currentcoordinates5d.get(time);
                        if (coordinates5d == null) {
                            coordinates5d = new ArrayList<Tuple<Double>>();
                            this.currentcoordinates5d.put(time, coordinates5d);
                        }
                        coordinates5d.add(t);
                    }
                    AnalysisLogger.getLogger().debug((Object)"TableMatrixRepresentation-> Association complete");
                    AnalysisLogger.getLogger().debug((Object)("TableMatrixRepresentation-> coordinates set complete: " + this.currentcoordinates5d.size()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().debug((Object)("Error in getting elements from DB: " + e.getLocalizedMessage()));
                throw e;
            }
        }
        finally {
            if (dbconnection != null) {
                dbconnection.close();
            }
        }
    }

    private Tuple<Double> build5DTuple(Object[] row) {
        double x = Double.parseDouble("" + row[0]);
        double y = Double.parseDouble("" + row[1]);
        double z = Double.parseDouble("" + row[2]);
        double value = Double.parseDouble("" + row[4]);
        String time = "" + row[3];
        Integer yetTime = this.currentTimes.get(time);
        if (yetTime == null) {
            int size = this.currentTimes.size();
            this.currentTimes.put(time, size);
            yetTime = size;
        }
        return new Tuple((Object[])new Double[]{x, y, z, (double)yetTime, value});
    }

    public static void main(String[] args) throws Exception {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setParam("DatabaseUserName", "utente");
        config.setParam("DatabasePassword", "d4science");
        config.setParam("DatabaseURL", "jdbc:postgresql://statistical-manager.d.d4science.research-infrastructures.eu/testdb");
        config.setParam("DatabaseDriver", "org.postgresql.Driver");
        config.setParam(tableNameParameter, "generic_id037d302d_2ba0_4e43_b6e4_1a797bb91728");
        config.setParam(timeDimensionColumnParameter, "datetime");
        config.setParam(valueDimensionColumnParameter, "speed");
        config.setParam(filterParameter, "speed<2");
        AnalysisLogger.setLogger((String)(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile));
        TableMatrixRepresentation tmr = new TableMatrixRepresentation();
        tmr.build5DTuples(config, false);
        List<Tuple<Double>> tuples = tmr.currentcoordinates5d.get(0.0);
        AnalysisLogger.getLogger().debug((Object)("TUPLES:" + tuples));
        List<Tuple<Double>> grid = VectorOperations.generateCoordinateTripletsInBoundingBox(-47.14, -46.0, 44.52, 45.55, 0.0, 0.5, 0.5);
        List<Double> values = VectorOperations.assignPointsValuesToGrid(grid, 0, tuples, 0.5);
        AnalysisLogger.getLogger().debug((Object)("VALUES:" + values));
    }
}

