/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.algorithms;

import java.util.ArrayList;
import java.util.List;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.geo.algorithms.MapsCreator;

public class PointsMapsCreator
extends MapsCreator {
    @Override
    public String getDescription() {
        return "A transducer algorithm to produce a GIS map of points from a set of points with x,y coordinates indications. A maximum of " + maxNPoints + " is allowed";
    }

    @Override
    public void init() throws Exception {
        this.log("MAPS_CREATOR");
        this.datastore = "timeseriesws";
        this.defaultStyle = "point";
        this.workspace = "aquamaps";
        this.username = "statistical.manager";
        this.purpose = "To Publish Geometric Layers for Points Maps";
        this.credits = "Generated via the Statistical Manager Service";
        this.keyword = "Points Map";
    }

    @Override
    protected void setInputParameters() {
        try {
            ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
            this.addRemoteDatabaseInput(databaseParameterName, dburlParameterName, dbuserParameterName, dbpasswordParameterName, "driver", "dialect");
            templates.add(TableTemplates.GENERIC);
            this.addStringInput(layerNameParameter, "The name of the layer to produce", "Points Map");
            InputTable tinput = new InputTable(templates, inputTableParameter, "The table information to geo-spatialize");
            ColumnType xColumn = new ColumnType(inputTableParameter, xParameter, "The column containing longitude information", "", false);
            ColumnType yColumn = new ColumnType(inputTableParameter, yParameter, "The column containing latitude information", "", false);
            ColumnType customDimension = new ColumnType(inputTableParameter, infoParameter, "The column containing information you want to attach to each point", "", false);
            this.inputs.add(tinput);
            this.inputs.add(xColumn);
            this.inputs.add(yColumn);
            this.inputs.add(customDimension);
            DatabaseType.addDefaultDBPars((List)this.inputs);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./cfg/");
        config.setGcubeScope("/gcube/devsec");
        config.setParam("DatabaseUserName", "utente");
        config.setParam("DatabasePassword", "d4science");
        config.setParam("DatabaseURL", "jdbc:postgresql://statistical-manager.d.d4science.research-infrastructures.eu/testdb");
        config.setParam(dburlParameterName, "jdbc:postgresql://geoserver-test.d4science-ii.research-infrastructures.eu/timeseriesgisdb");
        config.setParam(dbuserParameterName, "postgres");
        config.setParam(dbpasswordParameterName, "d4science2");
        config.setParam(inputTableParameter, "occurrence_species_id_fb60ce42_1704_43f9_91a3_2df7d82b1b96");
        config.setParam(xParameter, "decimallongitude");
        config.setParam(yParameter, "decimallatitude");
        config.setParam(infoParameter, "scientificname");
        config.setParam("ServiceUserName", "gianpaolo.coro");
        config.setParam(layerNameParameter, "Generic Species");
        PointsMapsCreator maps = new PointsMapsCreator();
        maps.setConfiguration(config);
        ((MapsCreator)maps).init();
        maps.compute();
    }
}

