/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.test.projections;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.geo.connectors.wfs.FeaturedPolygon;
import org.gcube.dataanalysis.geo.connectors.wfs.WFSDataExplorer;

public class ProduceCentroids {
    static String layer = "http://geoserver-dev.d4science-ii.research-infrastructures.eu/geoserver/ows?service=wfs&version=1.0.0&request=GetFeature&srsName=urn:x-ogc:def:crs:EPSG:4326&TYPENAME=aquamaps:worldborders";
    static String layername = "aquamaps:worldborders";

    public static void main(String[] args) throws Exception {
        List<Object> featuresInTime = new ArrayList();
        AnalysisLogger.getLogger().debug((Object)("taking WFS features from layer: " + layer));
        featuresInTime = WFSDataExplorer.getFeatures(layer, layername, -180.0, -90.0, 180.0, 90.0);
        HashMap centroidsmap = new HashMap();
        HashMap<String, Geometry> polymap = new HashMap<String, Geometry>();
        for (FeaturedPolygon featuredPolygon : featuresInTime) {
            Geometry prevPoly = (Geometry)polymap.get(featuredPolygon.features.get("cntry_name"));
            prevPoly = prevPoly != null ? prevPoly.union(featuredPolygon.p) : featuredPolygon.p;
            polymap.put(featuredPolygon.features.get("cntry_name"), prevPoly);
        }
        for (String string : polymap.keySet()) {
            Point centroid = ((Geometry)polymap.get(string)).getCentroid();
            System.out.println(centroid.getX() + "," + centroid.getY() + "," + string);
        }
    }
}

