/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import scala.actors.threadpool.Arrays;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.ma2.IndexIterator;

public class VectorOperations {
    public static ArrayDouble.D2 arrayByte2DArrayDouble(ArrayByte bytes) {
        int[] shapeD = bytes.getShape();
        int yD = shapeD[0];
        int xD = shapeD[1];
        AnalysisLogger.getLogger().debug((Object)(xD + "X" + yD + "=" + xD * yD));
        ArrayDouble.D2 doublea = new ArrayDouble.D2(yD, xD);
        IndexIterator iterator = bytes.getIndexIterator();
        for (int x = 0; x < xD; ++x) {
            for (int y = 0; y < yD; ++y) {
                Byte bytex = (Byte)iterator.next();
                doublea.set(y, x, bytex.doubleValue());
            }
        }
        return doublea;
    }

    public static ArrayDouble.D3 arrayByte3DArrayDouble(ArrayByte bytes) {
        int[] shapeD = bytes.getShape();
        int zD = shapeD[0];
        int yD = shapeD[1];
        int xD = shapeD[2];
        AnalysisLogger.getLogger().debug((Object)(xD + "X" + yD + "X" + zD + "=" + xD * yD * zD));
        ArrayDouble.D3 doublea = new ArrayDouble.D3(zD, yD, xD);
        IndexIterator iterator = bytes.getIndexIterator();
        for (int x = 0; x < xD; ++x) {
            for (int y = 0; y < yD; ++y) {
                for (int z = 0; z < zD; ++z) {
                    Byte bytex = (Byte)iterator.next();
                    doublea.set(z, y, x, bytex.doubleValue());
                }
            }
        }
        return doublea;
    }

    public static List<Double> assignPointsValuesToGrid(List<Tuple<Double>> grid3d, int gridTimeInstant, List<Tuple<Double>> coordinates5d, double tolerance) {
        int gridSize = grid3d.size();
        Object[] valuesForGridd = new Double[gridSize];
        for (int i = 0; i < gridSize; ++i) {
            valuesForGridd[i] = Double.NaN;
        }
        int foundmatches = 0;
        long count = 0L;
        AnalysisLogger.getLogger().debug((Object)("Assigning : " + coordinates5d.size() + " elements"));
        for (Tuple<Double> coord5d : coordinates5d) {
            double rx = (Double)coord5d.getElements().get(0);
            double ry = (Double)coord5d.getElements().get(1);
            double rz = (Double)coord5d.getElements().get(2);
            double rt = (Double)coord5d.getElements().get(3);
            double rvalue = (Double)coord5d.getElements().get(4);
            int gridIdx = 0;
            for (Tuple<Double> coord3d : grid3d) {
                double z;
                double y;
                double x = (Double)coord3d.getElements().get(0);
                double d = VectorOperations.distance(x, y = ((Double)coord3d.getElements().get(1)).doubleValue(), z = ((Double)coord3d.getElements().get(2)).doubleValue(), gridTimeInstant, rx, ry, rz, rt);
                if (d <= tolerance) {
                    valuesForGridd[gridIdx] = rvalue;
                    ++foundmatches;
                }
                ++gridIdx;
            }
            if (++count % 50000L != 0L) continue;
            AnalysisLogger.getLogger().debug((Object)("Vector Operations Assigned: " + count + " elements"));
        }
        AnalysisLogger.getLogger().debug((Object)("Association: Found " + foundmatches + " matches between the grid of points and the coordinates"));
        List valuesForGrid = Arrays.asList((Object[])valuesForGridd);
        return valuesForGrid;
    }

    public static List<Double> assignGridValuesToPoints2D(List<Tuple<Double>> grid3d, List<Double> gridValues, List<Tuple<Double>> coordinates4d, double tolerance) {
        int gridSize = coordinates4d.size();
        Object[] valuesForPoints = new Double[gridSize];
        for (int i = 0; i < gridSize; ++i) {
            valuesForPoints[i] = Double.NaN;
        }
        int foundmatches = 0;
        int points = 0;
        for (Tuple<Double> coord4d : coordinates4d) {
            double rx = (Double)coord4d.getElements().get(0);
            double ry = (Double)coord4d.getElements().get(1);
            int gridIdx = 0;
            for (Tuple<Double> gridElement : grid3d) {
                double y;
                double x = (Double)gridElement.getElements().get(0);
                double d = VectorOperations.distance(x, y = ((Double)gridElement.getElements().get(1)).doubleValue(), 0.0, 0.0, rx, ry, 0.0, 0.0);
                if (d <= tolerance) {
                    valuesForPoints[points] = gridValues.get(gridIdx);
                    ++foundmatches;
                    break;
                }
                ++gridIdx;
            }
            ++points;
        }
        AnalysisLogger.getLogger().debug((Object)("Association: Found " + foundmatches + " matches between the points and the grid"));
        return Arrays.asList((Object[])valuesForPoints);
    }

    public static List<Double> assignGridValuesToPoints(List<Tuple<Double>> grid3d, int gridTimeInstant, List<Double> gridValues, List<Tuple<Double>> coordinates4d, double tolerance) {
        ArrayList<Double> valuesForPoints = new ArrayList<Double>();
        int gridSize = coordinates4d.size();
        for (int i = 0; i < gridSize; ++i) {
            valuesForPoints.add(Double.NaN);
        }
        int foundmatches = 0;
        int points = 0;
        for (Tuple<Double> coord4d : coordinates4d) {
            double rx = (Double)coord4d.getElements().get(0);
            double ry = (Double)coord4d.getElements().get(1);
            double rz = (Double)coord4d.getElements().get(2);
            double rt = (Double)coord4d.getElements().get(3);
            int gridIdx = 0;
            for (Tuple<Double> gridElement : grid3d) {
                double z;
                double y;
                double x = (Double)gridElement.getElements().get(0);
                double d = VectorOperations.distance(x, y = ((Double)gridElement.getElements().get(1)).doubleValue(), z = ((Double)gridElement.getElements().get(2)).doubleValue(), gridTimeInstant, rx, ry, rz, rt);
                if (d <= tolerance) {
                    valuesForPoints.set(points, gridValues.get(gridIdx));
                    ++foundmatches;
                    break;
                }
                ++gridIdx;
            }
            ++points;
        }
        AnalysisLogger.getLogger().debug((Object)("Association: Found " + foundmatches + " matches between the points and the grid"));
        return valuesForPoints;
    }

    public static double distance(double x1, double y1, double z1, double t1, double x2, double y2, double z2, double t2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2) + (t1 - t2) * (t1 - t2));
    }

    public static List<Tuple<Double>> generateCoordinateTripletsInBoundingBox_old(double x1, double x2, double y1, double y2, double z, double xResolution, double yResolution) {
        int ysteps = (int)((y2 - y1) / yResolution);
        int xsteps = (int)((x2 - x1) / xResolution);
        ArrayList<Tuple<Double>> tuples = new ArrayList<Tuple<Double>>();
        AnalysisLogger.getLogger().debug((Object)("Building the points grid according to YRes:" + yResolution + " and XRes:" + xResolution));
        for (int i = 0; i < ysteps + 1; ++i) {
            double y = (double)i * yResolution + y1;
            if (i == ysteps) {
                y = y2;
            }
            for (int j = 0; j < xsteps + 1; ++j) {
                double x = (double)j * xResolution + x1;
                if (j == xsteps) {
                    x = x2;
                }
                tuples.add((Tuple<Double>)new Tuple((Object[])new Double[]{x, y, z}));
            }
        }
        return tuples;
    }

    public static List<Tuple<Double>> generateCoordinateTripletsInBoundingBox(double x1, double x2, double y1, double y2, double z, double xResolution, double yResolution) {
        ArrayList<Tuple<Double>> tuples = new ArrayList<Tuple<Double>>();
        for (double y = y1; y <= y2; y += yResolution) {
            for (double x = x1; x <= x2; x += xResolution) {
                tuples.add((Tuple<Double>)new Tuple((Object[])new Double[]{x, y, z}));
            }
        }
        return tuples;
    }

    public static double[][] vectorToMatix(List<Double> values, double x1, double x2, double y1, double y2, double xResolution, double yResolution) {
        int ntriplets = values.size();
        int ysteps = 0;
        for (double y = y1; y <= y2; y += yResolution) {
            ++ysteps;
        }
        int xsteps = 0;
        for (double x = x1; x <= x2; x += xResolution) {
            ++xsteps;
        }
        double[][] slice = new double[ysteps][xsteps];
        int k = 0;
        int g = 0;
        for (int t = 0; t < ntriplets; ++t) {
            Double value = values.get(t);
            slice[k][g] = value;
            if (g == xsteps - 1) {
                g = 0;
                ++k;
                continue;
            }
            ++g;
        }
        return slice;
    }

    public void applyNearestNeighbor() {
    }
}

