/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.matrixmodel;

import java.io.File;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.geo.connectors.asc.AscRaster;
import org.gcube.dataanalysis.geo.connectors.asc.AscRasterWriter;
import org.gcube.dataanalysis.geo.matrixmodel.XYExtractor;

public class ASCConverter {
    XYExtractor extractor;
    AlgorithmConfiguration config;

    public ASCConverter(AlgorithmConfiguration config) {
        this.extractor = new XYExtractor(config);
        this.config = config;
    }

    public String convertToASC(String layerTitle, String layerName, int timeInstant, double z, double xResolution, double yResolution) throws Exception {
        return this.convertToASC(layerTitle, layerName, timeInstant, -180.0, 180.0, -90.0, 90.0, z, xResolution, yResolution);
    }

    public String convertToASC(String outFilePath, double[][] values, double x1, double y1, double xResolution, double yResolution) throws Exception {
        try {
            AscRaster raster = null;
            raster = xResolution == yResolution ? new AscRaster(values, xResolution, -1.0, -1.0, x1, y1) : new AscRaster(values, -1.0, xResolution, yResolution, x1, y1);
            String outputFile = new File(outFilePath).getAbsolutePath();
            AscRasterWriter writer = new AscRasterWriter();
            writer.writeRasterInvertYAxis(outputFile, raster);
            return outputFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("Error in converting to ASC : " + e.getLocalizedMessage()));
            AnalysisLogger.getLogger().debug((Object)e);
            throw e;
        }
    }

    public String convertToASC(String layerTitle, String outFilePath, int timeInstant, double x1, double x2, double y1, double y2, double z, double xResolution, double yResolution) throws Exception {
        double[][] values = this.extractor.extractXYGrid(layerTitle, timeInstant, x1, x2, y1, y2, z, xResolution, yResolution);
        return this.convertToASC(outFilePath, values, x1, y1, xResolution, yResolution);
    }

    public static void main(String[] args) throws Exception {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setAgent("XYEXTRACTOR");
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setGcubeScope("/gcube/devsec/devVRE");
        String layername = "dfd1bad2-ab00-42ac-8bb2-46a17162f509";
        float z = 0.0f;
        int time = 0;
        float xres = 1.0f;
        float yres = 1.0f;
        float xll = -11.080947f;
        float yll = 31.695501f;
        float xur = 23.15245f;
        float yur = 51.265385f;
        AnalysisLogger.setLogger((String)(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile));
        ASCConverter converter = new ASCConverter(config);
        String converted = converter.convertToASC(layername, "./test.asc", time, xll, xur, yll, yur, z, xres, yres);
        AnalysisLogger.getLogger().debug((Object)("ASC : " + converted));
    }
}

