/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.algorithms;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;
import org.gcube.dataanalysis.geo.algorithms.XYExtraction;
import org.gcube.dataanalysis.geo.connectors.asc.AscRaster;
import org.gcube.dataanalysis.geo.connectors.asc.AscRasterWriter;
import org.gcube.dataanalysis.geo.matrixmodel.XYExtractor;

public class ESRIGRIDExtraction
extends XYExtraction {
    private File outputfile;
    protected ResourceFactory resourceManager;

    @Override
    public List<StatisticalType> getInputParameters() {
        IOHelper.addStringInput((List)this.inputs, (String)layerName, (String)"Layer Title or UUID or HTTP link. E.g. the title or the UUID (preferred) of a layer indexed in the e-Infrastructure on GeoNetwork - You can retrieve it from GeoExplorer. Otherwise you can supply the direct HTTP link of the layer. The format will be guessed from the link. The default is GeoTiff. Supports several standards (NETCDF, WFS, WCS ASC, GeoTiff )", (String)"");
        IOHelper.addDoubleInput((List)this.inputs, (String)yLL, (String)"Lower Left Latitute of the Bounding Box", (String)"-60");
        IOHelper.addDoubleInput((List)this.inputs, (String)xLL, (String)"Lower Left Longitude of the Bounding Box", (String)"-50");
        IOHelper.addDoubleInput((List)this.inputs, (String)yUR, (String)"Upper Right Latitute of the Bounding Box", (String)"60");
        IOHelper.addDoubleInput((List)this.inputs, (String)xUR, (String)"Upper Right Longitude of the Bounding Box", (String)"50");
        IOHelper.addDoubleInput((List)this.inputs, (String)z, (String)"Value of Z. Default is 0, that means processing will be at surface level or at the first avaliable Z value in the layer", (String)"0");
        IOHelper.addIntegerInput((List)this.inputs, (String)t, (String)"Time Index. The default is the first time indexed dataset", (String)"0");
        IOHelper.addDoubleInput((List)this.inputs, (String)xRes, (String)"Projection resolution on the X axis", (String)"0.5");
        IOHelper.addDoubleInput((List)this.inputs, (String)yRes, (String)"Projection resolution on the Y axis", (String)"0.5");
        DatabaseType.addDefaultDBPars((List)this.inputs);
        return this.inputs;
    }

    @Override
    public String getDescription() {
        return "An algorithm to extract values associated to an environmental feature repository (e.g. NETCDF, ASC, GeoTiff files etc. ).  A grid of points at a certain resolution is specified by the user and values are associated to the points from the environmental repository. It accepts as one  geospatial repository ID (via their UUIDs in the infrastructure spatial data repository - recoverable through the Geoexplorer portlet) or a direct link to a file and the specification about time and space. The algorithm produces one ESRI GRID ASCII file containing the values associated to the selected bounding box.";
    }

    @Override
    public void compute() throws Exception {
        try {
            try {
                this.status = 10.0f;
                AnalysisLogger.setLogger((String)(String.valueOf(this.config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile));
                this.getParameters();
                AnalysisLogger.getLogger().debug((Object)"Extractor: MatrixExtractor initialized");
                long t0 = System.currentTimeMillis();
                XYExtractor extractor = new XYExtractor(this.config);
                this.zValue = extractor.correctZ(this.zValue, this.layerNameValue, this.xResValue);
                AnalysisLogger.getLogger().debug((Object)("XYExtraction->Best Z for this reference layer: " + this.zValue));
                this.outputParameters.put("Matching Z value in the layer", "" + this.zValue);
                this.outputParameters.put("Min Z value in the Layer", "" + extractor.zmin);
                this.outputParameters.put("Max Z value in the Layer", "" + extractor.zmax);
                double[][] matrix = extractor.extractXYGrid(this.layerNameValue, this.time, this.BBxLL, this.BBxUR, this.BByLL, this.BByUR, this.zValue, this.xResValue, this.yResValue);
                AnalysisLogger.getLogger().debug((Object)("ELAPSED TIME: " + (System.currentTimeMillis() - t0)));
                AnalysisLogger.getLogger().debug((Object)"Extractor: Matrix Extracted");
                AnalysisLogger.getLogger().debug((Object)"Extractor: ****Rasterizing grid into table****");
                this.status = 30.0f;
                this.outputfile = new File(this.config.getPersistencePath(), "asc_" + UUID.randomUUID() + ".asc");
                AnalysisLogger.getLogger().debug((Object)"Extractor: Building raster object");
                AscRaster raster = new AscRaster(matrix, this.xResValue, this.xResValue, this.yResValue, this.BBxLL, this.BByLL);
                AnalysisLogger.getLogger().debug((Object)("Extractor: Writing raster file " + this.outputfile.getAbsolutePath()));
                AscRasterWriter writer = new AscRasterWriter();
                writer.writeRaster(this.outputfile.getAbsolutePath(), raster);
                AnalysisLogger.getLogger().debug((Object)("Extractor: Map was dumped in file: " + this.outputfile));
                this.status = 80.0f;
                AnalysisLogger.getLogger().debug((Object)("Extractor: Elapsed: Whole operation completed in " + (double)(System.currentTimeMillis() - t0) / 1000.0 + "s"));
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().debug((Object)("Extractor: ERROR!: " + e.getLocalizedMessage()));
                throw e;
            }
        }
        finally {
            this.status = 100.0f;
        }
    }

    @Override
    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"Shutdown");
    }

    @Override
    public StatisticalType getOutput() {
        LinkedHashMap<String, PrimitiveType> map = new LinkedHashMap<String, PrimitiveType>();
        for (String key : this.outputParameters.keySet()) {
            String value = (String)this.outputParameters.get(key);
            PrimitiveType val = new PrimitiveType(String.class.getName(), (Object)value, PrimitiveTypes.STRING, key, key);
            map.put(key, val);
        }
        PrimitiveType file = new PrimitiveType(File.class.getName(), (Object)this.outputfile, PrimitiveTypes.FILE, "Output ESRI GRID ASCII FILE", "Output ESRI GRID ASCII FILE");
        map.put("OutputFile", file);
        PrimitiveType outputm = new PrimitiveType(HashMap.class.getName(), map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return outputm;
    }

    @Override
    public float getStatus() {
        return this.status;
    }

    @Override
    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    @Override
    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    @Override
    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(1);
    }

    @Override
    public String getResources() {
        return ResourceFactory.getResources((float[])new float[]{100.0f});
    }
}

