/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.batch;

import it.geosolutions.geonetwork.GNClient;
import it.geosolutions.geonetwork.util.GNInsertConfiguration;
import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.dataanalysis.geo.meta.GenericLayerMetadata;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkAdministration;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.gcube.spatial.data.geonetwork.model.Account;
import org.gcube.spatial.data.geonetwork.model.ScopeConfiguration;
import org.gcube.spatial.data.geonetwork.model.faults.MissingConfigurationException;
import org.gcube.spatial.data.geonetwork.utils.UserUtils;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.identification.Identification;

public class OpenLayerToVREs_Dev_ {
    static String geonetworkurl = "http://geoserver-dev2.d4science-ii.research-infrastructures.eu/geonetwork/";
    static String geonetworkUser = "admin";
    static String geonetworkPwd = "Geey6ohz";

    public static void main(String[] args) throws Exception {
        String targetScope = "/gcube/devsec";
        String title = "Oscar";
        OpenLayerToVREs_Dev_.changeScope2(title, targetScope, targetScope);
    }

    public static void changeScope2(String title, String startScope, String targetScope) throws Exception {
        ScopeProvider.instance.set(startScope);
        GeoNetworkAdministration reader = GeoNetwork.get();
        reader.login(LoginLevel.ADMIN);
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.any, title);
        req.addConfig(GNSearchRequest.Config.similarity, "1");
        GNSearchResponse resp = reader.query(req);
        Long id = 0L;
        Metadata meta = null;
        Iterator i$ = resp.iterator();
        if (i$.hasNext()) {
            GNSearchResponse.GNMetadata metadata = (GNSearchResponse.GNMetadata)i$.next();
            id = metadata.getId();
            System.out.println("ID " + id);
            System.out.println("Name " + metadata.getInfo().getName());
            meta = reader.getById(id.longValue());
            Identification idf = (Identification)meta.getIdentificationInfo().iterator().next();
            String otitle = idf.getCitation().getTitle().toString();
            System.out.println("Title " + otitle);
        }
        System.out.println("Publishing " + id);
        ScopeConfiguration targetConfiguration = null;
        targetScope = targetScope.substring(targetScope.lastIndexOf("/") + 1);
        System.out.println("target scope " + targetScope);
        for (ScopeConfiguration configuration : reader.getConfiguration().getExistingConfigurations()) {
            if (!configuration.getAssignedScope().equals(targetScope)) continue;
            targetConfiguration = configuration;
        }
        if (targetConfiguration == null) {
            throw new MissingConfigurationException("Scope " + targetScope + " has no configuration");
        }
        int targetUserId = UserUtils.getByName((Set)reader.getUsers(), (String)((Account)targetConfiguration.getAccounts().get(Account.Type.SCOPE)).getUser()).getId();
        int targetGroup = targetConfiguration.getDefaultGroup();
        System.out.println("ID " + id + " targetUserId " + targetUserId + " targetGroup " + targetGroup);
        List<Long> ids = Collections.singletonList(Long.valueOf(id));
        GNClient client = new GNClient(geonetworkurl);
        client.login(geonetworkUser, geonetworkPwd);
        System.out.println("deleting meta " + id);
        client.deleteMetadata(id.longValue());
        System.out.println("inserting meta");
        File tmetafile = GenericLayerMetadata.meta2File(meta);
        client.insertMetadata(new GNInsertConfiguration("" + targetGroup, "datasets", "_none_", Boolean.valueOf(true)), tmetafile);
        tmetafile.delete();
        System.out.println("All done");
    }

    public static void changeScope(String title, String startScope, String targetScope) throws Exception {
        ScopeProvider.instance.set(startScope);
        GeoNetworkAdministration reader = GeoNetwork.get();
        reader.login(LoginLevel.ADMIN);
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.any, title);
        req.addConfig(GNSearchRequest.Config.similarity, "1");
        GNSearchResponse resp = reader.query(req);
        Long id = 0L;
        Iterator i$ = resp.iterator();
        if (i$.hasNext()) {
            GNSearchResponse.GNMetadata metadata = (GNSearchResponse.GNMetadata)i$.next();
            id = metadata.getId();
            System.out.println("ID " + id);
            System.out.println("Name " + metadata.getInfo().getName());
            Metadata meta = reader.getById(id.longValue());
            Identification idf = (Identification)meta.getIdentificationInfo().iterator().next();
            String otitle = idf.getCitation().getTitle().toString();
            System.out.println("Title " + otitle);
        }
        System.out.println("Publishing " + id);
        ScopeConfiguration targetConfiguration = null;
        targetScope = "gCubeApps";
        for (ScopeConfiguration configuration : reader.getConfiguration().getExistingConfigurations()) {
            if (!configuration.getAssignedScope().equals(targetScope)) continue;
            targetConfiguration = configuration;
        }
        if (targetConfiguration == null) {
            throw new MissingConfigurationException("Scope " + targetScope + " has no configuration");
        }
        int targetUserId = UserUtils.getByName((Set)reader.getUsers(), (String)((Account)targetConfiguration.getAccounts().get(Account.Type.SCOPE)).getUser()).getId();
        int targetGroup = targetConfiguration.getDefaultGroup();
        System.out.println("ID " + id + " targetUserId " + targetUserId + " targetGroup " + targetGroup);
        List<Long> ids = Collections.singletonList(Long.valueOf(id));
        reader.assignOwnership(ids, Integer.valueOf(targetUserId), Integer.valueOf(targetGroup));
        System.out.println("Assigned " + id);
    }
}

