/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import scala.actors.threadpool.Arrays;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.ma2.IndexIterator;

public class VectorOperations {
    public static ArrayDouble.D2 arrayByte2DArrayDouble(ArrayByte bytes) {
        int[] shapeD = bytes.getShape();
        int yD = shapeD[0];
        int xD = shapeD[1];
        AnalysisLogger.getLogger().debug((Object)(String.valueOf(xD) + "X" + yD + "=" + xD * yD));
        ArrayDouble.D2 doublea = new ArrayDouble.D2(yD, xD);
        IndexIterator iterator = bytes.getIndexIterator();
        int x = 0;
        while (x < xD) {
            int y = 0;
            while (y < yD) {
                Byte bytex = (Byte)iterator.next();
                doublea.set(y, x, bytex.doubleValue());
                ++y;
            }
            ++x;
        }
        return doublea;
    }

    public static ArrayDouble.D3 arrayByte3DArrayDouble(ArrayByte bytes) {
        int[] shapeD = bytes.getShape();
        int zD = shapeD[0];
        int yD = shapeD[1];
        int xD = shapeD[2];
        AnalysisLogger.getLogger().debug((Object)(String.valueOf(xD) + "X" + yD + "X" + zD + "=" + xD * yD * zD));
        ArrayDouble.D3 doublea = new ArrayDouble.D3(zD, yD, xD);
        IndexIterator iterator = bytes.getIndexIterator();
        int x = 0;
        while (x < xD) {
            int y = 0;
            while (y < yD) {
                int z = 0;
                while (z < zD) {
                    Byte bytex = (Byte)iterator.next();
                    doublea.set(z, y, x, bytex.doubleValue());
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return doublea;
    }

    public static List<Double> assignPointsValuesToGrid(List<Tuple<Double>> grid3d, int gridTimeInstant, List<Tuple<Double>> coordinates5d, double tolerance) {
        int gridSize = grid3d.size();
        Object[] valuesForGridd = new Double[gridSize];
        int i = 0;
        while (i < gridSize) {
            valuesForGridd[i] = Double.NaN;
            ++i;
        }
        int foundmatches = 0;
        long count = 0L;
        AnalysisLogger.getLogger().debug((Object)("Assigning : " + coordinates5d.size() + " elements"));
        for (Tuple<Double> coord5d : coordinates5d) {
            double rx = (Double)coord5d.getElements().get(0);
            double ry = (Double)coord5d.getElements().get(1);
            double rz = (Double)coord5d.getElements().get(2);
            double rt = (Double)coord5d.getElements().get(3);
            double rvalue = (Double)coord5d.getElements().get(4);
            int gridIdx = 0;
            for (Tuple<Double> coord3d : grid3d) {
                double z;
                double y;
                double x = (Double)coord3d.getElements().get(0);
                double d = VectorOperations.distance(x, y = ((Double)coord3d.getElements().get(1)).doubleValue(), z = ((Double)coord3d.getElements().get(2)).doubleValue(), gridTimeInstant, rx, ry, rz, rt);
                if (d <= tolerance) {
                    valuesForGridd[gridIdx] = rvalue;
                    ++foundmatches;
                }
                ++gridIdx;
            }
            if (++count % 50000L != 0L) continue;
            AnalysisLogger.getLogger().debug((Object)("Vector Operations Assigned: " + count + " elements"));
        }
        AnalysisLogger.getLogger().debug((Object)("Association: Found " + foundmatches + " matches between the grid of points and the coordinates"));
        List valuesForGrid = Arrays.asList((Object[])valuesForGridd);
        return valuesForGrid;
    }

    public static List<Double> assignGridValuesToPoints2D(List<Tuple<Double>> grid3d, List<Double> gridValues, List<Tuple<Double>> coordinates4d, double tolerance) {
        int gridSize = coordinates4d.size();
        Object[] valuesForPoints = new Double[gridSize];
        int i = 0;
        while (i < gridSize) {
            valuesForPoints[i] = Double.NaN;
            ++i;
        }
        int foundmatches = 0;
        int points = 0;
        for (Tuple<Double> coord4d : coordinates4d) {
            double rx = (Double)coord4d.getElements().get(0);
            double ry = (Double)coord4d.getElements().get(1);
            int gridIdx = 0;
            for (Tuple<Double> gridElement : grid3d) {
                double y;
                double x = (Double)gridElement.getElements().get(0);
                double d = VectorOperations.distance(x, y = ((Double)gridElement.getElements().get(1)).doubleValue(), 0.0, 0.0, rx, ry, 0.0, 0.0);
                if (d <= tolerance) {
                    valuesForPoints[points] = gridValues.get(gridIdx);
                    ++foundmatches;
                    break;
                }
                ++gridIdx;
            }
            ++points;
        }
        AnalysisLogger.getLogger().debug((Object)("Association: Found " + foundmatches + " matches between the points and the grid"));
        return Arrays.asList((Object[])valuesForPoints);
    }

    public static List<Double> assignGridValuesToPoints(List<Tuple<Double>> grid3d, int gridTimeInstant, List<Double> gridValues, List<Tuple<Double>> coordinates4d, double tolerance) {
        ArrayList<Double> valuesForPoints = new ArrayList<Double>();
        int gridSize = coordinates4d.size();
        int i = 0;
        while (i < gridSize) {
            valuesForPoints.add(Double.NaN);
            ++i;
        }
        int foundmatches = 0;
        int points = 0;
        for (Tuple<Double> coord4d : coordinates4d) {
            double rx = (Double)coord4d.getElements().get(0);
            double ry = (Double)coord4d.getElements().get(1);
            double rz = (Double)coord4d.getElements().get(2);
            double rt = (Double)coord4d.getElements().get(3);
            int gridIdx = 0;
            for (Tuple<Double> gridElement : grid3d) {
                double z;
                double y;
                double x = (Double)gridElement.getElements().get(0);
                double d = VectorOperations.distance(x, y = ((Double)gridElement.getElements().get(1)).doubleValue(), z = ((Double)gridElement.getElements().get(2)).doubleValue(), gridTimeInstant, rx, ry, rz, rt);
                if (d <= tolerance) {
                    valuesForPoints.set(points, gridValues.get(gridIdx));
                    ++foundmatches;
                    break;
                }
                ++gridIdx;
            }
            ++points;
        }
        AnalysisLogger.getLogger().debug((Object)("Association: Found " + foundmatches + " matches between the points and the grid"));
        return valuesForPoints;
    }

    public static double distance(double x1, double y1, double z1, double t1, double x2, double y2, double z2, double t2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2) + (t1 - t2) * (t1 - t2));
    }

    public static List<Tuple<Double>> generateCoordinateTripletsInBoundingBox_old(double x1, double x2, double y1, double y2, double z, double xResolution, double yResolution) {
        int ysteps = (int)((y2 - y1) / yResolution);
        int xsteps = (int)((x2 - x1) / xResolution);
        ArrayList<Tuple<Double>> tuples = new ArrayList<Tuple<Double>>();
        AnalysisLogger.getLogger().debug((Object)("Building the points grid according to YRes:" + yResolution + " and XRes:" + xResolution));
        int i = 0;
        while (i < ysteps + 1) {
            double y = (double)i * yResolution + y1;
            if (i == ysteps) {
                y = y2;
            }
            int j = 0;
            while (j < xsteps + 1) {
                double x = (double)j * xResolution + x1;
                if (j == xsteps) {
                    x = x2;
                }
                tuples.add((Tuple<Double>)new Tuple((Object[])new Double[]{x, y, z}));
                ++j;
            }
            ++i;
        }
        return tuples;
    }

    public static List<Tuple<Double>> generateCoordinateTripletsInBoundingBox(double x1, double x2, double y1, double y2, double z, double xResolution, double yResolution) {
        ArrayList<Tuple<Double>> tuples = new ArrayList<Tuple<Double>>();
        double y = y1;
        while (y <= y2) {
            double x = x1;
            while (x <= x2) {
                tuples.add((Tuple<Double>)new Tuple((Object[])new Double[]{x, y, z}));
                x += xResolution;
            }
            y += yResolution;
        }
        return tuples;
    }

    public static double[][] vectorToMatix(List<Double> values, double x1, double x2, double y1, double y2, double xResolution, double yResolution) {
        int ntriplets = values.size();
        int ysteps = 0;
        double y = y1;
        while (y <= y2) {
            ++ysteps;
            y += yResolution;
        }
        int xsteps = 0;
        double x = x1;
        while (x <= x2) {
            ++xsteps;
            x += xResolution;
        }
        double[][] slice = new double[ysteps][xsteps];
        int k = 0;
        int g = 0;
        int t = 0;
        while (t < ntriplets) {
            Double value = values.get(t);
            slice[k][g] = value;
            if (g == xsteps - 1) {
                g = 0;
                ++k;
            } else {
                ++g;
            }
            ++t;
        }
        return slice;
    }

    public void applyNearestNeighbor() {
    }
}

