/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;
import org.gcube.dataanalysis.geo.connectors.wfs.WFS;
import org.gcube.dataanalysis.geo.matrixmodel.RasterTable;
import org.gcube.dataanalysis.geo.matrixmodel.XYExtractor;

public class XYExtraction
implements Transducerer {
    static String layerName = "Layer";
    static String t = "TimeIndex";
    static String z = "Z";
    static String yLL = "BBox_LowerLeftLat";
    static String xLL = "BBox_LowerLeftLong";
    static String yUR = "BBox_UpperRightLat";
    static String xUR = "BBox_UpperRightLong";
    static String xRes = "XResolution";
    static String yRes = "YResolution";
    static String tableName = "OutputTableName";
    static String tableLabel = "OutputTableLabel";
    AlgorithmConfiguration config;
    float status;
    public String layerNameValue;
    public int time;
    public double zValue;
    public double xResValue;
    public double yResValue;
    public String tableNameValue;
    public String tableLabelValue;
    public double BBxLL = -180.0;
    public double BBxUR = 180.0;
    public double BByLL = -90.0;
    public double BByUR = 90.0;
    public List<StatisticalType> inputs = new ArrayList<StatisticalType>();
    public LinkedHashMap<String, String> outputParameters = new LinkedHashMap();
    protected ResourceFactory resourceManager;

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Extraction Initialization");
    }

    public String getDescription() {
        return "An algorithm to extract values associated to an environmental feature repository (e.g. NETCDF, ASC, GeoTiff files etc. ).  A grid of points at a certain resolution is specified by the user and values are associated to the points from the environmental repository. It accepts as one  geospatial repository ID (via their UUIDs in the infrastructure spatial data repository - recoverable through the Geoexplorer portlet) or a direct link to a file and the specification about time and space. The algorithm produces one table containing the values associated to the selected bounding box.";
    }

    public List<StatisticalType> getInputParameters() {
        IOHelper.addStringInput(this.inputs, (String)layerName, (String)"Layer Title or UUID or HTTP link. E.g. the title or the UUID (preferred) of a layer indexed in the e-Infrastructure on GeoNetwork - You can retrieve it from GeoExplorer. Otherwise you can supply the direct HTTP link of the layer. The format will be guessed from the link. The default is GeoTiff. Supports several standards (NETCDF, WFS, WCS ASC, GeoTiff )", (String)"");
        IOHelper.addDoubleInput(this.inputs, (String)yLL, (String)"Lower Left Latitute of the Bounding Box", (String)"-60");
        IOHelper.addDoubleInput(this.inputs, (String)xLL, (String)"Lower Left Longitude of the Bounding Box", (String)"-50");
        IOHelper.addDoubleInput(this.inputs, (String)yUR, (String)"Upper Right Latitute of the Bounding Box", (String)"60");
        IOHelper.addDoubleInput(this.inputs, (String)xUR, (String)"Upper Right Longitude of the Bounding Box", (String)"50");
        IOHelper.addRandomStringInput(this.inputs, (String)tableName, (String)"The db name of the table to produce", (String)"extr_");
        IOHelper.addStringInput(this.inputs, (String)tableLabel, (String)"The name of the table to produce", (String)"extr_");
        IOHelper.addDoubleInput(this.inputs, (String)z, (String)"Value of Z. Default is 0, that means processing will be at surface level or at the first avaliable Z value in the layer", (String)"0");
        IOHelper.addIntegerInput(this.inputs, (String)t, (String)"Time Index. The default is the first time indexed dataset", (String)"0");
        IOHelper.addDoubleInput(this.inputs, (String)xRes, (String)"Projection resolution on the X axis", (String)"0.5");
        IOHelper.addDoubleInput(this.inputs, (String)yRes, (String)"Projection resolution on the Y axis", (String)"0.5");
        DatabaseType.addDefaultDBPars(this.inputs);
        return this.inputs;
    }

    protected void getParameters() {
        this.layerNameValue = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)layerName);
        AnalysisLogger.getLogger().debug((Object)("Extraction: Layer " + this.layerNameValue));
        String z$ = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)z);
        String time$ = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)t);
        int n = this.time = time$ != null && time$.trim().length() > 0 ? Integer.parseInt(time$) : 0;
        if (this.time < 0) {
            this.time = 0;
        }
        AnalysisLogger.getLogger().debug((Object)("Extraction: Time " + this.time));
        this.zValue = 0.0;
        if (z$ != null && z$.trim().length() > 0) {
            try {
                this.zValue = Double.parseDouble(z$);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        AnalysisLogger.getLogger().debug((Object)("Extraction: Z " + this.zValue));
        this.BByLL = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)yLL));
        this.BBxLL = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)xLL));
        this.BByUR = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)yUR));
        this.BBxUR = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)xUR));
        AnalysisLogger.getLogger().debug((Object)("Extraction: yLL " + this.BByLL));
        AnalysisLogger.getLogger().debug((Object)("Extraction: xLL " + this.BBxLL));
        AnalysisLogger.getLogger().debug((Object)("Extraction: yUR " + this.BByUR));
        AnalysisLogger.getLogger().debug((Object)("Extraction: xUR " + this.BBxUR));
        this.yResValue = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)yRes));
        AnalysisLogger.getLogger().debug((Object)("Extraction: yRes " + this.yResValue));
        this.xResValue = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)xRes));
        AnalysisLogger.getLogger().debug((Object)("Extraction: xRes " + this.xResValue));
        this.tableNameValue = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)tableName);
        this.tableLabelValue = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)tableLabel);
        AnalysisLogger.getLogger().debug((Object)("Extraction: tableName " + this.tableNameValue));
        AnalysisLogger.getLogger().debug((Object)("Extraction: tableLabel " + this.tableLabelValue));
        String scope = this.config.getGcubeScope();
        AnalysisLogger.getLogger().debug((Object)("Extraction: Externally set scope " + scope));
        if (scope == null) {
            scope = ScopeProvider.instance.get();
            AnalysisLogger.getLogger().debug((Object)("Extraction: Internally set scope " + scope));
            this.config.setGcubeScope(scope);
        }
    }

    public void compute() throws Exception {
        try {
            try {
                this.status = 10.0f;
                AnalysisLogger.setLogger((String)(String.valueOf(this.config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile));
                this.getParameters();
                AnalysisLogger.getLogger().debug((Object)"Extractor: MatrixExtractor initialized");
                long t0 = System.currentTimeMillis();
                XYExtractor extractor = new XYExtractor(this.config);
                this.zValue = extractor.correctZ(this.zValue, this.layerNameValue, this.xResValue);
                AnalysisLogger.getLogger().debug((Object)("XYExtraction->Best Z for this reference layer: " + this.zValue));
                this.outputParameters.put("Matching Z value in the layer", "" + this.zValue);
                this.outputParameters.put("Min Z value in the Layer", "" + extractor.zmin);
                this.outputParameters.put("Max Z value in the Layer", "" + extractor.zmax);
                double[][] matrix = extractor.extractXYGrid(this.layerNameValue, this.time, this.BBxLL, this.BBxUR, this.BByLL, this.BByUR, this.zValue, this.xResValue, this.yResValue);
                HashMap<Double, Map<String, String>> polygonsFeatures = null;
                if (extractor.currentconnector instanceof WFS) {
                    polygonsFeatures = ((WFS)extractor.currentconnector).getPolygonsFeatures();
                }
                AnalysisLogger.getLogger().debug((Object)("ELAPSED TIME: " + (System.currentTimeMillis() - t0)));
                AnalysisLogger.getLogger().debug((Object)"Extractor: Matrix Extracted");
                AnalysisLogger.getLogger().debug((Object)"Extractor: ****Rasterizing grid into table****");
                this.status = 30.0f;
                RasterTable raster = new RasterTable(this.BBxLL, this.BBxUR, this.BByLL, this.BByUR, this.zValue, this.time, this.xResValue, this.yResValue, matrix, polygonsFeatures, this.config);
                raster.setTablename(this.tableNameValue);
                raster.deleteTable();
                raster.dumpGeoTable();
                AnalysisLogger.getLogger().debug((Object)("Extractor: Map was dumped in table: " + this.tableNameValue));
                this.status = 80.0f;
                AnalysisLogger.getLogger().debug((Object)("Extractor: Elapsed: Whole operation completed in " + (double)(System.currentTimeMillis() - t0) / 1000.0 + "s"));
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().debug((Object)("Extractor: ERROR!: " + e.getLocalizedMessage()));
                throw e;
            }
        }
        finally {
            this.status = 100.0f;
        }
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"Shutdown");
    }

    public StatisticalType getOutput() {
        ArrayList<TableTemplates> templateHspec = new ArrayList<TableTemplates>();
        templateHspec.add(TableTemplates.TIMESERIES);
        OutputTable p = new OutputTable(templateHspec, this.tableLabelValue, this.tableNameValue, "Output table");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : this.outputParameters.keySet()) {
            String value = this.outputParameters.get(key);
            PrimitiveType val = new PrimitiveType(String.class.getName(), (Object)value, PrimitiveTypes.STRING, key, key);
            map.put(key, val);
        }
        map.put("OutputTable", p);
        PrimitiveType outputm = new PrimitiveType(HashMap.class.getName(), map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return outputm;
    }

    public float getStatus() {
        return this.status;
    }

    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(1);
    }

    public String getResources() {
        return ResourceFactory.getResources((float[])new float[]{100.0f});
    }
}

