/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.vti.vesselsprocessing;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.dataanalysis.geo.utils.CSquareCodesConverter;

public class MonthlyFishingEffortCalculator {
    private double minEffort;
    private double maxEffort;

    private static int monthsDifference(Date minDate, Date maxDate) {
        Calendar min = Calendar.getInstance();
        min.setTime(minDate);
        Calendar max = Calendar.getInstance();
        max.setTime(maxDate);
        int monthsDiff = (max.get(1) - min.get(1)) * 12 + (max.get(2) - min.get(2)) + (max.get(5) - min.get(5)) / 27;
        return monthsDiff;
    }

    public Map<String, Double> calculateMonthlyFishingEffort(List<Object> rows, Date minDate, Date maxDate) {
        HashMap<String, Double> csquare2month = new HashMap<String, Double>();
        HashMap<String, double[]> csquaremonths = new HashMap<String, double[]>();
        int numOfPoints = rows.size();
        int numOfMonths = MonthlyFishingEffortCalculator.monthsDifference(minDate, maxDate);
        System.out.println("min:" + minDate + " max " + maxDate + " months diffs " + numOfMonths);
        int i = 0;
        while (i < numOfPoints) {
            Object[] singleRow = (Object[])rows.get(i);
            double x = (Double)singleRow[0];
            double y = (Double)singleRow[1];
            Date d = (Date)singleRow[2];
            double hours = (Double)singleRow[3];
            String activity = ((String)singleRow[4]).toLowerCase();
            if (activity.equalsIgnoreCase("fishing")) {
                String csquare = CSquareCodesConverter.convertHalfDegree(x, y);
                double[] csquaremontheffort = (double[])csquaremonths.get(csquare);
                if (csquaremontheffort == null) {
                    csquaremontheffort = new double[numOfMonths + 1];
                }
                int index = MonthlyFishingEffortCalculator.monthsDifference(minDate, d);
                csquaremontheffort[index] = csquaremontheffort[index] + hours;
                csquaremonths.put(csquare, csquaremontheffort);
            }
            ++i;
        }
        for (String keySquare : csquaremonths.keySet()) {
            double[] monthsEffort = (double[])csquaremonths.get(keySquare);
            double sum = 0.0;
            int i2 = 0;
            while (i2 < numOfMonths + 1) {
                sum += monthsEffort[i2];
                ++i2;
            }
            sum /= (double)(numOfMonths + 1);
            if ((sum = MathFunctions.roundDecimal((double)sum, (int)2)) > this.maxEffort) {
                this.maxEffort = sum;
            }
            if (sum < this.minEffort) {
                this.minEffort = sum;
            }
            csquare2month.put(keySquare, sum);
        }
        return csquare2month;
    }

    public double getMinEffort() {
        return this.minEffort;
    }

    public void setMinEffort(double minEffort) {
        this.minEffort = minEffort;
    }

    public double getMaxEffort() {
        return this.maxEffort;
    }

    public void setMaxEffort(double maxEffort) {
        this.maxEffort = maxEffort;
    }
}

