/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;
import org.gcube.dataanalysis.geo.connectors.asc.AscRaster;
import org.gcube.dataanalysis.geo.connectors.asc.AscRasterWriter;

public class CSV2ESRIGRID {
    public static void main(String[] args) throws Exception {
        String[] paramColumns;
        String inputFolder = "C:\\Users\\coro\\Desktop\\DatabaseBackup\\HCAFs\\";
        String inputFile = new File(inputFolder, "hcaf_d2050.csv").getAbsolutePath();
        double resolution = 0.5;
        String latColumn = "centerlat";
        String longColumn = "centerlong";
        for (String paramColumn : paramColumns = new String[]{"depthmin", "depthmax", "depthmean", "depthsd", "sstanmean", "sstansd", "sstmnmax", "sstmnmin", "sstmnrange", "sbtanmean", "salinitymean", "salinitysd", "salinitymax", "salinitymin", "salinitybmean", "primprodmean", "iceconann", "oceanarea", "landdist"}) {
            String outputFile = new File(inputFolder, "hcaf_2050" + paramColumn + ".asc").getAbsolutePath();
            AnalysisLogger.setLogger((String)("./cfg/" + AlgorithmConfiguration.defaultLoggerFile));
            CSV2ESRIGRID.toESRI(inputFile, outputFile, resolution, latColumn, longColumn, paramColumn);
        }
    }

    public static void toESRI(String inputFile, String outputFile, double resolution, String latcolumn, String longcolumn, String paramcolumn) throws Exception {
        float BBxLLf = -180.0f;
        float BBxURf = 180.0f;
        float BByLLf = -90.0f;
        float BByURf = 90.0f;
        try {
            long t0 = System.currentTimeMillis();
            AnalysisLogger.getLogger().debug((Object)("toESRI->Building raster object for " + paramcolumn));
            AnalysisLogger.getLogger().debug((Object)("toESRI->Building raster object to " + outputFile));
            BufferedReader br = new BufferedReader(new FileReader(new File(inputFile)));
            String line = br.readLine();
            String delimiter = ",";
            List lineElems = Transformations.parseCVSString((String)line, (String)delimiter);
            int latColIdx = 0;
            int longColIdx = 0;
            int valColIdx = 0;
            int k = 0;
            for (String elem : lineElems) {
                if (elem.equalsIgnoreCase(latcolumn)) {
                    latColIdx = k;
                }
                if (elem.equalsIgnoreCase(longcolumn)) {
                    longColIdx = k;
                }
                if (elem.equalsIgnoreCase(paramcolumn)) {
                    valColIdx = k;
                }
                ++k;
            }
            AnalysisLogger.getLogger().debug((Object)("toESRI->Lat column index " + latColIdx));
            AnalysisLogger.getLogger().debug((Object)("toESRI->Long column index " + longColIdx));
            AnalysisLogger.getLogger().debug((Object)("toESRI->Parameter column index " + valColIdx));
            line = br.readLine();
            int ncols = (int)Math.round((double)(BBxURf - BBxLLf) / resolution);
            int nrows = (int)Math.round((double)(BByURf - BByLLf) / resolution);
            AnalysisLogger.getLogger().debug((Object)("toESRI->Matrix size " + nrows + "X" + ncols));
            double[][] data = new double[nrows][ncols];
            AscRaster raster = new AscRaster(data, resolution, -1.0, -1.0, (double)BBxLLf, (double)BByLLf);
            while (line != null) {
                lineElems = Transformations.parseCVSString((String)line, (String)delimiter);
                float longitude = Float.parseFloat((String)lineElems.get(longColIdx));
                float latitude = Float.parseFloat((String)lineElems.get(latColIdx));
                float value = -9999.0f;
                try {
                    value = Float.parseFloat((String)lineElems.get(valColIdx));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int lonidx = Math.max(0, raster.longitude2Index(longitude));
                int latidx = Math.max(0, raster.latitude2Index(latitude));
                if ((double)longitude == 10.75 && (double)latitude == 43.75) {
                    AnalysisLogger.getLogger().debug((Object)("toESRI->" + longitude + "," + latitude + "," + value + "->" + lonidx + "," + latidx));
                }
                raster.setValue(latidx, lonidx, value);
                line = br.readLine();
            }
            File outputfile = new File(outputFile);
            AnalysisLogger.getLogger().debug((Object)("toESRI->Writing raster file " + outputfile.getAbsolutePath()));
            AscRasterWriter writer = new AscRasterWriter();
            writer.writeRaster(outputfile.getAbsolutePath(), raster);
            AnalysisLogger.getLogger().debug((Object)("toESRI->Elapsed: Whole operation completed in " + (double)(System.currentTimeMillis() - t0) / 1000.0 + "s"));
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("toESRI->ERROR!: " + e.getLocalizedMessage()));
            throw e;
        }
    }
}

