/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.algorithms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.connectors.wfs.WFS;
import org.gcube.dataanalysis.geo.matrixmodel.RasterTable;
import org.gcube.dataanalysis.geo.matrixmodel.XYExtractor;
import org.gcube.dataanalysis.geo.utils.VectorOperations;
import org.hibernate.SessionFactory;

public class OccurrenceEnrichment
implements Transducerer {
    static String OccurrencesTableNameParameter = "OccurrenceTable";
    static String LongitudeColumn = "LongitudeColumn";
    static String LatitudeColumn = "LatitudeColumn";
    static String ScientificNameColumn = "ScientificNameColumn";
    static String TimeColumn = "TimeColumn";
    static String OutputTableLabelParameter = "OutputTableName";
    static String OutputTableDBNameParameter = "OutputTableDBName";
    static String FilterParameter = "OptionalFilter";
    static String Resolution = "Resolution";
    static String Layers = "Layers";
    static String LayersNames = "FeaturesNames";
    static String yLL = "BBox_LowerLeftLat";
    static String xLL = "BBox_LowerLeftLong";
    static String yUR = "BBox_UpperRightLat";
    static String xUR = "BBox_UpperRightLong";
    AlgorithmConfiguration config;
    float status;
    private String[] layers;
    private String[] layersnames;
    private String occurrencesTableName;
    private String longitudeColumn;
    private String latitudeColumn;
    private String scientificnameColumn;
    private String timeColumn;
    private String filter;
    private float resolution;
    private String outputTableLabel;
    private String outputTableDBName;
    public LinkedHashMap<String, String> outputParameters = new LinkedHashMap();
    protected ResourceFactory resourceManager;

    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> inputs = new ArrayList<StatisticalType>();
        ArrayList<TableTemplates> template = new ArrayList<TableTemplates>();
        template.add(TableTemplates.OCCURRENCE_SPECIES);
        InputTable table = new InputTable(template, OccurrencesTableNameParameter, "A geospatial table containing occurrence records, following the template of the Species Products Discovery datasets", "");
        inputs.add((StatisticalType)table);
        ColumnType p1 = new ColumnType(OccurrencesTableNameParameter, LongitudeColumn, "The column containing longitude values", "decimallongitude", false);
        inputs.add((StatisticalType)p1);
        ColumnType p2 = new ColumnType(OccurrencesTableNameParameter, LatitudeColumn, "The column containing latitude values", "decimallatitude", false);
        inputs.add((StatisticalType)p2);
        ColumnType p3 = new ColumnType(OccurrencesTableNameParameter, ScientificNameColumn, "The column containing Scientific Names", "scientificname", false);
        inputs.add((StatisticalType)p3);
        ColumnType p4 = new ColumnType(OccurrencesTableNameParameter, TimeColumn, "The column containing time information", "eventdate", false);
        inputs.add((StatisticalType)p4);
        IOHelper.addStringInput(inputs, (String)FilterParameter, (String)"A filter on one of the columns (e.g. basisofrecord='HumanObservation'). Optional", (String)" ");
        IOHelper.addDoubleInput(inputs, (String)Resolution, (String)"The spatial resolution in degrees of the association between observations and environmental features", (String)"0.5");
        IOHelper.addRandomStringInput(inputs, (String)OutputTableDBNameParameter, (String)"The database name of the table to produce", (String)"enrich_");
        IOHelper.addStringInput(inputs, (String)OutputTableLabelParameter, (String)"The name of the output table", (String)"enrich_");
        PrimitiveTypesList listEnvLayers = new PrimitiveTypesList(String.class.getName(), PrimitiveTypes.STRING, Layers, "The list of environmental layers to use for enriching the points. Each entry is a layer Title or UUID or HTTP link. E.g. the title or the UUID (preferred) of a layer indexed in the e-Infrastructure on GeoNetwork - You can retrieve it from GeoExplorer. Otherwise you can supply the direct HTTP link of the layer. The format will be guessed from the link. The default is GeoTiff. Supports several standards (NETCDF, WFS, WCS, ASC, GeoTiff )", false);
        inputs.add((StatisticalType)listEnvLayers);
        PrimitiveTypesList listEnvLayersNames = new PrimitiveTypesList(String.class.getName(), PrimitiveTypes.STRING, LayersNames, "The list of names for the columns corresponding to the environmental layers. These will be the column names of the resulting table", false);
        inputs.add((StatisticalType)listEnvLayersNames);
        DatabaseType.addDefaultDBPars(inputs);
        return inputs;
    }

    protected void getParameters() {
        this.layers = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)Layers).trim().split(AlgorithmConfiguration.getListSeparator());
        String layernamesS = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)LayersNames);
        if (layernamesS == null) {
            layernamesS = "";
        }
        this.layersnames = layernamesS.split(AlgorithmConfiguration.getListSeparator());
        AnalysisLogger.getLogger().debug((Object)("N. of Layers to take " + this.layers.length));
        this.occurrencesTableName = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)OccurrencesTableNameParameter);
        this.longitudeColumn = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)LongitudeColumn);
        this.latitudeColumn = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)LatitudeColumn);
        this.scientificnameColumn = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)ScientificNameColumn);
        this.timeColumn = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)TimeColumn);
        this.filter = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)FilterParameter);
        if (this.filter == null) {
            this.filter = "";
        }
        this.filter = this.filter.trim();
        this.resolution = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)Resolution) == null ? 0.5f : Float.parseFloat(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)Resolution));
        this.outputTableLabel = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)OutputTableLabelParameter);
        this.outputTableDBName = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)OutputTableDBNameParameter);
        AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->layers: " + this.layers));
        AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->layers names: " + this.layersnames));
        AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->occurrencesTableName: " + this.occurrencesTableName));
        AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->longitudeColumn: " + this.longitudeColumn));
        AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->latitudeColumn: " + this.latitudeColumn));
        AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->scientificnameColumn: " + this.scientificnameColumn));
        AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->timeColumn: " + this.timeColumn));
        AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->filter: " + this.filter));
        AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->resolution: " + this.resolution));
        AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->outputTableLabel: " + this.outputTableLabel));
        AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->outputTableDBName: " + this.outputTableDBName));
        String scope = this.config.getGcubeScope();
        AnalysisLogger.getLogger().debug((Object)("Extraction: Externally set scope " + scope));
        if (scope == null) {
            scope = ScopeProvider.instance.get();
            AnalysisLogger.getLogger().debug((Object)("Extraction: Internally set scope " + scope));
            this.config.setGcubeScope(scope);
        }
    }

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Occurrence Enrichment Initialization");
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"Occurrence Enrichment Shutdown");
    }

    public String getDescription() {
        return "An algorithm performing occurrences enrichment. Takes as input one table containing occurrence points for a set of species and a list of environmental layer, taken either from the e-infrastructure GeoNetwork (through the GeoExplorer application) or from direct HTTP links. Produces one table reporting the set of environmental values associated to the occurrence points.";
    }

    public static String generateEmptyValues(int nValues) {
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < nValues; ++j) {
            sb.append("''");
            if (j >= nValues - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public void compute() throws Exception {
        SessionFactory dbconnection = null;
        try {
            long t0 = System.currentTimeMillis();
            this.status = 10.0f;
            this.getParameters();
            dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
            String columns = this.longitudeColumn + "," + this.latitudeColumn + "," + this.scientificnameColumn + "," + this.timeColumn;
            String columnsTypes = "id serial, " + this.longitudeColumn + " real," + this.latitudeColumn + " real," + this.scientificnameColumn + " character varying," + this.timeColumn + " timestamp without time zone";
            String query = "select min(" + this.longitudeColumn + ") as minlong, max(" + this.longitudeColumn + ") as maxlong,min(" + this.latitudeColumn + ") as minlat,max(" + this.latitudeColumn + ") as maxlat from " + this.occurrencesTableName;
            AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->Retrieving bounding box: " + query));
            List minmaxlonglat = DatabaseFactory.executeSQLQuery((String)query, (SessionFactory)dbconnection);
            if (minmaxlonglat == null || minmaxlonglat.size() == 0) {
                throw new Exception("Could not find min and max for occurrence data");
            }
            this.status = 20.0f;
            Object[] minmaxLongLat = (Object[])minmaxlonglat.get(0);
            double BBxLL = Double.parseDouble("" + minmaxLongLat[0]);
            double BBxUR = Double.parseDouble("" + minmaxLongLat[1]);
            double BByLL = Double.parseDouble("" + minmaxLongLat[2]);
            double BByUR = Double.parseDouble("" + minmaxLongLat[3]);
            AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->Calculated Bounding Box: [" + BBxLL + "," + BByLL + ";" + BBxUR + "," + BByUR + "]"));
            List rows = DatabaseFactory.executeSQLQuery((String)DatabaseUtils.getDinstictElements((String)this.occurrencesTableName, (String)columns, (String)this.filter), (SessionFactory)dbconnection);
            if (rows == null || rows.size() == 0) {
                throw new Exception("Could not find occurrence data");
            }
            this.status = 30.0f;
            AnalysisLogger.getLogger().debug((Object)"OccurrenceEnrichment->Rows Retrieved");
            ArrayList<Tuple<Double>> coordinates4d = new ArrayList<Tuple<Double>>();
            ArrayList<String[]> enrichment = new ArrayList<String[]>();
            int elementsFromOccurrences = 4;
            int elementstoreport = elementsFromOccurrences + this.layers.length;
            for (Object row : rows) {
                Object[] elements = (Object[])row;
                double x = elements[0] == null ? 0.0 : Double.parseDouble("" + elements[0]);
                double y = elements[1] == null ? 0.0 : Double.parseDouble("" + elements[1]);
                String species = elements[2] == null ? "" : "" + elements[2];
                String time = elements[3] == null ? "NULL" : "" + elements[3];
                Tuple el = new Tuple((Object[])new Double[]{x, y, 0.0, 0.0});
                coordinates4d.add(el);
                String[] singlerow = new String[elementstoreport];
                singlerow[0] = "" + x;
                singlerow[1] = "" + y;
                singlerow[2] = species;
                singlerow[3] = time;
                enrichment.add(singlerow);
            }
            AnalysisLogger.getLogger().debug((Object)"OccurrenceEnrichment->Tuples Created. Assigning grid values to the tuples");
            this.status = 40.0f;
            int layeridx = 0;
            float statusSteps = 50.0f / (float)this.layers.length;
            for (String layerID : this.layers) {
                if (layerID.length() == 0) continue;
                AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->Assigning layer " + (String)layerID + " Layer enumerator: " + layeridx));
                XYExtractor extractor = new XYExtractor(this.config);
                extractor.correctZ(0.0, layerID, this.resolution);
                double zmin = extractor.zmin;
                double zmax = extractor.zmax;
                double bestZ = Math.min(Math.abs(zmin), Math.abs(zmax));
                this.outputParameters.put("Matching Z value in layer " + (layeridx + 1), "" + bestZ);
                this.outputParameters.put("Min Z value in layer " + (layeridx + 1), "" + zmin);
                this.outputParameters.put("Max Z value in layer " + (layeridx + 1), "" + zmax);
                AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->Best Z for this reference layer: " + bestZ));
                extractor.extractXYGrid(layerID, 0, BBxLL, BBxUR, BByLL, BByUR, bestZ, this.resolution, this.resolution);
                List gridValues = extractor.currentTimeValues;
                List grid3d = extractor.currentTuples;
                String layername = this.layersnames.length > layeridx && this.layersnames[layeridx].trim().length() > 0 ? this.layersnames[layeridx].trim() : "feature" + (layeridx + 1);
                AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->Retrieved Layer Name: " + layername));
                AnalysisLogger.getLogger().debug((Object)"OccurrenceEnrichment->Assigning grid points to the occurrences");
                List<Double> enriched = VectorOperations.assignGridValuesToPoints2D(grid3d, gridValues, coordinates4d, this.resolution);
                int k = 0;
                AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->Assigning values to the column " + (elementsFromOccurrences + layeridx)));
                HashMap<Double, Map<String, String>> polygonsFeatures = null;
                if (extractor.currentconnector instanceof WFS) {
                    polygonsFeatures = ((WFS)extractor.currentconnector).getPolygonsFeatures();
                }
                boolean enrichWithEnvironmentalFeatures = true;
                Map<String, String> features = null;
                String emptyRow = "";
                if (polygonsFeatures != null && polygonsFeatures.size() > 0) {
                    AnalysisLogger.getLogger().debug((Object)"OccurrenceEnrichment->Managing Web Features");
                    enrichWithEnvironmentalFeatures = false;
                    features = polygonsFeatures.values().iterator().next();
                    int ncolumns = features.keySet().size();
                    emptyRow = OccurrenceEnrichment.generateEmptyValues(ncolumns);
                    AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->Number of additional columns " + ncolumns));
                    columnsTypes = columnsTypes + "," + RasterTable.propertiesMapToColumnString(features, true);
                    columns = columns + "," + RasterTable.propertiesMapToColumnString(features, false);
                } else {
                    columns = columns + ",\"" + layername + "\"";
                    columnsTypes = columnsTypes + ",\"" + layername + "\" real";
                }
                for (Double value : enriched) {
                    String[] singlerow = (String[])enrichment.get(k);
                    singlerow[elementsFromOccurrences + layeridx] = enrichWithEnvironmentalFeatures ? (value == null || Double.isNaN(value) || Double.isInfinite(value) ? "-9999" : "" + value) : (value == null || Double.isNaN(value) || Double.isInfinite(value) ? emptyRow : RasterTable.propertiesMapToDatabaseString(features));
                    ++k;
                }
                AnalysisLogger.getLogger().debug((Object)"OccurrenceEnrichment->Added values to the row");
                ++layeridx;
                this.status += statusSteps;
            }
            AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->Dropping table " + this.outputTableDBName));
            try {
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.outputTableDBName), (SessionFactory)dbconnection);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->cannot drop table, does not exist: " + this.outputTableDBName));
            }
            String createquery = "create table " + this.outputTableDBName + " (" + columnsTypes + ")";
            AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->Creating table " + this.outputTableDBName + " query:" + createquery));
            DatabaseFactory.executeSQLUpdate((String)createquery, (SessionFactory)dbconnection);
            AnalysisLogger.getLogger().debug((Object)"OccurrenceEnrichment->Inserting chunks");
            DatabaseUtils.insertChunksIntoTable((String)this.outputTableDBName, (String)columns, enrichment, (int)5000, (SessionFactory)dbconnection, (boolean)false);
            AnalysisLogger.getLogger().debug((Object)("OccurrenceEnrichment->Whole process complete in " + (double)(System.currentTimeMillis() - t0) / 1000.0 + " s"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (dbconnection != null) {
                dbconnection.close();
            }
            this.status = 100.0f;
        }
    }

    public StatisticalType getOutput() {
        ArrayList<TableTemplates> templateHspec = new ArrayList<TableTemplates>();
        templateHspec.add(TableTemplates.GENERIC);
        OutputTable p = new OutputTable(templateHspec, this.outputTableLabel, this.outputTableDBName, "Output table");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : this.outputParameters.keySet()) {
            String value = this.outputParameters.get(key);
            PrimitiveType val = new PrimitiveType(String.class.getName(), (Object)("" + value), PrimitiveTypes.STRING, key, key);
            map.put(key, val);
        }
        map.put("OutputTable", p);
        PrimitiveType outputm = new PrimitiveType(HashMap.class.getName(), map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return outputm;
    }

    public float getStatus() {
        return this.status;
    }

    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(1);
    }

    public String getResources() {
        return ResourceFactory.getResources((float[])new float[]{100.0f});
    }
}

