/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.batch;

import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkAdministration;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.gcube.spatial.data.geonetwork.configuration.DefaultConfiguration;
import org.gcube.spatial.data.geonetwork.model.Account;
import org.gcube.spatial.data.geonetwork.model.ScopeConfiguration;
import org.gcube.spatial.data.geonetwork.model.faults.MissingConfigurationException;
import org.gcube.spatial.data.geonetwork.utils.UserUtils;
import org.geotoolkit.metadata.iso.DefaultMetadata;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.identification.Identification;

public class CheckLayerRetrieval {
    static String geonetworkurl = "http://geonetwork.d4science.org/geonetwork/";
    static String geonetworkUser = "admin";
    static String geonetworkPwd = "kee9GeeK";

    public static void main(String[] args) throws Exception {
        String scope = "/d4science.research-infrastructures.eu/gCubeApps";
        String title = "oscar";
        ScopeProvider.instance.set(scope);
        GeoNetworkAdministration reader = GeoNetwork.get();
        reader.login(LoginLevel.SCOPE);
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.any, title);
        req.addConfig(GNSearchRequest.Config.similarity, "1");
        GNSearchResponse resp = reader.query(req);
        System.out.println("Found N layers: " + resp.getCount());
        Long id = 0L;
        Metadata meta = null;
        DefaultConfiguration geonetworkCfg = (DefaultConfiguration)reader.getConfiguration();
        Integer scopePublicGroup = geonetworkCfg.getScopeConfiguration().getPublicGroup();
        System.out.println("scopePublicGroup " + scopePublicGroup);
        for (GNSearchResponse.GNMetadata metadata : resp) {
            id = metadata.getId();
            System.out.println("ID " + id);
            System.out.println("Name " + metadata.getInfo().getName());
            meta = reader.getById(id.longValue());
            Identification idf = (Identification)meta.getIdentificationInfo().iterator().next();
            String otitle = idf.getCitation().getTitle().toString();
            ((DefaultMetadata)meta).setFileIdentifier(UUID.randomUUID().toString());
            System.out.println("Title " + otitle);
        }
    }

    public static void main2(String[] args) throws Exception {
        String targetScope = "/d4science.research-infrastructures.eu/gCubeApps";
        String title = "oscar";
        CheckLayerRetrieval.checkLayerInScope(title, targetScope, targetScope);
    }

    public static void checkLayerInScope(String title, String startScope, String targetScope) throws Exception {
        ScopeProvider.instance.set(startScope);
        GeoNetworkAdministration reader = GeoNetwork.get();
        reader.login(LoginLevel.SCOPE);
        DefaultConfiguration geonetworkCfg = (DefaultConfiguration)reader.getConfiguration();
        Integer scopePublicGroup = geonetworkCfg.getScopeConfiguration().getPublicGroup();
        Map accounts = geonetworkCfg.getScopeConfiguration().getAccounts();
        Account account = (Account)accounts.get(Account.Type.SCOPE);
        String geonetworkUser = account.getUser();
        String geonetworkPassword = account.getPassword();
        System.out.println("GeoNetwork user " + geonetworkUser);
        System.out.println("GeoNetwork password " + geonetworkPassword);
        System.out.println("GeoNetwork scope Public Group " + scopePublicGroup);
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.any, title);
        req.addConfig(GNSearchRequest.Config.similarity, "1");
        GNSearchResponse resp = reader.query(req);
        Long id = 0L;
        Metadata meta = null;
        System.out.println("Found N layers: " + resp.getCount());
        for (GNSearchResponse.GNMetadata metadata : resp) {
            id = metadata.getId();
            System.out.println("ID " + id);
            System.out.println("Name " + metadata.getInfo().getName());
            meta = reader.getById(id.longValue());
            Identification idf = (Identification)meta.getIdentificationInfo().iterator().next();
            String otitle = idf.getCitation().getTitle().toString();
            System.out.println("Title " + otitle);
            if (!otitle.toLowerCase().contains(title.toLowerCase())) {
                System.out.println("Invalid layer");
                continue;
            }
            ScopeConfiguration targetConfiguration = null;
            targetScope = targetScope.substring(targetScope.lastIndexOf("/") + 1);
            System.out.println("target scope " + targetScope);
            for (ScopeConfiguration configuration : reader.getConfiguration().getExistingConfigurations()) {
                if (!configuration.getAssignedScope().equals(targetScope)) continue;
                targetConfiguration = configuration;
            }
            if (targetConfiguration == null) {
                throw new MissingConfigurationException("Scope " + targetScope + " has no configuration");
            }
            int targetUserId = UserUtils.getByName((Set)reader.getUsers(), (String)((Account)targetConfiguration.getAccounts().get(Account.Type.SCOPE)).getUser()).getId();
            int targetGroup = targetConfiguration.getDefaultGroup();
            System.out.println("INFO: ID " + id + " targetUserId " + targetUserId + " targetGroup " + targetGroup);
            System.out.println("Done with " + otitle);
            Thread.sleep(2000L);
        }
        System.out.println("All done");
    }
}

