/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.algorithms;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.geo.utils.CSquareCodesConverter;
import org.hibernate.SessionFactory;

public class CSquaresCreator
extends StandardLocalInfraAlgorithm {
    static String xDim = "Longitude_Column";
    static String yDim = "Latitude_Column";
    static String inputTableParameter = "InputTable";
    static String outputTableParameter = "OutputTableName";
    String resolutionParameter = "CSquare_Resolution";
    String codecolumnName = "csquare_code";
    String outTable = "";
    String outTableLabel = "";
    double resolution = 0.1;
    SessionFactory connection = null;

    protected void setInputParameters() {
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.GENERIC);
        InputTable tinput = new InputTable(templates, inputTableParameter, "The table to which the algorithm adds the csquare column");
        this.inputs.add(tinput);
        ColumnType xDimension = new ColumnType(inputTableParameter, xDim, "The column containing Longitude information", "x", false);
        ColumnType yDimension = new ColumnType(inputTableParameter, yDim, "The column containing Latitude information", "y", false);
        this.inputs.add(xDimension);
        this.inputs.add(yDimension);
        IOHelper.addDoubleInput((List)this.inputs, (String)this.resolutionParameter, (String)"The resolution of the CSquare codes", (String)"0.1");
        IOHelper.addStringInput((List)this.inputs, (String)outputTableParameter, (String)"The name of the output table", (String)"csquaretbl_");
        DatabaseType.addDefaultDBPars((List)this.inputs);
    }

    public StatisticalType getOutput() {
        ArrayList<TableTemplates> template = new ArrayList<TableTemplates>();
        template.add(TableTemplates.GENERIC);
        OutputTable p = new OutputTable(template, this.outTableLabel, this.outTable, "Output table");
        return p;
    }

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"CSquareCreator  Initialized");
    }

    public String getDescription() {
        return "An algorithm that adds a column containing the CSquare codes associated to longitude and latitude columns.";
    }

    protected void process() throws Exception {
        this.status = 0.0f;
        AnalysisLogger.setLogger((String)(this.config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile));
        long t0 = System.currentTimeMillis();
        String x = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)xDim);
        String y = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)yDim);
        String table = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)inputTableParameter);
        this.outTable = ("code_" + UUID.randomUUID()).replace("-", "");
        this.resolution = Double.parseDouble(IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)this.resolutionParameter));
        this.outTableLabel = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)outputTableParameter);
        AnalysisLogger.getLogger().debug((Object)("CSquareCreator: received parameters: x " + x + ", y " + y + ", table " + table + ", outputTable " + this.outTable + ", res " + this.resolution + " outLabel " + this.outTableLabel));
        this.status = 10.0f;
        if (x == null || x.trim().length() == 0 || y == null || y.trim().length() == 0) {
            throw new Exception("Error please provide information for the input table");
        }
        try {
            this.addCodeColumToTable(table);
            AnalysisLogger.getLogger().debug((Object)"CSquareCreator: finished");
        }
        catch (Throwable e) {
            throw new Exception(e.getMessage());
        }
        finally {
            this.status = 100.0f;
        }
    }

    public String selectInformationForTransformation(AlgorithmConfiguration config, String table, int limit, int offset) {
        String x = IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)xDim);
        String y = IOHelper.getInputParameter((AlgorithmConfiguration)config, (String)yDim);
        String select = "select *," + x + " as loforcs01," + y + " as laforcs01 from " + table + " limit " + limit + " offset " + offset;
        return select;
    }

    public String rowToCode(Object[] rowArray) {
        String xValue = "" + rowArray[rowArray.length - 2];
        String yValue = "" + rowArray[rowArray.length - 1];
        String csquare = "";
        try {
            double xV = Double.parseDouble(xValue);
            double yV = Double.parseDouble(yValue);
            csquare = CSquareCodesConverter.convertAtResolution(yV, xV, this.resolution);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return csquare;
    }

    public void addCodeColumToTable(String table) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"CodeCreator: initializing connection");
        long t0 = System.currentTimeMillis();
        try {
            this.connection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
            AnalysisLogger.getLogger().debug((Object)("CodeCreator: database: " + this.config.getDatabaseURL()));
            AnalysisLogger.getLogger().debug((Object)("CodeCreator: dropping table " + this.outTable + " if exists"));
            try {
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.outTable), (SessionFactory)this.connection);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)("CodeCreator: table " + this.outTable + " does not exist yet"));
            }
            AnalysisLogger.getLogger().debug((Object)("CodeCreator: creating the new table " + this.outTable));
            DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.createBlankTableFromAnotherStatement((String)table, (String)this.outTable), (SessionFactory)this.connection);
            AnalysisLogger.getLogger().debug((Object)("CodeCreator: adding new column to " + this.outTable));
            DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.addColumnStatement((String)this.outTable, (String)this.codecolumnName, (String)"character varying"), (SessionFactory)this.connection);
            AnalysisLogger.getLogger().debug((Object)("CodeCreator: getting columns from " + this.outTable));
            List names = DatabaseFactory.executeSQLQuery((String)DatabaseUtils.getColumnsNamesStatement((String)this.outTable), (SessionFactory)this.connection);
            StringBuffer colnames = new StringBuffer();
            int nnames = names.size();
            for (int i = 0; i < nnames; ++i) {
                colnames.append(names.get(i));
                if (i >= nnames - 1) continue;
                colnames.append(",");
            }
            AnalysisLogger.getLogger().debug((Object)("CodeCreator: columns are: " + colnames.toString()));
            AnalysisLogger.getLogger().debug((Object)"CodeCreator: taking chunks ... ");
            int initIdx = 0;
            int limit = 5000;
            long maxRows = DatabaseUtils.estimateNumberofRows((String)table, (SessionFactory)this.connection);
            AnalysisLogger.getLogger().debug((Object)("CodeCreator: estimated number of rows " + maxRows));
            this.status = 20.0f;
            while (true) {
                String select = this.selectInformationForTransformation(this.config, table, limit, initIdx);
                AnalysisLogger.getLogger().debug((Object)("CodeCreator: executing query: " + select));
                AnalysisLogger.getLogger().debug((Object)("CodeCreator: from " + initIdx + " to " + (initIdx + limit) + " limit " + limit));
                List rows = DatabaseFactory.executeSQLQuery((String)select, (SessionFactory)this.connection);
                if (rows == null || rows.size() == 0) break;
                AnalysisLogger.getLogger().debug((Object)"CodeCreator: transforming ");
                ArrayList<String[]> stringrows = new ArrayList<String[]>();
                for (Object row : rows) {
                    Object[] rowArray = (Object[])row;
                    String code = this.rowToCode(rowArray);
                    rowArray[nnames - 1] = code;
                    String[] stringArray = new String[nnames];
                    for (int k = 0; k < stringArray.length; ++k) {
                        stringArray[k] = "" + rowArray[k];
                    }
                    stringrows.add(stringArray);
                }
                AnalysisLogger.getLogger().debug((Object)"CSquareCreator: inserting chunks into the table");
                DatabaseUtils.insertChunksIntoTable((String)this.outTable, (String)colnames.toString(), stringrows, (int)limit, (SessionFactory)this.connection, (boolean)true);
                this.status = Math.min(90L, 20L + (long)(70 * (initIdx += limit)) / maxRows);
                AnalysisLogger.getLogger().debug((Object)("CSquareCreator: status " + this.status));
            }
            AnalysisLogger.getLogger().debug((Object)"CodeCreator: no more rows");
            AnalysisLogger.getLogger().debug((Object)"CSquareCreator: finished");
        }
        catch (Throwable e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("CSquareCreator : ERROR!: " + e.getLocalizedMessage()));
            try {
                AnalysisLogger.getLogger().debug((Object)("CSquareCreator: dropping " + this.outTable));
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.outTable), (SessionFactory)this.connection);
            }
            catch (Exception e1) {
                AnalysisLogger.getLogger().debug((Object)("CSquareCreator: could not drop " + this.outTable));
            }
            throw new Exception(e.getMessage());
        }
        finally {
            this.shutdown();
            AnalysisLogger.getLogger().debug((Object)("CSquareCreator finished in " + (System.currentTimeMillis() - t0) + " ms"));
        }
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"CSquareCreator shutdown");
        DatabaseUtils.closeDBConnection((SessionFactory)this.connection);
    }
}

