/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

public class FAOOceanAreaConverter {
    public static void main(String[] args) {
        FAOOceanAreaConverter converter = new FAOOceanAreaConverter();
        int quadrant = -1;
        double longitude = -1.0;
        double latitude = -56.1;
        int resolution = 5;
        String conv = converter.FAOOceanArea(quadrant, longitude, latitude, resolution);
        System.out.println(conv);
    }

    public String padLongitude(int longitude) {
        String longi = "" + longitude;
        if (longi.length() == 1) {
            longi = "00" + longi;
        } else if (longi.length() == 2) {
            longi = "0" + longi;
        }
        return longi;
    }

    public String padLatitude(int latitude) {
        String lati = "" + latitude;
        if (lati.length() == 1) {
            lati = "0" + lati;
        }
        return lati;
    }

    public int getQuadrant(double longitude, double latitude) {
        if (longitude >= 0.0 && latitude >= 0.0) {
            return 1;
        }
        if (longitude >= 0.0 && latitude < 0.0) {
            return 2;
        }
        if (longitude < 0.0 && latitude < 0.0) {
            return 3;
        }
        return 4;
    }

    public int[] getBounding(int resolution, double dimension) {
        int lowDim = (int)((double)resolution * Math.floor(dimension / (double)resolution));
        int upDim = (int)((double)resolution * Math.ceil(dimension / (double)resolution));
        int[] bounding = new int[]{lowDim, upDim};
        return bounding;
    }

    public double getDistanceFromCenter(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    public String FAOOceanArea(int quadrant, double longitude, double latitude, int resolution) {
        if (quadrant <= 0 || quadrant > 4) {
            quadrant = this.getQuadrant(longitude, latitude);
        }
        if (longitude > 180.0 || longitude < -180.0) {
            return null;
        }
        if (latitude > 90.0 || latitude < -90.0) {
            return null;
        }
        if (resolution <= 0 || resolution > 90) {
            return null;
        }
        double alongitude = Math.abs(longitude);
        double alatitude = Math.abs(latitude);
        int[] bblons = this.getBounding(resolution, alongitude);
        int[] bblats = this.getBounding(resolution, alatitude);
        int bestlon = -1;
        int bestlat = -1;
        double bestdist = Double.MAX_VALUE;
        for (int bblon : bblons) {
            for (int bblat : bblats) {
                double dist = this.getDistanceFromCenter(bblon, bblat);
                if (!(dist < bestdist)) continue;
                bestdist = dist;
                bestlon = bblon;
                bestlat = bblat;
            }
        }
        String FaoOceanArea = this.getResolutionChar(resolution) + quadrant + this.padLatitude(bestlat) + this.padLongitude(bestlon);
        if (FaoOceanArea.length() != 7) {
            return null;
        }
        return FaoOceanArea;
    }

    public String getResolutionChar(int resolution) {
        if (resolution == 1) {
            return "5";
        }
        if (resolution == 5) {
            return "6";
        }
        if (resolution == 10) {
            return "7";
        }
        if (resolution == 20) {
            return "8";
        }
        if (resolution == 30) {
            return "9";
        }
        return "0";
    }
}

