/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GeoTiffMetadata {
    boolean capturexyz = false;
    public double xScale = -1.0;
    public double yScale = -1.0;
    public double zScale = -1.0;

    public static void main(String[] args) throws Exception {
        String[] argss = new String[]{"C:/Users/coro/Dropbox/Public/geoserver-GetCoverage.image.geotiff"};
        GeoTiffMetadata meta = new GeoTiffMetadata();
        int length = argss.length;
        for (int i = 0; i < length; ++i) {
            meta.readAndDisplayMetadata(argss[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAndDisplayMetadata(String fileName) {
        ImageInputStream iis = null;
        try {
            File file = new File(fileName);
            iis = ImageIO.createImageInputStream(file);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (readers.hasNext()) {
                ImageReader reader = readers.next();
                reader.setInput(iis, true);
                IIOMetadata metadata = reader.getImageMetadata(0);
                String[] names = metadata.getMetadataFormatNames();
                int length = names.length;
                for (int i = 0; i < length; ++i) {
                    AnalysisLogger.getLogger().debug((Object)("Format name: " + names[i]));
                    this.displayMetadata(metadata.getAsTree(names[i]));
                }
            }
            AnalysisLogger.getLogger().debug((Object)("scalex " + this.xScale));
            AnalysisLogger.getLogger().debug((Object)("scaley " + this.yScale));
            AnalysisLogger.getLogger().debug((Object)("scalez " + this.zScale));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (iis != null) {
                try {
                    iis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    void displayMetadata(Node root) {
        this.displayMetadata(root, 0);
    }

    void indent(int level) {
        for (int i = 0; i < level; ++i) {
            System.out.print("    ");
        }
    }

    void displayMetadata(Node node, int level) {
        Node child;
        this.indent(level);
        System.out.print("<" + node.getNodeName());
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node attr = map.item(i);
                String name = attr.getNodeName();
                String value = attr.getNodeValue();
                if (name.equalsIgnoreCase("name") && value.equalsIgnoreCase("ModelPixelScaleTag")) {
                    this.capturexyz = true;
                } else if (name.equalsIgnoreCase("name")) {
                    this.capturexyz = false;
                }
                if (this.capturexyz && name.equalsIgnoreCase("value")) {
                    if (this.xScale < 0.0) {
                        this.xScale = Double.parseDouble(value);
                    } else if (this.yScale < 0.0) {
                        this.yScale = Double.parseDouble(value);
                    } else if (this.zScale < 0.0) {
                        this.zScale = Double.parseDouble(value);
                    }
                }
                System.out.print(" " + attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
            }
        }
        if ((child = node.getFirstChild()) == null) {
            AnalysisLogger.getLogger().debug((Object)"/>");
            return;
        }
        AnalysisLogger.getLogger().debug((Object)">");
        while (child != null) {
            this.displayMetadata(child, level + 1);
            child = child.getNextSibling();
        }
        this.indent(level);
        AnalysisLogger.getLogger().debug((Object)("</" + node.getNodeName() + ">"));
    }
}

