/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.generators;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.interfaces.ActorNode;
import org.gcube.dataanalysis.ecoengine.interfaces.Generator;
import org.gcube.dataanalysis.ecoengine.interfaces.GenericAlgorithm;
import org.gcube.dataanalysis.executor.job.management.DistributedProcessingAgent;

public class D4ScienceDistributedProcessing
implements Generator {
    public static int maxMessagesAllowedPerJob = 20;
    public static boolean forceUpload = true;
    public static String defaultContainerFolder = "PARALLEL_PROCESSING";
    protected AlgorithmConfiguration config;
    protected ActorNode distributedModel;
    protected String mainclass;
    DistributedProcessingAgent agent;

    public D4ScienceDistributedProcessing() {
    }

    public D4ScienceDistributedProcessing(AlgorithmConfiguration config) {
        this.config = config;
        AnalysisLogger.setLogger((String)(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile));
    }

    public void compute() throws Exception {
        try {
            try {
                this.agent.compute();
                this.distributedModel.postProcess(this.agent.hasResentMessages(), false);
            }
            catch (Exception e) {
                this.distributedModel.postProcess(false, true);
                AnalysisLogger.getLogger().error((Object)"ERROR: An Error occurred ", (Throwable)e);
                throw e;
            }
        }
        finally {
            this.shutdown();
        }
    }

    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> distributionModelParams = new ArrayList<StatisticalType>();
        distributionModelParams.add((StatisticalType)new ServiceType(ServiceParameters.USERNAME, "ServiceUserName", "The final user Name"));
        return distributionModelParams;
    }

    public String getResources() {
        return this.agent.getResources();
    }

    public float getStatus() {
        return this.agent.getStatus();
    }

    public StatisticalType getOutput() {
        return this.distributedModel.getOutput();
    }

    public ALG_PROPS[] getSupportedAlgorithms() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.PHENOMENON_VS_PARALLEL_PHENOMENON};
        return p;
    }

    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.D4SCIENCE;
    }

    public void init() throws Exception {
        Properties p = AlgorithmConfiguration.getProperties((String)(String.valueOf(this.config.getConfigPath()) + AlgorithmConfiguration.nodeAlgorithmsFile));
        String model = this.config.getModel();
        String algorithm = null;
        algorithm = model != null && model.length() > 0 ? model : this.config.getAgent();
        this.mainclass = p.getProperty(algorithm);
        this.distributedModel = (ActorNode)Class.forName(this.mainclass).newInstance();
        this.distributedModel.setup(this.config);
        String scope = this.config.getGcubeScope();
        AnalysisLogger.getLogger().info((Object)("Using the following scope for the computation:" + scope));
        String owner = this.config.getParam("ServiceUserName");
        int leftNum = this.distributedModel.getNumberOfLeftElements();
        int rightNum = this.distributedModel.getNumberOfRightElements();
        this.agent = new DistributedProcessingAgent((Serializable)this.config, scope, owner, this.mainclass, this.config.getPersistencePath(), algorithm, defaultContainerFolder, maxMessagesAllowedPerJob, forceUpload, leftNum, rightNum);
        this.agent.setLogger(AnalysisLogger.getLogger());
    }

    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
        AnalysisLogger.setLogger((String)(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile));
    }

    public void shutdown() {
        try {
            this.agent.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.distributedModel.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getLoad() {
        return this.agent.getLoad();
    }

    public String getResourceLoad() {
        return this.agent.getResourceLoad();
    }

    public GenericAlgorithm getAlgorithm() {
        return this.distributedModel;
    }

    public String getDescription() {
        return "A D4Science Cloud Processor for Species Distributions";
    }
}

