/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.transducers.bionym;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.CometMatcherManager;

public class EVBPreprocessing {
    public static String[][] preparsecleaning = new String[][]{{"\u00a0", " ", "3"}, {"\n", " ", "3"}, {" {2,}", " ", "3"}, {"^ ", "", "3"}, {" $", "", "3"}, {"[?]", "", "1"}, {" v(ar)?\\.? ", " v. ", "1"}, {" f(orm(a)?)?.? ", " f. ", "1"}};
    public static String[][] postparsecleaning = new String[][]{{" sp[\\.]?( ?[1-9a-zA-Z])?$", "", "1"}};
    public static String[] preparsecleaningorigins = new String[]{"\u00a0", "\n", " {2,}", "^ ", " $", "[?]", " v(ar)?\\.? ", " f(orm(a)?)?.? "};
    public static String[] preparsecleaningtargets = new String[]{"\u00a0", " ", " ", "", "", "", " v. ", " f. "};
    public static String[] postparsecleaningorigin = new String[]{" sp[\\.]?( ?[1-9a-zA-Z])?$"};
    public static String[] postparsecleaningtargets = new String[]{""};
    public static String[] fuzzymatchorigins = new String[]{"h", "y", "s|k"};
    public static String[] fuzzymatchtargets = new String[]{"''", "i", "c"};

    public static boolean appliesToScientificName(int regexProperty) {
        int t = 1 & regexProperty;
        return t > 0;
    }

    public static boolean appliesToAuthorship(int regexProperty) {
        int t = 2 & regexProperty;
        return t > 0;
    }

    public static List<Tuple<String>> populateTuples(List<String> rawnames) {
        ArrayList<Tuple<String>> preprocessednames = new ArrayList<Tuple<String>>();
        for (String rawn : rawnames) {
            preprocessednames.add((Tuple<String>)new Tuple((Object[])new String[]{rawn, ""}));
        }
        return preprocessednames;
    }

    public List<Tuple<String>> preprocess(String parser, String sandboxFolder, List<String> rawnamesFiltered) throws Exception {
        File FParserinputFile = new File(sandboxFolder, "inputEVBParser.csv");
        File FParseroutputFile = new File(sandboxFolder, "outputEVBParser.csv");
        try {
            FParserinputFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FParseroutputFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String parserinputFile = FParserinputFile.getAbsolutePath();
        String parseroutputFile = FParseroutputFile.getAbsolutePath();
        ArrayList<String> preprocessedrawnames = new ArrayList<String>(rawnamesFiltered);
        int namessize = preprocessedrawnames.size();
        System.out.println("Applying preprocessing to strings");
        int i = 0;
        while (i < namessize) {
            String preprocessedrawname = (String)preprocessedrawnames.get(i);
            int j = 0;
            while (j < preparsecleaningorigins.length) {
                preprocessedrawname = preprocessedrawname.replaceAll(preparsecleaningorigins[j], preparsecleaningtargets[j]);
                ++j;
            }
            ++i;
        }
        System.out.println("Applying parsing");
        CometMatcherManager.dumpCometInput(parserinputFile, EVBPreprocessing.populateTuples(preprocessedrawnames));
        CometMatcherManager.cometParse(sandboxFolder, parser, parseroutputFile, parserinputFile);
        List<Tuple<String>> parsedNames = CometMatcherManager.parseCometParserOutput(parseroutputFile);
        int pnamessize = parsedNames.size();
        System.out.println("Applying postprocessing to " + pnamessize + " strings");
        int i2 = 0;
        while (i2 < pnamessize) {
            String postprocessedrawname = (String)parsedNames.get(i2).getElements().get(0);
            String postprocessedrawauthor = (String)parsedNames.get(i2).getElements().get(1);
            System.out.println("Parsed name: " + postprocessedrawname + " author: " + postprocessedrawauthor);
            int j = 0;
            while (j < postparsecleaningorigin.length) {
                postprocessedrawname = postprocessedrawname.replaceAll(postparsecleaningorigin[j], postparsecleaningtargets[j]);
                ++j;
            }
            ++i2;
        }
        return parsedNames;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Gadus var. morhua".replaceAll(" v(ar)?\\.? ", " v. "));
    }

    public static enum Preprocessors {
        EXPERT_RULES,
        NONE;

    }
}

