/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.algorithms;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.spatialdistributions.AquamapsAlgorithmCore;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;
import org.hibernate.SessionFactory;

public class AquamapsSuitableFunctions {
    public static String countAllSpeciesQuery = "select count(*)  from %1$s;";
    public static String countAll = "EXPLAIN SELECT * FROM %1$s;";
    public static String countCsquareCodeQuery = "select count (*) from %1$s d where oceanarea>0";
    public static String selectAllSpeciesQuery = "select depthmin,meandepth,depthprefmin,pelagic,depthprefmax,depthmax,tempmin,layer,tempprefmin,tempprefmax,tempmax,salinitymin,salinityprefmin,salinityprefmax,salinitymax,primprodmin,primprodprefmin,primprodprefmax,primprodmax,iceconmin,iceconprefmin,iceconprefmax,iceconmax,landdistyn,landdistmin,landdistprefmin,landdistprefmax,landdistmax,nmostlat,smostlat,wmostlong,emostlong,faoareas,speciesid from %1$s order by speciesid limit %2$s offset %3$s;";
    public static String csquareCodeQuery = "select csquarecode,depthmean,depthmax,depthmin, sstanmean,sbtanmean,salinitymean,salinitybmean, primprodmean,iceconann,landdist,oceanarea,centerlat,centerlong,faoaream,eezall,lme from %1$s d where oceanarea>0  order by csquarecode limit %2$s offset %3$s";
    public static String createTableStatement = "CREATE TABLE %1$s ( speciesid character varying, csquarecode character varying, probability real, boundboxyn smallint, faoareayn smallint, faoaream integer, eezall character varying, lme integer) WITH (OIDS=FALSE ) #TABLESPACE#; CREATE INDEX CONCURRENTLY %1$s_idx ON %1$s USING btree (speciesid, csquarecode, faoaream, eezall, lme);";
    public static String metainfo = "boundboxyn, faoareayn, faoaream, eezall, lme";
    public static String selectAllSpeciesObservationQuery = "SELECT speciesid,maxclat,minclat from %1$s;";
    public static String probabilityInsertionStatement = "insert into %1$s (speciesid,csquarecode,probability %ADDEDINFORMATION%) VALUES %2$s";
    public static String deleteDuplicates = "delete from %1$s where speciesid='%2$s'";
    private static String speciesFile = "species.dat";
    private static String csquaresFile = "csquares.dat";
    private static String maxminlatFile = "maxminlat.dat";
    private static String configFile = "config.dat";
    public HashMap<String, List<Object>> allSpeciesObservations;
    public List<Object> speciesVectors;
    public List<Object> environmentVectors;
    public int numberOfSpecies;
    public int numberOfCells;
    public AlgorithmConfiguration currentconfig;
    public HashMap<String, String> currentSpeciesBoundingBoxInfo;
    public String currentFAOAreas;
    public AquamapsAlgorithmCore core;
    public String type;
    public HashMap<String, Object> processedAreas;
    public ConcurrentHashMap<String, Map<String, Float>> completeDistribution;

    public AquamapsSuitableFunctions(AquamapsAlgorithmCore core, String type, AlgorithmConfiguration config) {
        this.core = core;
        this.type = type;
        this.currentconfig = config;
    }

    public float calcProb(Object species, Object area) {
        Map<String, Float> geoDistrib;
        float prob = (float)this.core.getSpeciesProb((Object[])species, (Object[])area);
        String speciesID = AquamapsSuitableFunctions.getMainInfoID(species);
        String csquareCode = AquamapsSuitableFunctions.getGeographicalID(area);
        if (this.completeDistribution == null) {
            this.completeDistribution = new ConcurrentHashMap();
        }
        if ((geoDistrib = this.completeDistribution.get(speciesID)) == null) {
            geoDistrib = new ConcurrentHashMap<String, Float>();
            this.completeDistribution.put(speciesID, geoDistrib);
        }
        if ((double)prob > 0.1) {
            geoDistrib.put(csquareCode, Float.valueOf(prob));
            if (this.processedAreas == null) {
                this.processedAreas = new HashMap();
            }
            this.processedAreas.put(csquareCode, area);
        }
        return prob;
    }

    public HashMap<String, Integer> calculateBoundingBox(Object[] csquarecode) {
        HashMap boundingInfo = this.core.calculateBoundingBox("" + csquarecode[0], this.currentSpeciesBoundingBoxInfo.get("$pass_NS"), this.currentSpeciesBoundingBoxInfo.get("$pass_N"), this.currentSpeciesBoundingBoxInfo.get("$pass_S"), AquamapsAlgorithmCore.getElement((Object[])csquarecode, (int)12), AquamapsAlgorithmCore.getElement((Object[])csquarecode, (int)13), AquamapsAlgorithmCore.getElement((Object[])csquarecode, (int)14), this.currentSpeciesBoundingBoxInfo.get("$paramData_NMostLat"), this.currentSpeciesBoundingBoxInfo.get("$paramData_SMostLat"), this.currentSpeciesBoundingBoxInfo.get("$paramData_WMostLong"), this.currentSpeciesBoundingBoxInfo.get("$paramData_EMostLong"), this.currentFAOAreas, this.currentSpeciesBoundingBoxInfo.get("$northern_hemisphere_adjusted"), this.currentSpeciesBoundingBoxInfo.get("$southern_hemisphere_adjusted"));
        return boundingInfo;
    }

    public void getBoundingBoxInformation(Object[] speciesInfoRow, Object[] speciesObservations) {
        Object[] row = speciesInfoRow;
        String $paramData_NMostLat = AquamapsAlgorithmCore.getElement((Object[])row, (int)28);
        String $paramData_SMostLat = AquamapsAlgorithmCore.getElement((Object[])row, (int)29);
        String $paramData_WMostLong = AquamapsAlgorithmCore.getElement((Object[])row, (int)30);
        String $paramData_EMostLong = AquamapsAlgorithmCore.getElement((Object[])row, (int)31);
        this.currentFAOAreas = AquamapsAlgorithmCore.getElement((Object[])row, (int)32);
        this.currentFAOAreas = this.core.procFAO_2050(this.currentFAOAreas);
        this.currentSpeciesBoundingBoxInfo = this.core.getBoundingBoxInfo($paramData_NMostLat, $paramData_SMostLat, $paramData_WMostLong, $paramData_EMostLong, speciesObservations, this.type);
    }

    public static void writeOnDB(List<String> buffer, String destinationTable, SessionFactory dbHibConnection) {
        int endIndex = buffer.size();
        if (endIndex > 0) {
            System.out.println("\tWriting Buffer is not empty: " + endIndex);
            String $probabilityInsertionStatement = probabilityInsertionStatement.replace("%ADDEDINFORMATION%", "," + metainfo);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < endIndex) {
                sb.append("(" + buffer.get(i) + ")");
                if (i < endIndex - 1) {
                    sb.append(",");
                }
                ++i;
            }
            String insertionString = String.format($probabilityInsertionStatement, destinationTable, sb.toString());
            try {
                DatabaseFactory.executeSQLUpdate((String)insertionString, (SessionFactory)dbHibConnection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("\tWarning : writing buffer is empty!");
        }
        System.out.println("\tWriting on DB FINISHED");
    }

    public void dumpAll(String path) throws Exception {
        Transformations.dumpObjectToFile((String)(String.valueOf(path) + configFile), (Object)this.currentconfig);
    }

    public void rebuildConfig(String configFile) throws Exception {
        FileInputStream fis = new FileInputStream(new File(configFile));
        this.currentconfig = (AlgorithmConfiguration)new XStream().fromXML((InputStream)fis);
        fis.close();
    }

    public void rebuildAll(int cellOrdinal, int chunksize, int speciesOrdinal, int speciesChunkSize, String pathToFiles) throws Exception {
    }

    public String getAdditionalInformation(Object species, Object area) {
        Object[] arearray = (Object[])area;
        HashMap<String, Integer> boundingInfo = this.calculateBoundingBox(arearray);
        String addedInformation = "'" + boundingInfo.get("$InBox") + "','" + boundingInfo.get("$InFAO") + "','" + arearray[14] + "','" + arearray[15] + "','" + arearray[16] + "'";
        return addedInformation;
    }

    public static String getMainInfoID(Object speciesInfo) {
        String s = "" + ((Object[])speciesInfo)[33];
        return s;
    }

    public static String getGeographicalID(Object geoInfo) {
        String s = "" + ((Object[])geoInfo)[0];
        return s;
    }
}

